/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.FilterListCopier;
import software.amazon.awssdk.services.bedrockagent.model.WebCrawlerLimits;
import software.amazon.awssdk.services.bedrockagent.model.WebScopeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebCrawlerConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebCrawlerConfiguration> {
    private static final SdkField<WebCrawlerLimits> CRAWLER_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("crawlerLimits").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::crawlerLimits)).setter(WebCrawlerConfiguration.setter(Builder::crawlerLimits)).constructor(WebCrawlerLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crawlerLimits").build()}).build();
    private static final SdkField<List<String>> EXCLUSION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exclusionFilters").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::exclusionFilters)).setter(WebCrawlerConfiguration.setter(Builder::exclusionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUSION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inclusionFilters").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::inclusionFilters)).setter(WebCrawlerConfiguration.setter(Builder::inclusionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inclusionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scope").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::scopeAsString)).setter(WebCrawlerConfiguration.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final SdkField<String> USER_AGENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userAgent").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::userAgent)).setter(WebCrawlerConfiguration.setter(Builder::userAgent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAgent").build()}).build();
    private static final SdkField<String> USER_AGENT_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userAgentHeader").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::userAgentHeader)).setter(WebCrawlerConfiguration.setter(Builder::userAgentHeader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAgentHeader").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_LIMITS_FIELD, EXCLUSION_FILTERS_FIELD, INCLUSION_FILTERS_FIELD, SCOPE_FIELD, USER_AGENT_FIELD, USER_AGENT_HEADER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WebCrawlerConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final WebCrawlerLimits crawlerLimits;
    private final List<String> exclusionFilters;
    private final List<String> inclusionFilters;
    private final String scope;
    private final String userAgent;
    private final String userAgentHeader;

    private WebCrawlerConfiguration(BuilderImpl builder) {
        this.crawlerLimits = builder.crawlerLimits;
        this.exclusionFilters = builder.exclusionFilters;
        this.inclusionFilters = builder.inclusionFilters;
        this.scope = builder.scope;
        this.userAgent = builder.userAgent;
        this.userAgentHeader = builder.userAgentHeader;
    }

    public final WebCrawlerLimits crawlerLimits() {
        return this.crawlerLimits;
    }

    public final boolean hasExclusionFilters() {
        return this.exclusionFilters != null && !(this.exclusionFilters instanceof SdkAutoConstructList);
    }

    public final List<String> exclusionFilters() {
        return this.exclusionFilters;
    }

    public final boolean hasInclusionFilters() {
        return this.inclusionFilters != null && !(this.inclusionFilters instanceof SdkAutoConstructList);
    }

    public final List<String> inclusionFilters() {
        return this.inclusionFilters;
    }

    public final WebScopeType scope() {
        return WebScopeType.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final String userAgent() {
        return this.userAgent;
    }

    public final String userAgentHeader() {
        return this.userAgentHeader;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerLimits());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionFilters() ? this.exclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionFilters() ? this.inclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAgent());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAgentHeader());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebCrawlerConfiguration)) {
            return false;
        }
        WebCrawlerConfiguration other = (WebCrawlerConfiguration)obj;
        return Objects.equals(this.crawlerLimits(), other.crawlerLimits()) && this.hasExclusionFilters() == other.hasExclusionFilters() && Objects.equals(this.exclusionFilters(), other.exclusionFilters()) && this.hasInclusionFilters() == other.hasInclusionFilters() && Objects.equals(this.inclusionFilters(), other.inclusionFilters()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.userAgent(), other.userAgent()) && Objects.equals(this.userAgentHeader(), other.userAgentHeader());
    }

    public final String toString() {
        return ToString.builder((String)"WebCrawlerConfiguration").add("CrawlerLimits", (Object)this.crawlerLimits()).add("ExclusionFilters", (Object)(this.exclusionFilters() == null ? null : "*** Sensitive Data Redacted ***")).add("InclusionFilters", (Object)(this.inclusionFilters() == null ? null : "*** Sensitive Data Redacted ***")).add("Scope", (Object)this.scopeAsString()).add("UserAgent", (Object)(this.userAgent() == null ? null : "*** Sensitive Data Redacted ***")).add("UserAgentHeader", (Object)(this.userAgentHeader() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "crawlerLimits": {
                return Optional.ofNullable(clazz.cast(this.crawlerLimits()));
            }
            case "exclusionFilters": {
                return Optional.ofNullable(clazz.cast(this.exclusionFilters()));
            }
            case "inclusionFilters": {
                return Optional.ofNullable(clazz.cast(this.inclusionFilters()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "userAgent": {
                return Optional.ofNullable(clazz.cast(this.userAgent()));
            }
            case "userAgentHeader": {
                return Optional.ofNullable(clazz.cast(this.userAgentHeader()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("crawlerLimits", CRAWLER_LIMITS_FIELD);
        map.put("exclusionFilters", EXCLUSION_FILTERS_FIELD);
        map.put("inclusionFilters", INCLUSION_FILTERS_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("userAgent", USER_AGENT_FIELD);
        map.put("userAgentHeader", USER_AGENT_HEADER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebCrawlerConfiguration, T> g) {
        return obj -> g.apply((WebCrawlerConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WebCrawlerLimits crawlerLimits;
        private List<String> exclusionFilters = DefaultSdkAutoConstructList.getInstance();
        private List<String> inclusionFilters = DefaultSdkAutoConstructList.getInstance();
        private String scope;
        private String userAgent;
        private String userAgentHeader;

        private BuilderImpl() {
        }

        private BuilderImpl(WebCrawlerConfiguration model) {
            this.crawlerLimits(model.crawlerLimits);
            this.exclusionFilters(model.exclusionFilters);
            this.inclusionFilters(model.inclusionFilters);
            this.scope(model.scope);
            this.userAgent(model.userAgent);
            this.userAgentHeader(model.userAgentHeader);
        }

        public final WebCrawlerLimits.Builder getCrawlerLimits() {
            return this.crawlerLimits != null ? this.crawlerLimits.toBuilder() : null;
        }

        public final void setCrawlerLimits(WebCrawlerLimits.BuilderImpl crawlerLimits) {
            this.crawlerLimits = crawlerLimits != null ? crawlerLimits.build() : null;
        }

        @Override
        public final Builder crawlerLimits(WebCrawlerLimits crawlerLimits) {
            this.crawlerLimits = crawlerLimits;
            return this;
        }

        public final Collection<String> getExclusionFilters() {
            if (this.exclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionFilters;
        }

        public final void setExclusionFilters(Collection<String> exclusionFilters) {
            this.exclusionFilters = FilterListCopier.copy(exclusionFilters);
        }

        @Override
        public final Builder exclusionFilters(Collection<String> exclusionFilters) {
            this.exclusionFilters = FilterListCopier.copy(exclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFilters(String ... exclusionFilters) {
            this.exclusionFilters(Arrays.asList(exclusionFilters));
            return this;
        }

        public final Collection<String> getInclusionFilters() {
            if (this.inclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionFilters;
        }

        public final void setInclusionFilters(Collection<String> inclusionFilters) {
            this.inclusionFilters = FilterListCopier.copy(inclusionFilters);
        }

        @Override
        public final Builder inclusionFilters(Collection<String> inclusionFilters) {
            this.inclusionFilters = FilterListCopier.copy(inclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFilters(String ... inclusionFilters) {
            this.inclusionFilters(Arrays.asList(inclusionFilters));
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(WebScopeType scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getUserAgent() {
            return this.userAgent;
        }

        public final void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Override
        public final Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public final String getUserAgentHeader() {
            return this.userAgentHeader;
        }

        public final void setUserAgentHeader(String userAgentHeader) {
            this.userAgentHeader = userAgentHeader;
        }

        @Override
        public final Builder userAgentHeader(String userAgentHeader) {
            this.userAgentHeader = userAgentHeader;
            return this;
        }

        public WebCrawlerConfiguration build() {
            return new WebCrawlerConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebCrawlerConfiguration> {
        public Builder crawlerLimits(WebCrawlerLimits var1);

        default public Builder crawlerLimits(Consumer<WebCrawlerLimits.Builder> crawlerLimits) {
            return this.crawlerLimits((WebCrawlerLimits)((WebCrawlerLimits.Builder)WebCrawlerLimits.builder().applyMutation(crawlerLimits)).build());
        }

        public Builder exclusionFilters(Collection<String> var1);

        public Builder exclusionFilters(String ... var1);

        public Builder inclusionFilters(Collection<String> var1);

        public Builder inclusionFilters(String ... var1);

        public Builder scope(String var1);

        public Builder scope(WebScopeType var1);

        public Builder userAgent(String var1);

        public Builder userAgentHeader(String var1);
    }
}

