/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.AudioConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.AudioConfigurationsCopier;
import software.amazon.awssdk.services.bedrockagent.model.EmbeddingDataType;
import software.amazon.awssdk.services.bedrockagent.model.VideoConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.VideoConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BedrockEmbeddingModelConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BedrockEmbeddingModelConfiguration> {
    private static final SdkField<Integer> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dimensions").getter(BedrockEmbeddingModelConfiguration.getter(BedrockEmbeddingModelConfiguration::dimensions)).setter(BedrockEmbeddingModelConfiguration.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensions").build()}).build();
    private static final SdkField<String> EMBEDDING_DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("embeddingDataType").getter(BedrockEmbeddingModelConfiguration.getter(BedrockEmbeddingModelConfiguration::embeddingDataTypeAsString)).setter(BedrockEmbeddingModelConfiguration.setter(Builder::embeddingDataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddingDataType").build()}).build();
    private static final SdkField<List<AudioConfiguration>> AUDIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("audio").getter(BedrockEmbeddingModelConfiguration.getter(BedrockEmbeddingModelConfiguration::audio)).setter(BedrockEmbeddingModelConfiguration.setter(Builder::audio)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audio").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<VideoConfiguration>> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("video").getter(BedrockEmbeddingModelConfiguration.getter(BedrockEmbeddingModelConfiguration::video)).setter(BedrockEmbeddingModelConfiguration.setter(Builder::video)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("video").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VideoConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, EMBEDDING_DATA_TYPE_FIELD, AUDIO_FIELD, VIDEO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BedrockEmbeddingModelConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer dimensions;
    private final String embeddingDataType;
    private final List<AudioConfiguration> audio;
    private final List<VideoConfiguration> video;

    private BedrockEmbeddingModelConfiguration(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.embeddingDataType = builder.embeddingDataType;
        this.audio = builder.audio;
        this.video = builder.video;
    }

    public final Integer dimensions() {
        return this.dimensions;
    }

    public final EmbeddingDataType embeddingDataType() {
        return EmbeddingDataType.fromValue(this.embeddingDataType);
    }

    public final String embeddingDataTypeAsString() {
        return this.embeddingDataType;
    }

    public final boolean hasAudio() {
        return this.audio != null && !(this.audio instanceof SdkAutoConstructList);
    }

    public final List<AudioConfiguration> audio() {
        return this.audio;
    }

    public final boolean hasVideo() {
        return this.video != null && !(this.video instanceof SdkAutoConstructList);
    }

    public final List<VideoConfiguration> video() {
        return this.video;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.embeddingDataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudio() ? this.audio() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVideo() ? this.video() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockEmbeddingModelConfiguration)) {
            return false;
        }
        BedrockEmbeddingModelConfiguration other = (BedrockEmbeddingModelConfiguration)obj;
        return Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.embeddingDataTypeAsString(), other.embeddingDataTypeAsString()) && this.hasAudio() == other.hasAudio() && Objects.equals(this.audio(), other.audio()) && this.hasVideo() == other.hasVideo() && Objects.equals(this.video(), other.video());
    }

    public final String toString() {
        return ToString.builder((String)"BedrockEmbeddingModelConfiguration").add("Dimensions", (Object)this.dimensions()).add("EmbeddingDataType", (Object)this.embeddingDataTypeAsString()).add("Audio", this.hasAudio() ? this.audio() : null).add("Video", this.hasVideo() ? this.video() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "embeddingDataType": {
                return Optional.ofNullable(clazz.cast(this.embeddingDataTypeAsString()));
            }
            case "audio": {
                return Optional.ofNullable(clazz.cast(this.audio()));
            }
            case "video": {
                return Optional.ofNullable(clazz.cast(this.video()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dimensions", DIMENSIONS_FIELD);
        map.put("embeddingDataType", EMBEDDING_DATA_TYPE_FIELD);
        map.put("audio", AUDIO_FIELD);
        map.put("video", VIDEO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BedrockEmbeddingModelConfiguration, T> g) {
        return obj -> g.apply((BedrockEmbeddingModelConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer dimensions;
        private String embeddingDataType;
        private List<AudioConfiguration> audio = DefaultSdkAutoConstructList.getInstance();
        private List<VideoConfiguration> video = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockEmbeddingModelConfiguration model) {
            this.dimensions(model.dimensions);
            this.embeddingDataType(model.embeddingDataType);
            this.audio(model.audio);
            this.video(model.video);
        }

        public final Integer getDimensions() {
            return this.dimensions;
        }

        public final void setDimensions(Integer dimensions) {
            this.dimensions = dimensions;
        }

        @Override
        public final Builder dimensions(Integer dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final String getEmbeddingDataType() {
            return this.embeddingDataType;
        }

        public final void setEmbeddingDataType(String embeddingDataType) {
            this.embeddingDataType = embeddingDataType;
        }

        @Override
        public final Builder embeddingDataType(String embeddingDataType) {
            this.embeddingDataType = embeddingDataType;
            return this;
        }

        @Override
        public final Builder embeddingDataType(EmbeddingDataType embeddingDataType) {
            this.embeddingDataType(embeddingDataType == null ? null : embeddingDataType.toString());
            return this;
        }

        public final List<AudioConfiguration.Builder> getAudio() {
            List<AudioConfiguration.Builder> result = AudioConfigurationsCopier.copyToBuilder(this.audio);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudio(Collection<AudioConfiguration.BuilderImpl> audio) {
            this.audio = AudioConfigurationsCopier.copyFromBuilder(audio);
        }

        @Override
        public final Builder audio(Collection<AudioConfiguration> audio) {
            this.audio = AudioConfigurationsCopier.copy(audio);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audio(AudioConfiguration ... audio) {
            this.audio(Arrays.asList(audio));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audio(Consumer<AudioConfiguration.Builder> ... audio) {
            this.audio(Stream.of(audio).map(c -> (AudioConfiguration)((AudioConfiguration.Builder)AudioConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VideoConfiguration.Builder> getVideo() {
            List<VideoConfiguration.Builder> result = VideoConfigurationsCopier.copyToBuilder(this.video);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVideo(Collection<VideoConfiguration.BuilderImpl> video) {
            this.video = VideoConfigurationsCopier.copyFromBuilder(video);
        }

        @Override
        public final Builder video(Collection<VideoConfiguration> video) {
            this.video = VideoConfigurationsCopier.copy(video);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder video(VideoConfiguration ... video) {
            this.video(Arrays.asList(video));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder video(Consumer<VideoConfiguration.Builder> ... video) {
            this.video(Stream.of(video).map(c -> (VideoConfiguration)((VideoConfiguration.Builder)VideoConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BedrockEmbeddingModelConfiguration build() {
            return new BedrockEmbeddingModelConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BedrockEmbeddingModelConfiguration> {
        public Builder dimensions(Integer var1);

        public Builder embeddingDataType(String var1);

        public Builder embeddingDataType(EmbeddingDataType var1);

        public Builder audio(Collection<AudioConfiguration> var1);

        public Builder audio(AudioConfiguration ... var1);

        public Builder audio(Consumer<AudioConfiguration.Builder> ... var1);

        public Builder video(Collection<VideoConfiguration> var1);

        public Builder video(VideoConfiguration ... var1);

        public Builder video(Consumer<VideoConfiguration.Builder> ... var1);
    }
}

