/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentAsyncClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBasesRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBasesResponse;

public class ListKnowledgeBasesPublisher
implements SdkPublisher<ListKnowledgeBasesResponse> {
    private final BedrockAgentAsyncClient client;
    private final ListKnowledgeBasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKnowledgeBasesPublisher(BedrockAgentAsyncClient client, ListKnowledgeBasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKnowledgeBasesPublisher(BedrockAgentAsyncClient client, ListKnowledgeBasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKnowledgeBasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKnowledgeBasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<KnowledgeBaseSummary> knowledgeBaseSummaries() {
        return this.flatMapIterable(response -> response.knowledgeBaseSummaries());
    }

    private class ListKnowledgeBasesResponseFetcher
    implements AsyncPageFetcher<ListKnowledgeBasesResponse> {
        private ListKnowledgeBasesResponseFetcher() {
        }

        public boolean hasNextPage(ListKnowledgeBasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListKnowledgeBasesResponse> nextPage(ListKnowledgeBasesResponse previousPage) {
            if (previousPage == null) {
                return ListKnowledgeBasesPublisher.this.client.listKnowledgeBases(ListKnowledgeBasesPublisher.this.firstRequest);
            }
            return ListKnowledgeBasesPublisher.this.client.listKnowledgeBases((ListKnowledgeBasesRequest)((Object)ListKnowledgeBasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

