/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ByteContentDoc
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ByteContentDoc> {
    private static final SdkField<String> MIME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mimeType").getter(ByteContentDoc.getter(ByteContentDoc::mimeType)).setter(ByteContentDoc.setter(Builder::mimeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mimeType").build()}).build();
    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("data").getter(ByteContentDoc.getter(ByteContentDoc::data)).setter(ByteContentDoc.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIME_TYPE_FIELD, DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ByteContentDoc.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mimeType;
    private final SdkBytes data;

    private ByteContentDoc(BuilderImpl builder) {
        this.mimeType = builder.mimeType;
        this.data = builder.data;
    }

    public final String mimeType() {
        return this.mimeType;
    }

    public final SdkBytes data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mimeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteContentDoc)) {
            return false;
        }
        ByteContentDoc other = (ByteContentDoc)obj;
        return Objects.equals(this.mimeType(), other.mimeType()) && Objects.equals(this.data(), other.data());
    }

    public final String toString() {
        return ToString.builder((String)"ByteContentDoc").add("MimeType", (Object)this.mimeType()).add("Data", (Object)(this.data() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mimeType": {
                return Optional.ofNullable(clazz.cast(this.mimeType()));
            }
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mimeType", MIME_TYPE_FIELD);
        map.put("data", DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ByteContentDoc, T> g) {
        return obj -> g.apply((ByteContentDoc)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mimeType;
        private SdkBytes data;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteContentDoc model) {
            this.mimeType(model.mimeType);
            this.data(model.data);
        }

        public final String getMimeType() {
            return this.mimeType;
        }

        public final void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public final Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public final ByteBuffer getData() {
            return this.data == null ? null : this.data.asByteBuffer();
        }

        public final void setData(ByteBuffer data) {
            this.data(data == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)data));
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        public ByteContentDoc build() {
            return new ByteContentDoc(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ByteContentDoc> {
        public Builder mimeType(String var1);

        public Builder data(SdkBytes var1);
    }
}

