/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagent.model.AgentCollaboration;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.CustomOrchestration;
import software.amazon.awssdk.services.bedrockagent.model.GuardrailConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.MemoryConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.OrchestrationType;
import software.amazon.awssdk.services.bedrockagent.model.PromptOverrideConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAgentRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, CreateAgentRequest> {
    private static final SdkField<String> AGENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentName").getter(CreateAgentRequest.getter(CreateAgentRequest::agentName)).setter(CreateAgentRequest.setter(Builder::agentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAgentRequest.getter(CreateAgentRequest::clientToken)).setter(CreateAgentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instruction").getter(CreateAgentRequest.getter(CreateAgentRequest::instruction)).setter(CreateAgentRequest.setter(Builder::instruction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instruction").build()}).build();
    private static final SdkField<String> FOUNDATION_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("foundationModel").getter(CreateAgentRequest.getter(CreateAgentRequest::foundationModel)).setter(CreateAgentRequest.setter(Builder::foundationModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("foundationModel").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAgentRequest.getter(CreateAgentRequest::description)).setter(CreateAgentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ORCHESTRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("orchestrationType").getter(CreateAgentRequest.getter(CreateAgentRequest::orchestrationTypeAsString)).setter(CreateAgentRequest.setter(Builder::orchestrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationType").build()}).build();
    private static final SdkField<CustomOrchestration> CUSTOM_ORCHESTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customOrchestration").getter(CreateAgentRequest.getter(CreateAgentRequest::customOrchestration)).setter(CreateAgentRequest.setter(Builder::customOrchestration)).constructor(CustomOrchestration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customOrchestration").build()}).build();
    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds").getter(CreateAgentRequest.getter(CreateAgentRequest::idleSessionTTLInSeconds)).setter(CreateAgentRequest.setter(Builder::idleSessionTTLInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build()}).build();
    private static final SdkField<String> AGENT_RESOURCE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentResourceRoleArn").getter(CreateAgentRequest.getter(CreateAgentRequest::agentResourceRoleArn)).setter(CreateAgentRequest.setter(Builder::agentResourceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentResourceRoleArn").build()}).build();
    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerEncryptionKeyArn").getter(CreateAgentRequest.getter(CreateAgentRequest::customerEncryptionKeyArn)).setter(CreateAgentRequest.setter(Builder::customerEncryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAgentRequest.getter(CreateAgentRequest::tags)).setter(CreateAgentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<PromptOverrideConfiguration> PROMPT_OVERRIDE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("promptOverrideConfiguration").getter(CreateAgentRequest.getter(CreateAgentRequest::promptOverrideConfiguration)).setter(CreateAgentRequest.setter(Builder::promptOverrideConfiguration)).constructor(PromptOverrideConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptOverrideConfiguration").build()}).build();
    private static final SdkField<GuardrailConfiguration> GUARDRAIL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrailConfiguration").getter(CreateAgentRequest.getter(CreateAgentRequest::guardrailConfiguration)).setter(CreateAgentRequest.setter(Builder::guardrailConfiguration)).constructor(GuardrailConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build()}).build();
    private static final SdkField<MemoryConfiguration> MEMORY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("memoryConfiguration").getter(CreateAgentRequest.getter(CreateAgentRequest::memoryConfiguration)).setter(CreateAgentRequest.setter(Builder::memoryConfiguration)).constructor(MemoryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryConfiguration").build()}).build();
    private static final SdkField<String> AGENT_COLLABORATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentCollaboration").getter(CreateAgentRequest.getter(CreateAgentRequest::agentCollaborationAsString)).setter(CreateAgentRequest.setter(Builder::agentCollaboration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentCollaboration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_NAME_FIELD, CLIENT_TOKEN_FIELD, INSTRUCTION_FIELD, FOUNDATION_MODEL_FIELD, DESCRIPTION_FIELD, ORCHESTRATION_TYPE_FIELD, CUSTOM_ORCHESTRATION_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, AGENT_RESOURCE_ROLE_ARN_FIELD, CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, TAGS_FIELD, PROMPT_OVERRIDE_CONFIGURATION_FIELD, GUARDRAIL_CONFIGURATION_FIELD, MEMORY_CONFIGURATION_FIELD, AGENT_COLLABORATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAgentRequest.memberNameToFieldInitializer();
    private final String agentName;
    private final String clientToken;
    private final String instruction;
    private final String foundationModel;
    private final String description;
    private final String orchestrationType;
    private final CustomOrchestration customOrchestration;
    private final Integer idleSessionTTLInSeconds;
    private final String agentResourceRoleArn;
    private final String customerEncryptionKeyArn;
    private final Map<String, String> tags;
    private final PromptOverrideConfiguration promptOverrideConfiguration;
    private final GuardrailConfiguration guardrailConfiguration;
    private final MemoryConfiguration memoryConfiguration;
    private final String agentCollaboration;

    private CreateAgentRequest(BuilderImpl builder) {
        super(builder);
        this.agentName = builder.agentName;
        this.clientToken = builder.clientToken;
        this.instruction = builder.instruction;
        this.foundationModel = builder.foundationModel;
        this.description = builder.description;
        this.orchestrationType = builder.orchestrationType;
        this.customOrchestration = builder.customOrchestration;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.agentResourceRoleArn = builder.agentResourceRoleArn;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.tags = builder.tags;
        this.promptOverrideConfiguration = builder.promptOverrideConfiguration;
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.memoryConfiguration = builder.memoryConfiguration;
        this.agentCollaboration = builder.agentCollaboration;
    }

    public final String agentName() {
        return this.agentName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String instruction() {
        return this.instruction;
    }

    public final String foundationModel() {
        return this.foundationModel;
    }

    public final String description() {
        return this.description;
    }

    public final OrchestrationType orchestrationType() {
        return OrchestrationType.fromValue(this.orchestrationType);
    }

    public final String orchestrationTypeAsString() {
        return this.orchestrationType;
    }

    public final CustomOrchestration customOrchestration() {
        return this.customOrchestration;
    }

    public final Integer idleSessionTTLInSeconds() {
        return this.idleSessionTTLInSeconds;
    }

    public final String agentResourceRoleArn() {
        return this.agentResourceRoleArn;
    }

    public final String customerEncryptionKeyArn() {
        return this.customerEncryptionKeyArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final PromptOverrideConfiguration promptOverrideConfiguration() {
        return this.promptOverrideConfiguration;
    }

    public final GuardrailConfiguration guardrailConfiguration() {
        return this.guardrailConfiguration;
    }

    public final MemoryConfiguration memoryConfiguration() {
        return this.memoryConfiguration;
    }

    public final AgentCollaboration agentCollaboration() {
        return AgentCollaboration.fromValue(this.agentCollaboration);
    }

    public final String agentCollaborationAsString() {
        return this.agentCollaboration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instruction());
        hashCode = 31 * hashCode + Objects.hashCode(this.foundationModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.orchestrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customOrchestration());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentResourceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.promptOverrideConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentCollaborationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentRequest)) {
            return false;
        }
        CreateAgentRequest other = (CreateAgentRequest)((Object)obj);
        return Objects.equals(this.agentName(), other.agentName()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.instruction(), other.instruction()) && Objects.equals(this.foundationModel(), other.foundationModel()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.orchestrationTypeAsString(), other.orchestrationTypeAsString()) && Objects.equals(this.customOrchestration(), other.customOrchestration()) && Objects.equals(this.idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds()) && Objects.equals(this.agentResourceRoleArn(), other.agentResourceRoleArn()) && Objects.equals(this.customerEncryptionKeyArn(), other.customerEncryptionKeyArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.promptOverrideConfiguration(), other.promptOverrideConfiguration()) && Objects.equals(this.guardrailConfiguration(), other.guardrailConfiguration()) && Objects.equals(this.memoryConfiguration(), other.memoryConfiguration()) && Objects.equals(this.agentCollaborationAsString(), other.agentCollaborationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAgentRequest").add("AgentName", (Object)this.agentName()).add("ClientToken", (Object)this.clientToken()).add("Instruction", (Object)(this.instruction() == null ? null : "*** Sensitive Data Redacted ***")).add("FoundationModel", (Object)this.foundationModel()).add("Description", (Object)this.description()).add("OrchestrationType", (Object)this.orchestrationTypeAsString()).add("CustomOrchestration", (Object)this.customOrchestration()).add("IdleSessionTTLInSeconds", (Object)this.idleSessionTTLInSeconds()).add("AgentResourceRoleArn", (Object)this.agentResourceRoleArn()).add("CustomerEncryptionKeyArn", (Object)this.customerEncryptionKeyArn()).add("Tags", this.hasTags() ? this.tags() : null).add("PromptOverrideConfiguration", (Object)(this.promptOverrideConfiguration() == null ? null : "*** Sensitive Data Redacted ***")).add("GuardrailConfiguration", (Object)this.guardrailConfiguration()).add("MemoryConfiguration", (Object)this.memoryConfiguration()).add("AgentCollaboration", (Object)this.agentCollaborationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentName": {
                return Optional.ofNullable(clazz.cast(this.agentName()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "instruction": {
                return Optional.ofNullable(clazz.cast(this.instruction()));
            }
            case "foundationModel": {
                return Optional.ofNullable(clazz.cast(this.foundationModel()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "orchestrationType": {
                return Optional.ofNullable(clazz.cast(this.orchestrationTypeAsString()));
            }
            case "customOrchestration": {
                return Optional.ofNullable(clazz.cast(this.customOrchestration()));
            }
            case "idleSessionTTLInSeconds": {
                return Optional.ofNullable(clazz.cast(this.idleSessionTTLInSeconds()));
            }
            case "agentResourceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.agentResourceRoleArn()));
            }
            case "customerEncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.customerEncryptionKeyArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "promptOverrideConfiguration": {
                return Optional.ofNullable(clazz.cast(this.promptOverrideConfiguration()));
            }
            case "guardrailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.guardrailConfiguration()));
            }
            case "memoryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.memoryConfiguration()));
            }
            case "agentCollaboration": {
                return Optional.ofNullable(clazz.cast(this.agentCollaborationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agentName", AGENT_NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("instruction", INSTRUCTION_FIELD);
        map.put("foundationModel", FOUNDATION_MODEL_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("orchestrationType", ORCHESTRATION_TYPE_FIELD);
        map.put("customOrchestration", CUSTOM_ORCHESTRATION_FIELD);
        map.put("idleSessionTTLInSeconds", IDLE_SESSION_TTL_IN_SECONDS_FIELD);
        map.put("agentResourceRoleArn", AGENT_RESOURCE_ROLE_ARN_FIELD);
        map.put("customerEncryptionKeyArn", CUSTOMER_ENCRYPTION_KEY_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("promptOverrideConfiguration", PROMPT_OVERRIDE_CONFIGURATION_FIELD);
        map.put("guardrailConfiguration", GUARDRAIL_CONFIGURATION_FIELD);
        map.put("memoryConfiguration", MEMORY_CONFIGURATION_FIELD);
        map.put("agentCollaboration", AGENT_COLLABORATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAgentRequest, T> g) {
        return obj -> g.apply((CreateAgentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String agentName;
        private String clientToken;
        private String instruction;
        private String foundationModel;
        private String description;
        private String orchestrationType;
        private CustomOrchestration customOrchestration;
        private Integer idleSessionTTLInSeconds;
        private String agentResourceRoleArn;
        private String customerEncryptionKeyArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private PromptOverrideConfiguration promptOverrideConfiguration;
        private GuardrailConfiguration guardrailConfiguration;
        private MemoryConfiguration memoryConfiguration;
        private String agentCollaboration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgentRequest model) {
            super(model);
            this.agentName(model.agentName);
            this.clientToken(model.clientToken);
            this.instruction(model.instruction);
            this.foundationModel(model.foundationModel);
            this.description(model.description);
            this.orchestrationType(model.orchestrationType);
            this.customOrchestration(model.customOrchestration);
            this.idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            this.agentResourceRoleArn(model.agentResourceRoleArn);
            this.customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            this.tags(model.tags);
            this.promptOverrideConfiguration(model.promptOverrideConfiguration);
            this.guardrailConfiguration(model.guardrailConfiguration);
            this.memoryConfiguration(model.memoryConfiguration);
            this.agentCollaboration(model.agentCollaboration);
        }

        public final String getAgentName() {
            return this.agentName;
        }

        public final void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        @Override
        public final Builder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getInstruction() {
            return this.instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final String getFoundationModel() {
            return this.foundationModel;
        }

        public final void setFoundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
        }

        @Override
        public final Builder foundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getOrchestrationType() {
            return this.orchestrationType;
        }

        public final void setOrchestrationType(String orchestrationType) {
            this.orchestrationType = orchestrationType;
        }

        @Override
        public final Builder orchestrationType(String orchestrationType) {
            this.orchestrationType = orchestrationType;
            return this;
        }

        @Override
        public final Builder orchestrationType(OrchestrationType orchestrationType) {
            this.orchestrationType(orchestrationType == null ? null : orchestrationType.toString());
            return this;
        }

        public final CustomOrchestration.Builder getCustomOrchestration() {
            return this.customOrchestration != null ? this.customOrchestration.toBuilder() : null;
        }

        public final void setCustomOrchestration(CustomOrchestration.BuilderImpl customOrchestration) {
            this.customOrchestration = customOrchestration != null ? customOrchestration.build() : null;
        }

        @Override
        public final Builder customOrchestration(CustomOrchestration customOrchestration) {
            this.customOrchestration = customOrchestration;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return this.idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final String getAgentResourceRoleArn() {
            return this.agentResourceRoleArn;
        }

        public final void setAgentResourceRoleArn(String agentResourceRoleArn) {
            this.agentResourceRoleArn = agentResourceRoleArn;
        }

        @Override
        public final Builder agentResourceRoleArn(String agentResourceRoleArn) {
            this.agentResourceRoleArn = agentResourceRoleArn;
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return this.customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final PromptOverrideConfiguration.Builder getPromptOverrideConfiguration() {
            return this.promptOverrideConfiguration != null ? this.promptOverrideConfiguration.toBuilder() : null;
        }

        public final void setPromptOverrideConfiguration(PromptOverrideConfiguration.BuilderImpl promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration != null ? promptOverrideConfiguration.build() : null;
        }

        @Override
        public final Builder promptOverrideConfiguration(PromptOverrideConfiguration promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration;
            return this;
        }

        public final GuardrailConfiguration.Builder getGuardrailConfiguration() {
            return this.guardrailConfiguration != null ? this.guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfiguration.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final MemoryConfiguration.Builder getMemoryConfiguration() {
            return this.memoryConfiguration != null ? this.memoryConfiguration.toBuilder() : null;
        }

        public final void setMemoryConfiguration(MemoryConfiguration.BuilderImpl memoryConfiguration) {
            this.memoryConfiguration = memoryConfiguration != null ? memoryConfiguration.build() : null;
        }

        @Override
        public final Builder memoryConfiguration(MemoryConfiguration memoryConfiguration) {
            this.memoryConfiguration = memoryConfiguration;
            return this;
        }

        public final String getAgentCollaboration() {
            return this.agentCollaboration;
        }

        public final void setAgentCollaboration(String agentCollaboration) {
            this.agentCollaboration = agentCollaboration;
        }

        @Override
        public final Builder agentCollaboration(String agentCollaboration) {
            this.agentCollaboration = agentCollaboration;
            return this;
        }

        @Override
        public final Builder agentCollaboration(AgentCollaboration agentCollaboration) {
            this.agentCollaboration(agentCollaboration == null ? null : agentCollaboration.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAgentRequest build() {
            return new CreateAgentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAgentRequest> {
        public Builder agentName(String var1);

        public Builder clientToken(String var1);

        public Builder instruction(String var1);

        public Builder foundationModel(String var1);

        public Builder description(String var1);

        public Builder orchestrationType(String var1);

        public Builder orchestrationType(OrchestrationType var1);

        public Builder customOrchestration(CustomOrchestration var1);

        default public Builder customOrchestration(Consumer<CustomOrchestration.Builder> customOrchestration) {
            return this.customOrchestration((CustomOrchestration)((CustomOrchestration.Builder)CustomOrchestration.builder().applyMutation(customOrchestration)).build());
        }

        public Builder idleSessionTTLInSeconds(Integer var1);

        public Builder agentResourceRoleArn(String var1);

        public Builder customerEncryptionKeyArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder promptOverrideConfiguration(PromptOverrideConfiguration var1);

        default public Builder promptOverrideConfiguration(Consumer<PromptOverrideConfiguration.Builder> promptOverrideConfiguration) {
            return this.promptOverrideConfiguration((PromptOverrideConfiguration)((PromptOverrideConfiguration.Builder)PromptOverrideConfiguration.builder().applyMutation(promptOverrideConfiguration)).build());
        }

        public Builder guardrailConfiguration(GuardrailConfiguration var1);

        default public Builder guardrailConfiguration(Consumer<GuardrailConfiguration.Builder> guardrailConfiguration) {
            return this.guardrailConfiguration((GuardrailConfiguration)((GuardrailConfiguration.Builder)GuardrailConfiguration.builder().applyMutation(guardrailConfiguration)).build());
        }

        public Builder memoryConfiguration(MemoryConfiguration var1);

        default public Builder memoryConfiguration(Consumer<MemoryConfiguration.Builder> memoryConfiguration) {
            return this.memoryConfiguration((MemoryConfiguration)((MemoryConfiguration.Builder)MemoryConfiguration.builder().applyMutation(memoryConfiguration)).build());
        }

        public Builder agentCollaboration(String var1);

        public Builder agentCollaboration(AgentCollaboration var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

