/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagent.model.Function;
import software.amazon.awssdk.services.bedrockagent.model.FunctionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionSchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionSchema> {
    private static final SdkField<List<Function>> FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("functions").getter(FunctionSchema.getter(FunctionSchema::functions)).setter(FunctionSchema.setter(Builder::functions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Function::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FunctionSchema.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Function> functions;
    private final Type type;

    private FunctionSchema(BuilderImpl builder) {
        this.functions = builder.functions;
        this.type = builder.type;
    }

    public final boolean hasFunctions() {
        return this.functions != null && !(this.functions instanceof SdkAutoConstructList);
    }

    public final List<Function> functions() {
        return this.functions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctions() ? this.functions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionSchema)) {
            return false;
        }
        FunctionSchema other = (FunctionSchema)obj;
        return this.hasFunctions() == other.hasFunctions() && Objects.equals(this.functions(), other.functions());
    }

    public final String toString() {
        return ToString.builder((String)"FunctionSchema").add("Functions", this.hasFunctions() ? this.functions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "functions": {
                return Optional.ofNullable(clazz.cast(this.functions()));
            }
        }
        return Optional.empty();
    }

    public static FunctionSchema fromFunctions(List<Function> functions) {
        return (FunctionSchema)FunctionSchema.builder().functions(functions).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Function>>> map = new HashMap<String, SdkField<List<Function>>>();
        map.put("functions", FUNCTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> java.util.function.Function<Object, T> getter(java.util.function.Function<FunctionSchema, T> g) {
        return obj -> g.apply((FunctionSchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FUNCTIONS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<Function> functions = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionSchema model) {
            this.functions(model.functions);
        }

        public final List<Function.Builder> getFunctions() {
            List<Function.Builder> result = FunctionsCopier.copyToBuilder(this.functions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctions(Collection<Function.BuilderImpl> functions) {
            List<Function> oldValue = this.functions;
            this.functions = FunctionsCopier.copyFromBuilder(functions);
            this.handleUnionValueChange(Type.FUNCTIONS, oldValue, this.functions);
        }

        @Override
        public final Builder functions(Collection<Function> functions) {
            List<Function> oldValue = this.functions;
            this.functions = FunctionsCopier.copy(functions);
            this.handleUnionValueChange(Type.FUNCTIONS, oldValue, this.functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Function ... functions) {
            this.functions(Arrays.asList(functions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Consumer<Function.Builder> ... functions) {
            this.functions(Stream.of(functions).map(c -> (Function)((Function.Builder)Function.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FunctionSchema build() {
            return new FunctionSchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionSchema> {
        public Builder functions(Collection<Function> var1);

        public Builder functions(Function ... var1);

        public Builder functions(Consumer<Function.Builder> ... var1);
    }
}

