/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.RedisEnterpriseCloudFieldMapping;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedisEnterpriseCloudConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedisEnterpriseCloudConfiguration> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(RedisEnterpriseCloudConfiguration.getter(RedisEnterpriseCloudConfiguration::endpoint)).setter(RedisEnterpriseCloudConfiguration.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> VECTOR_INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vectorIndexName").getter(RedisEnterpriseCloudConfiguration.getter(RedisEnterpriseCloudConfiguration::vectorIndexName)).setter(RedisEnterpriseCloudConfiguration.setter(Builder::vectorIndexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorIndexName").build()}).build();
    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialsSecretArn").getter(RedisEnterpriseCloudConfiguration.getter(RedisEnterpriseCloudConfiguration::credentialsSecretArn)).setter(RedisEnterpriseCloudConfiguration.setter(Builder::credentialsSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build()}).build();
    private static final SdkField<RedisEnterpriseCloudFieldMapping> FIELD_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fieldMapping").getter(RedisEnterpriseCloudConfiguration.getter(RedisEnterpriseCloudConfiguration::fieldMapping)).setter(RedisEnterpriseCloudConfiguration.setter(Builder::fieldMapping)).constructor(RedisEnterpriseCloudFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldMapping").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD, VECTOR_INDEX_NAME_FIELD, CREDENTIALS_SECRET_ARN_FIELD, FIELD_MAPPING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedisEnterpriseCloudConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String endpoint;
    private final String vectorIndexName;
    private final String credentialsSecretArn;
    private final RedisEnterpriseCloudFieldMapping fieldMapping;

    private RedisEnterpriseCloudConfiguration(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.vectorIndexName = builder.vectorIndexName;
        this.credentialsSecretArn = builder.credentialsSecretArn;
        this.fieldMapping = builder.fieldMapping;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String vectorIndexName() {
        return this.vectorIndexName;
    }

    public final String credentialsSecretArn() {
        return this.credentialsSecretArn;
    }

    public final RedisEnterpriseCloudFieldMapping fieldMapping() {
        return this.fieldMapping;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorIndexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldMapping());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedisEnterpriseCloudConfiguration)) {
            return false;
        }
        RedisEnterpriseCloudConfiguration other = (RedisEnterpriseCloudConfiguration)obj;
        return Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.vectorIndexName(), other.vectorIndexName()) && Objects.equals(this.credentialsSecretArn(), other.credentialsSecretArn()) && Objects.equals(this.fieldMapping(), other.fieldMapping());
    }

    public final String toString() {
        return ToString.builder((String)"RedisEnterpriseCloudConfiguration").add("Endpoint", (Object)this.endpoint()).add("VectorIndexName", (Object)this.vectorIndexName()).add("CredentialsSecretArn", (Object)this.credentialsSecretArn()).add("FieldMapping", (Object)this.fieldMapping()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "vectorIndexName": {
                return Optional.ofNullable(clazz.cast(this.vectorIndexName()));
            }
            case "credentialsSecretArn": {
                return Optional.ofNullable(clazz.cast(this.credentialsSecretArn()));
            }
            case "fieldMapping": {
                return Optional.ofNullable(clazz.cast(this.fieldMapping()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("vectorIndexName", VECTOR_INDEX_NAME_FIELD);
        map.put("credentialsSecretArn", CREDENTIALS_SECRET_ARN_FIELD);
        map.put("fieldMapping", FIELD_MAPPING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedisEnterpriseCloudConfiguration, T> g) {
        return obj -> g.apply((RedisEnterpriseCloudConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpoint;
        private String vectorIndexName;
        private String credentialsSecretArn;
        private RedisEnterpriseCloudFieldMapping fieldMapping;

        private BuilderImpl() {
        }

        private BuilderImpl(RedisEnterpriseCloudConfiguration model) {
            this.endpoint(model.endpoint);
            this.vectorIndexName(model.vectorIndexName);
            this.credentialsSecretArn(model.credentialsSecretArn);
            this.fieldMapping(model.fieldMapping);
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getVectorIndexName() {
            return this.vectorIndexName;
        }

        public final void setVectorIndexName(String vectorIndexName) {
            this.vectorIndexName = vectorIndexName;
        }

        @Override
        public final Builder vectorIndexName(String vectorIndexName) {
            this.vectorIndexName = vectorIndexName;
            return this;
        }

        public final String getCredentialsSecretArn() {
            return this.credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        public final RedisEnterpriseCloudFieldMapping.Builder getFieldMapping() {
            return this.fieldMapping != null ? this.fieldMapping.toBuilder() : null;
        }

        public final void setFieldMapping(RedisEnterpriseCloudFieldMapping.BuilderImpl fieldMapping) {
            this.fieldMapping = fieldMapping != null ? fieldMapping.build() : null;
        }

        @Override
        public final Builder fieldMapping(RedisEnterpriseCloudFieldMapping fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        public RedisEnterpriseCloudConfiguration build() {
            return new RedisEnterpriseCloudConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedisEnterpriseCloudConfiguration> {
        public Builder endpoint(String var1);

        public Builder vectorIndexName(String var1);

        public Builder credentialsSecretArn(String var1);

        public Builder fieldMapping(RedisEnterpriseCloudFieldMapping var1);

        default public Builder fieldMapping(Consumer<RedisEnterpriseCloudFieldMapping.Builder> fieldMapping) {
            return this.fieldMapping((RedisEnterpriseCloudFieldMapping)((RedisEnterpriseCloudFieldMapping.Builder)RedisEnterpriseCloudFieldMapping.builder().applyMutation(fieldMapping)).build());
        }
    }
}

