/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the resource being queried.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseRetrieveAndGenerateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseRetrieveAndGenerateConfiguration.Builder, KnowledgeBaseRetrieveAndGenerateConfiguration> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(KnowledgeBaseRetrieveAndGenerateConfiguration::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(KnowledgeBaseRetrieveAndGenerateConfiguration::modelArn))
            .setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<KnowledgeBaseRetrievalConfiguration> RETRIEVAL_CONFIGURATION_FIELD = SdkField
            .<KnowledgeBaseRetrievalConfiguration> builder(MarshallingType.SDK_POJO).memberName("retrievalConfiguration")
            .getter(getter(KnowledgeBaseRetrieveAndGenerateConfiguration::retrievalConfiguration))
            .setter(setter(Builder::retrievalConfiguration)).constructor(KnowledgeBaseRetrievalConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            MODEL_ARN_FIELD, RETRIEVAL_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String knowledgeBaseId;

    private final String modelArn;

    private final KnowledgeBaseRetrievalConfiguration retrievalConfiguration;

    private KnowledgeBaseRetrieveAndGenerateConfiguration(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.modelArn = builder.modelArn;
        this.retrievalConfiguration = builder.retrievalConfiguration;
    }

    /**
     * <p>
     * The unique identifier of the knowledge base that is queried and the foundation model used for generation.
     * </p>
     * 
     * @return The unique identifier of the knowledge base that is queried and the foundation model used for generation.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The ARN of the foundation model used to generate a response.
     * </p>
     * 
     * @return The ARN of the foundation model used to generate a response.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * Contains configurations for how to retrieve and return the knowledge base query.
     * </p>
     * 
     * @return Contains configurations for how to retrieve and return the knowledge base query.
     */
    public final KnowledgeBaseRetrievalConfiguration retrievalConfiguration() {
        return retrievalConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(retrievalConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseRetrieveAndGenerateConfiguration)) {
            return false;
        }
        KnowledgeBaseRetrieveAndGenerateConfiguration other = (KnowledgeBaseRetrieveAndGenerateConfiguration) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(retrievalConfiguration(), other.retrievalConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseRetrieveAndGenerateConfiguration").add("KnowledgeBaseId", knowledgeBaseId())
                .add("ModelArn", modelArn()).add("RetrievalConfiguration", retrievalConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "retrievalConfiguration":
            return Optional.ofNullable(clazz.cast(retrievalConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseRetrieveAndGenerateConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseRetrieveAndGenerateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseRetrieveAndGenerateConfiguration> {
        /**
         * <p>
         * The unique identifier of the knowledge base that is queried and the foundation model used for generation.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier of the knowledge base that is queried and the foundation model used for
         *        generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The ARN of the foundation model used to generate a response.
         * </p>
         * 
         * @param modelArn
         *        The ARN of the foundation model used to generate a response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * Contains configurations for how to retrieve and return the knowledge base query.
         * </p>
         * 
         * @param retrievalConfiguration
         *        Contains configurations for how to retrieve and return the knowledge base query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalConfiguration(KnowledgeBaseRetrievalConfiguration retrievalConfiguration);

        /**
         * <p>
         * Contains configurations for how to retrieve and return the knowledge base query.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KnowledgeBaseRetrievalConfiguration.Builder} avoiding the need to create one manually via
         * {@link KnowledgeBaseRetrievalConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseRetrievalConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #retrievalConfiguration(KnowledgeBaseRetrievalConfiguration)}.
         * 
         * @param retrievalConfiguration
         *        a consumer that will call methods on {@link KnowledgeBaseRetrievalConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrievalConfiguration(KnowledgeBaseRetrievalConfiguration)
         */
        default Builder retrievalConfiguration(Consumer<KnowledgeBaseRetrievalConfiguration.Builder> retrievalConfiguration) {
            return retrievalConfiguration(KnowledgeBaseRetrievalConfiguration.builder().applyMutation(retrievalConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String modelArn;

        private KnowledgeBaseRetrievalConfiguration retrievalConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseRetrieveAndGenerateConfiguration model) {
            knowledgeBaseId(model.knowledgeBaseId);
            modelArn(model.modelArn);
            retrievalConfiguration(model.retrievalConfiguration);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final KnowledgeBaseRetrievalConfiguration.Builder getRetrievalConfiguration() {
            return retrievalConfiguration != null ? retrievalConfiguration.toBuilder() : null;
        }

        public final void setRetrievalConfiguration(KnowledgeBaseRetrievalConfiguration.BuilderImpl retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration != null ? retrievalConfiguration.build() : null;
        }

        @Override
        public final Builder retrievalConfiguration(KnowledgeBaseRetrievalConfiguration retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration;
            return this;
        }

        @Override
        public KnowledgeBaseRetrieveAndGenerateConfiguration build() {
            return new KnowledgeBaseRetrieveAndGenerateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
