/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieveResponse extends BedrockAgentRuntimeResponse implements
        ToCopyableBuilder<RetrieveResponse.Builder, RetrieveResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(RetrieveResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<KnowledgeBaseRetrievalResult>> RETRIEVAL_RESULTS_FIELD = SdkField
            .<List<KnowledgeBaseRetrievalResult>> builder(MarshallingType.LIST)
            .memberName("retrievalResults")
            .getter(getter(RetrieveResponse::retrievalResults))
            .setter(setter(Builder::retrievalResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KnowledgeBaseRetrievalResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(KnowledgeBaseRetrievalResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RETRIEVAL_RESULTS_FIELD));

    private final String nextToken;

    private final List<KnowledgeBaseRetrievalResult> retrievalResults;

    private RetrieveResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.retrievalResults = builder.retrievalResults;
    }

    /**
     * <p>
     * If there are more results than can fit in the response, the response returns a <code>nextToken</code>. Use this
     * token in the <code>nextToken</code> field of another request to retrieve the next batch of results.
     * </p>
     * 
     * @return If there are more results than can fit in the response, the response returns a <code>nextToken</code>.
     *         Use this token in the <code>nextToken</code> field of another request to retrieve the next batch of
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RetrievalResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRetrievalResults() {
        return retrievalResults != null && !(retrievalResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of results from querying the knowledge base.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRetrievalResults} method.
     * </p>
     * 
     * @return A list of results from querying the knowledge base.
     */
    public final List<KnowledgeBaseRetrievalResult> retrievalResults() {
        return retrievalResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRetrievalResults() ? retrievalResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveResponse)) {
            return false;
        }
        RetrieveResponse other = (RetrieveResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasRetrievalResults() == other.hasRetrievalResults()
                && Objects.equals(retrievalResults(), other.retrievalResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrieveResponse").add("NextToken", nextToken())
                .add("RetrievalResults", retrievalResults() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "retrievalResults":
            return Optional.ofNullable(clazz.cast(retrievalResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveResponse, T> g) {
        return obj -> g.apply((RetrieveResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRuntimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, RetrieveResponse> {
        /**
         * <p>
         * If there are more results than can fit in the response, the response returns a <code>nextToken</code>. Use
         * this token in the <code>nextToken</code> field of another request to retrieve the next batch of results.
         * </p>
         * 
         * @param nextToken
         *        If there are more results than can fit in the response, the response returns a <code>nextToken</code>.
         *        Use this token in the <code>nextToken</code> field of another request to retrieve the next batch of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of results from querying the knowledge base.
         * </p>
         * 
         * @param retrievalResults
         *        A list of results from querying the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalResults(Collection<KnowledgeBaseRetrievalResult> retrievalResults);

        /**
         * <p>
         * A list of results from querying the knowledge base.
         * </p>
         * 
         * @param retrievalResults
         *        A list of results from querying the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalResults(KnowledgeBaseRetrievalResult... retrievalResults);

        /**
         * <p>
         * A list of results from querying the knowledge base.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseRetrievalResult.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseRetrievalResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseRetrievalResult.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #retrievalResults(List<KnowledgeBaseRetrievalResult>)}.
         * 
         * @param retrievalResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseRetrievalResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrievalResults(java.util.Collection<KnowledgeBaseRetrievalResult>)
         */
        Builder retrievalResults(Consumer<KnowledgeBaseRetrievalResult.Builder>... retrievalResults);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<KnowledgeBaseRetrievalResult> retrievalResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveResponse model) {
            super(model);
            nextToken(model.nextToken);
            retrievalResults(model.retrievalResults);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<KnowledgeBaseRetrievalResult.Builder> getRetrievalResults() {
            List<KnowledgeBaseRetrievalResult.Builder> result = KnowledgeBaseRetrievalResultsCopier
                    .copyToBuilder(this.retrievalResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRetrievalResults(Collection<KnowledgeBaseRetrievalResult.BuilderImpl> retrievalResults) {
            this.retrievalResults = KnowledgeBaseRetrievalResultsCopier.copyFromBuilder(retrievalResults);
        }

        @Override
        public final Builder retrievalResults(Collection<KnowledgeBaseRetrievalResult> retrievalResults) {
            this.retrievalResults = KnowledgeBaseRetrievalResultsCopier.copy(retrievalResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievalResults(KnowledgeBaseRetrievalResult... retrievalResults) {
            retrievalResults(Arrays.asList(retrievalResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievalResults(Consumer<KnowledgeBaseRetrievalResult.Builder>... retrievalResults) {
            retrievalResults(Stream.of(retrievalResults)
                    .map(c -> KnowledgeBaseRetrievalResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RetrieveResponse build() {
            return new RetrieveResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
