/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details of the source files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputFile implements SdkPojo, Serializable, ToCopyableBuilder<InputFile.Builder, InputFile> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(InputFile::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<FileSource> SOURCE_FIELD = SdkField.<FileSource> builder(MarshallingType.SDK_POJO)
            .memberName("source").getter(getter(InputFile::source)).setter(setter(Builder::source))
            .constructor(FileSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> USE_CASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("useCase").getter(getter(InputFile::useCaseAsString)).setter(setter(Builder::useCase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useCase").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SOURCE_FIELD,
            USE_CASE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final FileSource source;

    private final String useCase;

    private InputFile(BuilderImpl builder) {
        this.name = builder.name;
        this.source = builder.source;
        this.useCase = builder.useCase;
    }

    /**
     * <p>
     * The name of the source file.
     * </p>
     * 
     * @return The name of the source file.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies where the files are located.
     * </p>
     * 
     * @return Specifies where the files are located.
     */
    public final FileSource source() {
        return source;
    }

    /**
     * <p>
     * Specifies how the source files will be used by the code interpreter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #useCase} will
     * return {@link FileUseCase#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #useCaseAsString}.
     * </p>
     * 
     * @return Specifies how the source files will be used by the code interpreter.
     * @see FileUseCase
     */
    public final FileUseCase useCase() {
        return FileUseCase.fromValue(useCase);
    }

    /**
     * <p>
     * Specifies how the source files will be used by the code interpreter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #useCase} will
     * return {@link FileUseCase#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #useCaseAsString}.
     * </p>
     * 
     * @return Specifies how the source files will be used by the code interpreter.
     * @see FileUseCase
     */
    public final String useCaseAsString() {
        return useCase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(useCaseAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputFile)) {
            return false;
        }
        InputFile other = (InputFile) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(source(), other.source())
                && Objects.equals(useCaseAsString(), other.useCaseAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputFile").add("Name", name()).add("Source", source()).add("UseCase", useCaseAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "useCase":
            return Optional.ofNullable(clazz.cast(useCaseAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputFile, T> g) {
        return obj -> g.apply((InputFile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputFile> {
        /**
         * <p>
         * The name of the source file.
         * </p>
         * 
         * @param name
         *        The name of the source file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies where the files are located.
         * </p>
         * 
         * @param source
         *        Specifies where the files are located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(FileSource source);

        /**
         * <p>
         * Specifies where the files are located.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileSource.Builder} avoiding the need to
         * create one manually via {@link FileSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileSource.Builder#build()} is called immediately and its result
         * is passed to {@link #source(FileSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link FileSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(FileSource)
         */
        default Builder source(Consumer<FileSource.Builder> source) {
            return source(FileSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * Specifies how the source files will be used by the code interpreter.
         * </p>
         * 
         * @param useCase
         *        Specifies how the source files will be used by the code interpreter.
         * @see FileUseCase
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileUseCase
         */
        Builder useCase(String useCase);

        /**
         * <p>
         * Specifies how the source files will be used by the code interpreter.
         * </p>
         * 
         * @param useCase
         *        Specifies how the source files will be used by the code interpreter.
         * @see FileUseCase
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileUseCase
         */
        Builder useCase(FileUseCase useCase);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private FileSource source;

        private String useCase;

        private BuilderImpl() {
        }

        private BuilderImpl(InputFile model) {
            name(model.name);
            source(model.source);
            useCase(model.useCase);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final FileSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(FileSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(FileSource source) {
            this.source = source;
            return this;
        }

        public final String getUseCase() {
            return useCase;
        }

        public final void setUseCase(String useCase) {
            this.useCase = useCase;
        }

        @Override
        public final Builder useCase(String useCase) {
            this.useCase = useCase;
            return this;
        }

        @Override
        public final Builder useCase(FileUseCase useCase) {
            this.useCase(useCase == null ? null : useCase.toString());
            return this;
        }

        @Override
        public InputFile build() {
            return new InputFile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
