/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the foundation model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Metadata implements SdkPojo, Serializable, ToCopyableBuilder<Metadata.Builder, Metadata> {
    private static final SdkField<Usage> USAGE_FIELD = SdkField.<Usage> builder(MarshallingType.SDK_POJO).memberName("usage")
            .getter(getter(Metadata::usage)).setter(setter(Builder::usage)).constructor(Usage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Usage usage;

    private Metadata(BuilderImpl builder) {
        this.usage = builder.usage;
    }

    /**
     * <p>
     * Contains details of the foundation model usage.
     * </p>
     * 
     * @return Contains details of the foundation model usage.
     */
    public final Usage usage() {
        return usage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metadata)) {
            return false;
        }
        Metadata other = (Metadata) obj;
        return Objects.equals(usage(), other.usage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Metadata").add("Usage", usage() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usage":
            return Optional.ofNullable(clazz.cast(usage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Metadata, T> g) {
        return obj -> g.apply((Metadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Metadata> {
        /**
         * <p>
         * Contains details of the foundation model usage.
         * </p>
         * 
         * @param usage
         *        Contains details of the foundation model usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usage(Usage usage);

        /**
         * <p>
         * Contains details of the foundation model usage.
         * </p>
         * This is a convenience method that creates an instance of the {@link Usage.Builder} avoiding the need to
         * create one manually via {@link Usage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Usage.Builder#build()} is called immediately and its result is
         * passed to {@link #usage(Usage)}.
         * 
         * @param usage
         *        a consumer that will call methods on {@link Usage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usage(Usage)
         */
        default Builder usage(Consumer<Usage.Builder> usage) {
            return usage(Usage.builder().applyMutation(usage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Usage usage;

        private BuilderImpl() {
        }

        private BuilderImpl(Metadata model) {
            usage(model.usage);
        }

        public final Usage.Builder getUsage() {
            return usage != null ? usage.toBuilder() : null;
        }

        public final void setUsage(Usage.BuilderImpl usage) {
            this.usage = usage != null ? usage.build() : null;
        }

        @Override
        public final Builder usage(Usage usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public Metadata build() {
            return new Metadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
