/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the filters to use on the metadata attributes in the knowledge base data sources before returning results.
 * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query
 * configurations</a>. See the examples below to see how to use these filters.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax"
 * >Retrieve request</a> – in the <code>filter</code> field
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax"
 * >RetrieveAndGenerate request</a> – in the <code>filter</code> field
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrievalFilter implements SdkPojo, Serializable, ToCopyableBuilder<RetrievalFilter.Builder, RetrievalFilter> {
    private static final SdkField<List<RetrievalFilter>> AND_ALL_FIELD = SdkField
            .<List<RetrievalFilter>> builder(MarshallingType.LIST)
            .memberName("andAll")
            .getter(getter(RetrievalFilter::andAll))
            .setter(setter(Builder::andAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("andAll").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RetrievalFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(RetrievalFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FilterAttribute> EQUALS_FIELD = SdkField.<FilterAttribute> builder(MarshallingType.SDK_POJO)
            .memberName("equals").getter(getter(RetrievalFilter::equalsValue)).setter(setter(Builder::equalsValue))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equals").build()).build();

    private static final SdkField<FilterAttribute> GREATER_THAN_FIELD = SdkField
            .<FilterAttribute> builder(MarshallingType.SDK_POJO).memberName("greaterThan")
            .getter(getter(RetrievalFilter::greaterThan)).setter(setter(Builder::greaterThan))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThan").build()).build();

    private static final SdkField<FilterAttribute> GREATER_THAN_OR_EQUALS_FIELD = SdkField
            .<FilterAttribute> builder(MarshallingType.SDK_POJO).memberName("greaterThanOrEquals")
            .getter(getter(RetrievalFilter::greaterThanOrEquals)).setter(setter(Builder::greaterThanOrEquals))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThanOrEquals").build())
            .build();

    private static final SdkField<FilterAttribute> IN_FIELD = SdkField.<FilterAttribute> builder(MarshallingType.SDK_POJO)
            .memberName("in").getter(getter(RetrievalFilter::in)).setter(setter(Builder::in))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("in").build()).build();

    private static final SdkField<FilterAttribute> LESS_THAN_FIELD = SdkField.<FilterAttribute> builder(MarshallingType.SDK_POJO)
            .memberName("lessThan").getter(getter(RetrievalFilter::lessThan)).setter(setter(Builder::lessThan))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThan").build()).build();

    private static final SdkField<FilterAttribute> LESS_THAN_OR_EQUALS_FIELD = SdkField
            .<FilterAttribute> builder(MarshallingType.SDK_POJO).memberName("lessThanOrEquals")
            .getter(getter(RetrievalFilter::lessThanOrEquals)).setter(setter(Builder::lessThanOrEquals))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThanOrEquals").build()).build();

    private static final SdkField<FilterAttribute> LIST_CONTAINS_FIELD = SdkField
            .<FilterAttribute> builder(MarshallingType.SDK_POJO).memberName("listContains")
            .getter(getter(RetrievalFilter::listContains)).setter(setter(Builder::listContains))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listContains").build()).build();

    private static final SdkField<FilterAttribute> NOT_EQUALS_FIELD = SdkField
            .<FilterAttribute> builder(MarshallingType.SDK_POJO).memberName("notEquals")
            .getter(getter(RetrievalFilter::notEquals)).setter(setter(Builder::notEquals)).constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notEquals").build()).build();

    private static final SdkField<FilterAttribute> NOT_IN_FIELD = SdkField.<FilterAttribute> builder(MarshallingType.SDK_POJO)
            .memberName("notIn").getter(getter(RetrievalFilter::notIn)).setter(setter(Builder::notIn))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notIn").build()).build();

    private static final SdkField<List<RetrievalFilter>> OR_ALL_FIELD = SdkField
            .<List<RetrievalFilter>> builder(MarshallingType.LIST)
            .memberName("orAll")
            .getter(getter(RetrievalFilter::orAll))
            .setter(setter(Builder::orAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orAll").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RetrievalFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(RetrievalFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FilterAttribute> STARTS_WITH_FIELD = SdkField
            .<FilterAttribute> builder(MarshallingType.SDK_POJO).memberName("startsWith")
            .getter(getter(RetrievalFilter::startsWith)).setter(setter(Builder::startsWith))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startsWith").build()).build();

    private static final SdkField<FilterAttribute> STRING_CONTAINS_FIELD = SdkField
            .<FilterAttribute> builder(MarshallingType.SDK_POJO).memberName("stringContains")
            .getter(getter(RetrievalFilter::stringContains)).setter(setter(Builder::stringContains))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringContains").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_ALL_FIELD, EQUALS_FIELD,
            GREATER_THAN_FIELD, GREATER_THAN_OR_EQUALS_FIELD, IN_FIELD, LESS_THAN_FIELD, LESS_THAN_OR_EQUALS_FIELD,
            LIST_CONTAINS_FIELD, NOT_EQUALS_FIELD, NOT_IN_FIELD, OR_ALL_FIELD, STARTS_WITH_FIELD, STRING_CONTAINS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RetrievalFilter> andAll;

    private final FilterAttribute equalsValue;

    private final FilterAttribute greaterThan;

    private final FilterAttribute greaterThanOrEquals;

    private final FilterAttribute in;

    private final FilterAttribute lessThan;

    private final FilterAttribute lessThanOrEquals;

    private final FilterAttribute listContains;

    private final FilterAttribute notEquals;

    private final FilterAttribute notIn;

    private final List<RetrievalFilter> orAll;

    private final FilterAttribute startsWith;

    private final FilterAttribute stringContains;

    private final Type type;

    private RetrievalFilter(BuilderImpl builder) {
        this.andAll = builder.andAll;
        this.equalsValue = builder.equalsValue;
        this.greaterThan = builder.greaterThan;
        this.greaterThanOrEquals = builder.greaterThanOrEquals;
        this.in = builder.in;
        this.lessThan = builder.lessThan;
        this.lessThanOrEquals = builder.lessThanOrEquals;
        this.listContains = builder.listContains;
        this.notEquals = builder.notEquals;
        this.notIn = builder.notIn;
        this.orAll = builder.orAll;
        this.startsWith = builder.startsWith;
        this.stringContains = builder.stringContains;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndAll property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAndAll() {
        return andAll != null && !(andAll instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Knowledge base data sources are returned if their metadata attributes fulfill all the filter conditions inside
     * this list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndAll} method.
     * </p>
     * 
     * @return Knowledge base data sources are returned if their metadata attributes fulfill all the filter conditions
     *         inside this list.
     */
    public final List<RetrievalFilter> andAll() {
        return andAll;
    }

    /**
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value matches the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>animal</code> attribute whose value is
     * <code>cat</code>:
     * </p>
     * <p>
     * <code>"equals": { "key": "animal", "value": "cat" }</code>
     * </p>
     * 
     * @return Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *         <code>key</code> and whose value matches the <code>value</code> in this object.</p>
     *         <p>
     *         The following example would return data sources with an <code>animal</code> attribute whose value is
     *         <code>cat</code>:
     *         </p>
     *         <p>
     *         <code>"equals": { "key": "animal", "value": "cat" }</code>
     */
    public final FilterAttribute equalsValue() {
        return equalsValue;
    }

    /**
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is greater than the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>year</code> attribute whose value is greater than
     * <code>1989</code>:
     * </p>
     * <p>
     * <code>"greaterThan": { "key": "year", "value": 1989 }</code>
     * </p>
     * 
     * @return Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *         <code>key</code> and whose value is greater than the <code>value</code> in this object.</p>
     *         <p>
     *         The following example would return data sources with an <code>year</code> attribute whose value is
     *         greater than <code>1989</code>:
     *         </p>
     *         <p>
     *         <code>"greaterThan": { "key": "year", "value": 1989 }</code>
     */
    public final FilterAttribute greaterThan() {
        return greaterThan;
    }

    /**
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is greater than or equal to the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>year</code> attribute whose value is greater than
     * or equal to <code>1989</code>:
     * </p>
     * <p>
     * <code>"greaterThanOrEquals": { "key": "year", "value": 1989 }</code>
     * </p>
     * 
     * @return Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *         <code>key</code> and whose value is greater than or equal to the <code>value</code> in this object.</p>
     *         <p>
     *         The following example would return data sources with an <code>year</code> attribute whose value is
     *         greater than or equal to <code>1989</code>:
     *         </p>
     *         <p>
     *         <code>"greaterThanOrEquals": { "key": "year", "value": 1989 }</code>
     */
    public final FilterAttribute greaterThanOrEquals() {
        return greaterThanOrEquals;
    }

    /**
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is in the list specified in the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>animal</code> attribute that is either
     * <code>cat</code> or <code>dog</code>:
     * </p>
     * <p>
     * <code>"in": { "key": "animal", "value": ["cat", "dog"] }</code>
     * </p>
     * 
     * @return Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *         <code>key</code> and whose value is in the list specified in the <code>value</code> in this object.</p>
     *         <p>
     *         The following example would return data sources with an <code>animal</code> attribute that is either
     *         <code>cat</code> or <code>dog</code>:
     *         </p>
     *         <p>
     *         <code>"in": { "key": "animal", "value": ["cat", "dog"] }</code>
     */
    public final FilterAttribute in() {
        return in;
    }

    /**
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is less than the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>year</code> attribute whose value is less than to
     * <code>1989</code>.
     * </p>
     * <p>
     * <code>"lessThan": { "key": "year", "value": 1989 }</code>
     * </p>
     * 
     * @return Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *         <code>key</code> and whose value is less than the <code>value</code> in this object.</p>
     *         <p>
     *         The following example would return data sources with an <code>year</code> attribute whose value is less
     *         than to <code>1989</code>.
     *         </p>
     *         <p>
     *         <code>"lessThan": { "key": "year", "value": 1989 }</code>
     */
    public final FilterAttribute lessThan() {
        return lessThan;
    }

    /**
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is less than or equal to the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>year</code> attribute whose value is less than or
     * equal to <code>1989</code>.
     * </p>
     * <p>
     * <code>"lessThanOrEquals": { "key": "year", "value": 1989 }</code>
     * </p>
     * 
     * @return Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *         <code>key</code> and whose value is less than or equal to the <code>value</code> in this object.</p>
     *         <p>
     *         The following example would return data sources with an <code>year</code> attribute whose value is less
     *         than or equal to <code>1989</code>.
     *         </p>
     *         <p>
     *         <code>"lessThanOrEquals": { "key": "year", "value": 1989 }</code>
     */
    public final FilterAttribute lessThanOrEquals() {
        return lessThanOrEquals;
    }

    /**
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is a list that contains the <code>value</code> as one of its members.
     * </p>
     * <p>
     * The following example would return data sources with an <code>animals</code> attribute that is a list containing
     * a <code>cat</code> member (for example <code>["dog", "cat"]</code>).
     * </p>
     * <p>
     * <code>"listContains": { "key": "animals", "value": "cat" }</code>
     * </p>
     * 
     * @return Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *         <code>key</code> and whose value is a list that contains the <code>value</code> as one of its
     *         members.</p>
     *         <p>
     *         The following example would return data sources with an <code>animals</code> attribute that is a list
     *         containing a <code>cat</code> member (for example <code>["dog", "cat"]</code>).
     *         </p>
     *         <p>
     *         <code>"listContains": { "key": "animals", "value": "cat" }</code>
     */
    public final FilterAttribute listContains() {
        return listContains;
    }

    /**
     * <p>
     * Knowledge base data sources that contain a metadata attribute whose name matches the <code>key</code> and whose
     * value doesn't match the <code>value</code> in this object are returned.
     * </p>
     * <p>
     * The following example would return data sources that don't contain an <code>animal</code> attribute whose value
     * is <code>cat</code>.
     * </p>
     * <p>
     * <code>"notEquals": { "key": "animal", "value": "cat" }</code>
     * </p>
     * 
     * @return Knowledge base data sources that contain a metadata attribute whose name matches the <code>key</code> and
     *         whose value doesn't match the <code>value</code> in this object are returned.</p>
     *         <p>
     *         The following example would return data sources that don't contain an <code>animal</code> attribute whose
     *         value is <code>cat</code>.
     *         </p>
     *         <p>
     *         <code>"notEquals": { "key": "animal", "value": "cat" }</code>
     */
    public final FilterAttribute notEquals() {
        return notEquals;
    }

    /**
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value isn't in the list specified in the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources whose <code>animal</code> attribute is neither <code>cat</code>
     * nor <code>dog</code>.
     * </p>
     * <p>
     * <code>"notIn": { "key": "animal", "value": ["cat", "dog"] }</code>
     * </p>
     * 
     * @return Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *         <code>key</code> and whose value isn't in the list specified in the <code>value</code> in this
     *         object.</p>
     *         <p>
     *         The following example would return data sources whose <code>animal</code> attribute is neither
     *         <code>cat</code> nor <code>dog</code>.
     *         </p>
     *         <p>
     *         <code>"notIn": { "key": "animal", "value": ["cat", "dog"] }</code>
     */
    public final FilterAttribute notIn() {
        return notIn;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrAll property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasOrAll() {
        return orAll != null && !(orAll instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Knowledge base data sources are returned if their metadata attributes fulfill at least one of the filter
     * conditions inside this list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrAll} method.
     * </p>
     * 
     * @return Knowledge base data sources are returned if their metadata attributes fulfill at least one of the filter
     *         conditions inside this list.
     */
    public final List<RetrievalFilter> orAll() {
        return orAll;
    }

    /**
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value starts with the <code>value</code> in this object. This filter is currently only
     * supported for Amazon OpenSearch Serverless vector stores.
     * </p>
     * <p>
     * The following example would return data sources with an <code>animal</code> attribute starts with <code>ca</code>
     * (for example, <code>cat</code> or <code>camel</code>).
     * </p>
     * <p>
     * <code>"startsWith": { "key": "animal", "value": "ca" }</code>
     * </p>
     * 
     * @return Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *         <code>key</code> and whose value starts with the <code>value</code> in this object. This filter is
     *         currently only supported for Amazon OpenSearch Serverless vector stores.</p>
     *         <p>
     *         The following example would return data sources with an <code>animal</code> attribute starts with
     *         <code>ca</code> (for example, <code>cat</code> or <code>camel</code>).
     *         </p>
     *         <p>
     *         <code>"startsWith": { "key": "animal", "value": "ca" }</code>
     */
    public final FilterAttribute startsWith() {
        return startsWith;
    }

    /**
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A string that contains the <code>value</code> as a substring. The following example would return data sources
     * with an <code>animal</code> attribute that contains the substring <code>at</code> (for example <code>cat</code>).
     * </p>
     * <p>
     * <code>"stringContains": { "key": "animal", "value": "at" }</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * A list with a member that contains the <code>value</code> as a substring. The following example would return data
     * sources with an <code>animals</code> attribute that is a list containing a member that contains the substring
     * <code>at</code> (for example <code>["dog", "cat"]</code>).
     * </p>
     * <p>
     * <code>"stringContains": { "key": "animals", "value": "at" }</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *         <code>key</code> and whose value is one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         A string that contains the <code>value</code> as a substring. The following example would return data
     *         sources with an <code>animal</code> attribute that contains the substring <code>at</code> (for example
     *         <code>cat</code>).
     *         </p>
     *         <p>
     *         <code>"stringContains": { "key": "animal", "value": "at" }</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A list with a member that contains the <code>value</code> as a substring. The following example would
     *         return data sources with an <code>animals</code> attribute that is a list containing a member that
     *         contains the substring <code>at</code> (for example <code>["dog", "cat"]</code>).
     *         </p>
     *         <p>
     *         <code>"stringContains": { "key": "animals", "value": "at" }</code>
     *         </p>
     *         </li>
     */
    public final FilterAttribute stringContains() {
        return stringContains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAndAll() ? andAll() : null);
        hashCode = 31 * hashCode + Objects.hashCode(equalsValue());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThan());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThanOrEquals());
        hashCode = 31 * hashCode + Objects.hashCode(in());
        hashCode = 31 * hashCode + Objects.hashCode(lessThan());
        hashCode = 31 * hashCode + Objects.hashCode(lessThanOrEquals());
        hashCode = 31 * hashCode + Objects.hashCode(listContains());
        hashCode = 31 * hashCode + Objects.hashCode(notEquals());
        hashCode = 31 * hashCode + Objects.hashCode(notIn());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrAll() ? orAll() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startsWith());
        hashCode = 31 * hashCode + Objects.hashCode(stringContains());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievalFilter)) {
            return false;
        }
        RetrievalFilter other = (RetrievalFilter) obj;
        return hasAndAll() == other.hasAndAll() && Objects.equals(andAll(), other.andAll())
                && Objects.equals(equalsValue(), other.equalsValue()) && Objects.equals(greaterThan(), other.greaterThan())
                && Objects.equals(greaterThanOrEquals(), other.greaterThanOrEquals()) && Objects.equals(in(), other.in())
                && Objects.equals(lessThan(), other.lessThan()) && Objects.equals(lessThanOrEquals(), other.lessThanOrEquals())
                && Objects.equals(listContains(), other.listContains()) && Objects.equals(notEquals(), other.notEquals())
                && Objects.equals(notIn(), other.notIn()) && hasOrAll() == other.hasOrAll()
                && Objects.equals(orAll(), other.orAll()) && Objects.equals(startsWith(), other.startsWith())
                && Objects.equals(stringContains(), other.stringContains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrievalFilter").add("AndAll", andAll() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Equals", equalsValue()).add("GreaterThan", greaterThan()).add("GreaterThanOrEquals", greaterThanOrEquals())
                .add("In", in()).add("LessThan", lessThan()).add("LessThanOrEquals", lessThanOrEquals())
                .add("ListContains", listContains()).add("NotEquals", notEquals()).add("NotIn", notIn())
                .add("OrAll", orAll() == null ? null : "*** Sensitive Data Redacted ***").add("StartsWith", startsWith())
                .add("StringContains", stringContains()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "andAll":
            return Optional.ofNullable(clazz.cast(andAll()));
        case "equals":
            return Optional.ofNullable(clazz.cast(equalsValue()));
        case "greaterThan":
            return Optional.ofNullable(clazz.cast(greaterThan()));
        case "greaterThanOrEquals":
            return Optional.ofNullable(clazz.cast(greaterThanOrEquals()));
        case "in":
            return Optional.ofNullable(clazz.cast(in()));
        case "lessThan":
            return Optional.ofNullable(clazz.cast(lessThan()));
        case "lessThanOrEquals":
            return Optional.ofNullable(clazz.cast(lessThanOrEquals()));
        case "listContains":
            return Optional.ofNullable(clazz.cast(listContains()));
        case "notEquals":
            return Optional.ofNullable(clazz.cast(notEquals()));
        case "notIn":
            return Optional.ofNullable(clazz.cast(notIn()));
        case "orAll":
            return Optional.ofNullable(clazz.cast(orAll()));
        case "startsWith":
            return Optional.ofNullable(clazz.cast(startsWith()));
        case "stringContains":
            return Optional.ofNullable(clazz.cast(stringContains()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #andAll()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if their metadata attributes fulfill all the filter conditions inside
     * this list.
     * </p>
     * 
     * @param andAll
     *        Knowledge base data sources are returned if their metadata attributes fulfill all the filter conditions
     *        inside this list.
     */
    public static RetrievalFilter fromAndAll(List<RetrievalFilter> andAll) {
        return builder().andAll(andAll).build();
    }

    /**
     * Create an instance of this class with {@link #equalsValue()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value matches the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>animal</code> attribute whose value is
     * <code>cat</code>:
     * </p>
     * <p>
     * <code>"equals": { "key": "animal", "value": "cat" }</code>
     * </p>
     * 
     * @param equalsValue
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value matches the <code>value</code> in this object.</p>
     *        <p>
     *        The following example would return data sources with an <code>animal</code> attribute whose value is
     *        <code>cat</code>:
     *        </p>
     *        <p>
     *        <code>"equals": { "key": "animal", "value": "cat" }</code>
     */
    public static RetrievalFilter fromEqualsValue(FilterAttribute equalsValue) {
        return builder().equalsValue(equalsValue).build();
    }

    /**
     * Create an instance of this class with {@link #equalsValue()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value matches the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>animal</code> attribute whose value is
     * <code>cat</code>:
     * </p>
     * <p>
     * <code>"equals": { "key": "animal", "value": "cat" }</code>
     * </p>
     * 
     * @param equalsValue
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value matches the <code>value</code> in this object.</p>
     *        <p>
     *        The following example would return data sources with an <code>animal</code> attribute whose value is
     *        <code>cat</code>:
     *        </p>
     *        <p>
     *        <code>"equals": { "key": "animal", "value": "cat" }</code>
     */
    public static RetrievalFilter fromEqualsValue(Consumer<FilterAttribute.Builder> equalsValue) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        equalsValue.accept(builder);
        return fromEqualsValue(builder.build());
    }

    /**
     * Create an instance of this class with {@link #greaterThan()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is greater than the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>year</code> attribute whose value is greater than
     * <code>1989</code>:
     * </p>
     * <p>
     * <code>"greaterThan": { "key": "year", "value": 1989 }</code>
     * </p>
     * 
     * @param greaterThan
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value is greater than the <code>value</code> in this object.</p>
     *        <p>
     *        The following example would return data sources with an <code>year</code> attribute whose value is greater
     *        than <code>1989</code>:
     *        </p>
     *        <p>
     *        <code>"greaterThan": { "key": "year", "value": 1989 }</code>
     */
    public static RetrievalFilter fromGreaterThan(FilterAttribute greaterThan) {
        return builder().greaterThan(greaterThan).build();
    }

    /**
     * Create an instance of this class with {@link #greaterThan()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is greater than the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>year</code> attribute whose value is greater than
     * <code>1989</code>:
     * </p>
     * <p>
     * <code>"greaterThan": { "key": "year", "value": 1989 }</code>
     * </p>
     * 
     * @param greaterThan
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value is greater than the <code>value</code> in this object.</p>
     *        <p>
     *        The following example would return data sources with an <code>year</code> attribute whose value is greater
     *        than <code>1989</code>:
     *        </p>
     *        <p>
     *        <code>"greaterThan": { "key": "year", "value": 1989 }</code>
     */
    public static RetrievalFilter fromGreaterThan(Consumer<FilterAttribute.Builder> greaterThan) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        greaterThan.accept(builder);
        return fromGreaterThan(builder.build());
    }

    /**
     * Create an instance of this class with {@link #greaterThanOrEquals()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is greater than or equal to the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>year</code> attribute whose value is greater than
     * or equal to <code>1989</code>:
     * </p>
     * <p>
     * <code>"greaterThanOrEquals": { "key": "year", "value": 1989 }</code>
     * </p>
     * 
     * @param greaterThanOrEquals
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value is greater than or equal to the <code>value</code> in this object.</p>
     *        <p>
     *        The following example would return data sources with an <code>year</code> attribute whose value is greater
     *        than or equal to <code>1989</code>:
     *        </p>
     *        <p>
     *        <code>"greaterThanOrEquals": { "key": "year", "value": 1989 }</code>
     */
    public static RetrievalFilter fromGreaterThanOrEquals(FilterAttribute greaterThanOrEquals) {
        return builder().greaterThanOrEquals(greaterThanOrEquals).build();
    }

    /**
     * Create an instance of this class with {@link #greaterThanOrEquals()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is greater than or equal to the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>year</code> attribute whose value is greater than
     * or equal to <code>1989</code>:
     * </p>
     * <p>
     * <code>"greaterThanOrEquals": { "key": "year", "value": 1989 }</code>
     * </p>
     * 
     * @param greaterThanOrEquals
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value is greater than or equal to the <code>value</code> in this object.</p>
     *        <p>
     *        The following example would return data sources with an <code>year</code> attribute whose value is greater
     *        than or equal to <code>1989</code>:
     *        </p>
     *        <p>
     *        <code>"greaterThanOrEquals": { "key": "year", "value": 1989 }</code>
     */
    public static RetrievalFilter fromGreaterThanOrEquals(Consumer<FilterAttribute.Builder> greaterThanOrEquals) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        greaterThanOrEquals.accept(builder);
        return fromGreaterThanOrEquals(builder.build());
    }

    /**
     * Create an instance of this class with {@link #in()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is in the list specified in the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>animal</code> attribute that is either
     * <code>cat</code> or <code>dog</code>:
     * </p>
     * <p>
     * <code>"in": { "key": "animal", "value": ["cat", "dog"] }</code>
     * </p>
     * 
     * @param in
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value is in the list specified in the <code>value</code> in this object.</p>
     *        <p>
     *        The following example would return data sources with an <code>animal</code> attribute that is either
     *        <code>cat</code> or <code>dog</code>:
     *        </p>
     *        <p>
     *        <code>"in": { "key": "animal", "value": ["cat", "dog"] }</code>
     */
    public static RetrievalFilter fromIn(FilterAttribute in) {
        return builder().in(in).build();
    }

    /**
     * Create an instance of this class with {@link #in()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is in the list specified in the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>animal</code> attribute that is either
     * <code>cat</code> or <code>dog</code>:
     * </p>
     * <p>
     * <code>"in": { "key": "animal", "value": ["cat", "dog"] }</code>
     * </p>
     * 
     * @param in
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value is in the list specified in the <code>value</code> in this object.</p>
     *        <p>
     *        The following example would return data sources with an <code>animal</code> attribute that is either
     *        <code>cat</code> or <code>dog</code>:
     *        </p>
     *        <p>
     *        <code>"in": { "key": "animal", "value": ["cat", "dog"] }</code>
     */
    public static RetrievalFilter fromIn(Consumer<FilterAttribute.Builder> in) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        in.accept(builder);
        return fromIn(builder.build());
    }

    /**
     * Create an instance of this class with {@link #lessThan()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is less than the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>year</code> attribute whose value is less than to
     * <code>1989</code>.
     * </p>
     * <p>
     * <code>"lessThan": { "key": "year", "value": 1989 }</code>
     * </p>
     * 
     * @param lessThan
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value is less than the <code>value</code> in this object.</p>
     *        <p>
     *        The following example would return data sources with an <code>year</code> attribute whose value is less
     *        than to <code>1989</code>.
     *        </p>
     *        <p>
     *        <code>"lessThan": { "key": "year", "value": 1989 }</code>
     */
    public static RetrievalFilter fromLessThan(FilterAttribute lessThan) {
        return builder().lessThan(lessThan).build();
    }

    /**
     * Create an instance of this class with {@link #lessThan()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is less than the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>year</code> attribute whose value is less than to
     * <code>1989</code>.
     * </p>
     * <p>
     * <code>"lessThan": { "key": "year", "value": 1989 }</code>
     * </p>
     * 
     * @param lessThan
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value is less than the <code>value</code> in this object.</p>
     *        <p>
     *        The following example would return data sources with an <code>year</code> attribute whose value is less
     *        than to <code>1989</code>.
     *        </p>
     *        <p>
     *        <code>"lessThan": { "key": "year", "value": 1989 }</code>
     */
    public static RetrievalFilter fromLessThan(Consumer<FilterAttribute.Builder> lessThan) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        lessThan.accept(builder);
        return fromLessThan(builder.build());
    }

    /**
     * Create an instance of this class with {@link #lessThanOrEquals()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is less than or equal to the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>year</code> attribute whose value is less than or
     * equal to <code>1989</code>.
     * </p>
     * <p>
     * <code>"lessThanOrEquals": { "key": "year", "value": 1989 }</code>
     * </p>
     * 
     * @param lessThanOrEquals
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value is less than or equal to the <code>value</code> in this object.</p>
     *        <p>
     *        The following example would return data sources with an <code>year</code> attribute whose value is less
     *        than or equal to <code>1989</code>.
     *        </p>
     *        <p>
     *        <code>"lessThanOrEquals": { "key": "year", "value": 1989 }</code>
     */
    public static RetrievalFilter fromLessThanOrEquals(FilterAttribute lessThanOrEquals) {
        return builder().lessThanOrEquals(lessThanOrEquals).build();
    }

    /**
     * Create an instance of this class with {@link #lessThanOrEquals()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is less than or equal to the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources with an <code>year</code> attribute whose value is less than or
     * equal to <code>1989</code>.
     * </p>
     * <p>
     * <code>"lessThanOrEquals": { "key": "year", "value": 1989 }</code>
     * </p>
     * 
     * @param lessThanOrEquals
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value is less than or equal to the <code>value</code> in this object.</p>
     *        <p>
     *        The following example would return data sources with an <code>year</code> attribute whose value is less
     *        than or equal to <code>1989</code>.
     *        </p>
     *        <p>
     *        <code>"lessThanOrEquals": { "key": "year", "value": 1989 }</code>
     */
    public static RetrievalFilter fromLessThanOrEquals(Consumer<FilterAttribute.Builder> lessThanOrEquals) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        lessThanOrEquals.accept(builder);
        return fromLessThanOrEquals(builder.build());
    }

    /**
     * Create an instance of this class with {@link #listContains()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is a list that contains the <code>value</code> as one of its members.
     * </p>
     * <p>
     * The following example would return data sources with an <code>animals</code> attribute that is a list containing
     * a <code>cat</code> member (for example <code>["dog", "cat"]</code>).
     * </p>
     * <p>
     * <code>"listContains": { "key": "animals", "value": "cat" }</code>
     * </p>
     * 
     * @param listContains
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value is a list that contains the <code>value</code> as one of its members.</p>
     *        <p>
     *        The following example would return data sources with an <code>animals</code> attribute that is a list
     *        containing a <code>cat</code> member (for example <code>["dog", "cat"]</code>).
     *        </p>
     *        <p>
     *        <code>"listContains": { "key": "animals", "value": "cat" }</code>
     */
    public static RetrievalFilter fromListContains(FilterAttribute listContains) {
        return builder().listContains(listContains).build();
    }

    /**
     * Create an instance of this class with {@link #listContains()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is a list that contains the <code>value</code> as one of its members.
     * </p>
     * <p>
     * The following example would return data sources with an <code>animals</code> attribute that is a list containing
     * a <code>cat</code> member (for example <code>["dog", "cat"]</code>).
     * </p>
     * <p>
     * <code>"listContains": { "key": "animals", "value": "cat" }</code>
     * </p>
     * 
     * @param listContains
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value is a list that contains the <code>value</code> as one of its members.</p>
     *        <p>
     *        The following example would return data sources with an <code>animals</code> attribute that is a list
     *        containing a <code>cat</code> member (for example <code>["dog", "cat"]</code>).
     *        </p>
     *        <p>
     *        <code>"listContains": { "key": "animals", "value": "cat" }</code>
     */
    public static RetrievalFilter fromListContains(Consumer<FilterAttribute.Builder> listContains) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        listContains.accept(builder);
        return fromListContains(builder.build());
    }

    /**
     * Create an instance of this class with {@link #notEquals()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources that contain a metadata attribute whose name matches the <code>key</code> and whose
     * value doesn't match the <code>value</code> in this object are returned.
     * </p>
     * <p>
     * The following example would return data sources that don't contain an <code>animal</code> attribute whose value
     * is <code>cat</code>.
     * </p>
     * <p>
     * <code>"notEquals": { "key": "animal", "value": "cat" }</code>
     * </p>
     * 
     * @param notEquals
     *        Knowledge base data sources that contain a metadata attribute whose name matches the <code>key</code> and
     *        whose value doesn't match the <code>value</code> in this object are returned.</p>
     *        <p>
     *        The following example would return data sources that don't contain an <code>animal</code> attribute whose
     *        value is <code>cat</code>.
     *        </p>
     *        <p>
     *        <code>"notEquals": { "key": "animal", "value": "cat" }</code>
     */
    public static RetrievalFilter fromNotEquals(FilterAttribute notEquals) {
        return builder().notEquals(notEquals).build();
    }

    /**
     * Create an instance of this class with {@link #notEquals()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources that contain a metadata attribute whose name matches the <code>key</code> and whose
     * value doesn't match the <code>value</code> in this object are returned.
     * </p>
     * <p>
     * The following example would return data sources that don't contain an <code>animal</code> attribute whose value
     * is <code>cat</code>.
     * </p>
     * <p>
     * <code>"notEquals": { "key": "animal", "value": "cat" }</code>
     * </p>
     * 
     * @param notEquals
     *        Knowledge base data sources that contain a metadata attribute whose name matches the <code>key</code> and
     *        whose value doesn't match the <code>value</code> in this object are returned.</p>
     *        <p>
     *        The following example would return data sources that don't contain an <code>animal</code> attribute whose
     *        value is <code>cat</code>.
     *        </p>
     *        <p>
     *        <code>"notEquals": { "key": "animal", "value": "cat" }</code>
     */
    public static RetrievalFilter fromNotEquals(Consumer<FilterAttribute.Builder> notEquals) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        notEquals.accept(builder);
        return fromNotEquals(builder.build());
    }

    /**
     * Create an instance of this class with {@link #notIn()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value isn't in the list specified in the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources whose <code>animal</code> attribute is neither <code>cat</code>
     * nor <code>dog</code>.
     * </p>
     * <p>
     * <code>"notIn": { "key": "animal", "value": ["cat", "dog"] }</code>
     * </p>
     * 
     * @param notIn
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value isn't in the list specified in the <code>value</code> in this object.</p>
     *        <p>
     *        The following example would return data sources whose <code>animal</code> attribute is neither
     *        <code>cat</code> nor <code>dog</code>.
     *        </p>
     *        <p>
     *        <code>"notIn": { "key": "animal", "value": ["cat", "dog"] }</code>
     */
    public static RetrievalFilter fromNotIn(FilterAttribute notIn) {
        return builder().notIn(notIn).build();
    }

    /**
     * Create an instance of this class with {@link #notIn()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value isn't in the list specified in the <code>value</code> in this object.
     * </p>
     * <p>
     * The following example would return data sources whose <code>animal</code> attribute is neither <code>cat</code>
     * nor <code>dog</code>.
     * </p>
     * <p>
     * <code>"notIn": { "key": "animal", "value": ["cat", "dog"] }</code>
     * </p>
     * 
     * @param notIn
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value isn't in the list specified in the <code>value</code> in this object.</p>
     *        <p>
     *        The following example would return data sources whose <code>animal</code> attribute is neither
     *        <code>cat</code> nor <code>dog</code>.
     *        </p>
     *        <p>
     *        <code>"notIn": { "key": "animal", "value": ["cat", "dog"] }</code>
     */
    public static RetrievalFilter fromNotIn(Consumer<FilterAttribute.Builder> notIn) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        notIn.accept(builder);
        return fromNotIn(builder.build());
    }

    /**
     * Create an instance of this class with {@link #orAll()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if their metadata attributes fulfill at least one of the filter
     * conditions inside this list.
     * </p>
     * 
     * @param orAll
     *        Knowledge base data sources are returned if their metadata attributes fulfill at least one of the filter
     *        conditions inside this list.
     */
    public static RetrievalFilter fromOrAll(List<RetrievalFilter> orAll) {
        return builder().orAll(orAll).build();
    }

    /**
     * Create an instance of this class with {@link #startsWith()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value starts with the <code>value</code> in this object. This filter is currently only
     * supported for Amazon OpenSearch Serverless vector stores.
     * </p>
     * <p>
     * The following example would return data sources with an <code>animal</code> attribute starts with <code>ca</code>
     * (for example, <code>cat</code> or <code>camel</code>).
     * </p>
     * <p>
     * <code>"startsWith": { "key": "animal", "value": "ca" }</code>
     * </p>
     * 
     * @param startsWith
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value starts with the <code>value</code> in this object. This filter is
     *        currently only supported for Amazon OpenSearch Serverless vector stores.</p>
     *        <p>
     *        The following example would return data sources with an <code>animal</code> attribute starts with
     *        <code>ca</code> (for example, <code>cat</code> or <code>camel</code>).
     *        </p>
     *        <p>
     *        <code>"startsWith": { "key": "animal", "value": "ca" }</code>
     */
    public static RetrievalFilter fromStartsWith(FilterAttribute startsWith) {
        return builder().startsWith(startsWith).build();
    }

    /**
     * Create an instance of this class with {@link #startsWith()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value starts with the <code>value</code> in this object. This filter is currently only
     * supported for Amazon OpenSearch Serverless vector stores.
     * </p>
     * <p>
     * The following example would return data sources with an <code>animal</code> attribute starts with <code>ca</code>
     * (for example, <code>cat</code> or <code>camel</code>).
     * </p>
     * <p>
     * <code>"startsWith": { "key": "animal", "value": "ca" }</code>
     * </p>
     * 
     * @param startsWith
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value starts with the <code>value</code> in this object. This filter is
     *        currently only supported for Amazon OpenSearch Serverless vector stores.</p>
     *        <p>
     *        The following example would return data sources with an <code>animal</code> attribute starts with
     *        <code>ca</code> (for example, <code>cat</code> or <code>camel</code>).
     *        </p>
     *        <p>
     *        <code>"startsWith": { "key": "animal", "value": "ca" }</code>
     */
    public static RetrievalFilter fromStartsWith(Consumer<FilterAttribute.Builder> startsWith) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        startsWith.accept(builder);
        return fromStartsWith(builder.build());
    }

    /**
     * Create an instance of this class with {@link #stringContains()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A string that contains the <code>value</code> as a substring. The following example would return data sources
     * with an <code>animal</code> attribute that contains the substring <code>at</code> (for example <code>cat</code>).
     * </p>
     * <p>
     * <code>"stringContains": { "key": "animal", "value": "at" }</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * A list with a member that contains the <code>value</code> as a substring. The following example would return data
     * sources with an <code>animals</code> attribute that is a list containing a member that contains the substring
     * <code>at</code> (for example <code>["dog", "cat"]</code>).
     * </p>
     * <p>
     * <code>"stringContains": { "key": "animals", "value": "at" }</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @param stringContains
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value is one of the following:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        A string that contains the <code>value</code> as a substring. The following example would return data
     *        sources with an <code>animal</code> attribute that contains the substring <code>at</code> (for example
     *        <code>cat</code>).
     *        </p>
     *        <p>
     *        <code>"stringContains": { "key": "animal", "value": "at" }</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        A list with a member that contains the <code>value</code> as a substring. The following example would
     *        return data sources with an <code>animals</code> attribute that is a list containing a member that
     *        contains the substring <code>at</code> (for example <code>["dog", "cat"]</code>).
     *        </p>
     *        <p>
     *        <code>"stringContains": { "key": "animals", "value": "at" }</code>
     *        </p>
     *        </li>
     */
    public static RetrievalFilter fromStringContains(FilterAttribute stringContains) {
        return builder().stringContains(stringContains).build();
    }

    /**
     * Create an instance of this class with {@link #stringContains()} initialized to the given value.
     *
     * <p>
     * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     * <code>key</code> and whose value is one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A string that contains the <code>value</code> as a substring. The following example would return data sources
     * with an <code>animal</code> attribute that contains the substring <code>at</code> (for example <code>cat</code>).
     * </p>
     * <p>
     * <code>"stringContains": { "key": "animal", "value": "at" }</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * A list with a member that contains the <code>value</code> as a substring. The following example would return data
     * sources with an <code>animals</code> attribute that is a list containing a member that contains the substring
     * <code>at</code> (for example <code>["dog", "cat"]</code>).
     * </p>
     * <p>
     * <code>"stringContains": { "key": "animals", "value": "at" }</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @param stringContains
     *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
     *        <code>key</code> and whose value is one of the following:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        A string that contains the <code>value</code> as a substring. The following example would return data
     *        sources with an <code>animal</code> attribute that contains the substring <code>at</code> (for example
     *        <code>cat</code>).
     *        </p>
     *        <p>
     *        <code>"stringContains": { "key": "animal", "value": "at" }</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        A list with a member that contains the <code>value</code> as a substring. The following example would
     *        return data sources with an <code>animals</code> attribute that is a list containing a member that
     *        contains the substring <code>at</code> (for example <code>["dog", "cat"]</code>).
     *        </p>
     *        <p>
     *        <code>"stringContains": { "key": "animals", "value": "at" }</code>
     *        </p>
     *        </li>
     */
    public static RetrievalFilter fromStringContains(Consumer<FilterAttribute.Builder> stringContains) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        stringContains.accept(builder);
        return fromStringContains(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrievalFilter, T> g) {
        return obj -> g.apply((RetrievalFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrievalFilter> {
        /**
         * <p>
         * Knowledge base data sources are returned if their metadata attributes fulfill all the filter conditions
         * inside this list.
         * </p>
         * 
         * @param andAll
         *        Knowledge base data sources are returned if their metadata attributes fulfill all the filter
         *        conditions inside this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andAll(Collection<RetrievalFilter> andAll);

        /**
         * <p>
         * Knowledge base data sources are returned if their metadata attributes fulfill all the filter conditions
         * inside this list.
         * </p>
         * 
         * @param andAll
         *        Knowledge base data sources are returned if their metadata attributes fulfill all the filter
         *        conditions inside this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andAll(RetrievalFilter... andAll);

        /**
         * <p>
         * Knowledge base data sources are returned if their metadata attributes fulfill all the filter conditions
         * inside this list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalFilter.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #andAll(List<RetrievalFilter>)}.
         * 
         * @param andAll
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andAll(java.util.Collection<RetrievalFilter>)
         */
        Builder andAll(Consumer<Builder>... andAll);

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value matches the <code>value</code> in this object.
         * </p>
         * <p>
         * The following example would return data sources with an <code>animal</code> attribute whose value is
         * <code>cat</code>:
         * </p>
         * <p>
         * <code>"equals": { "key": "animal", "value": "cat" }</code>
         * </p>
         * 
         * @param equalsValue
         *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         *        <code>key</code> and whose value matches the <code>value</code> in this object.</p>
         *        <p>
         *        The following example would return data sources with an <code>animal</code> attribute whose value is
         *        <code>cat</code>:
         *        </p>
         *        <p>
         *        <code>"equals": { "key": "animal", "value": "cat" }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsValue(FilterAttribute equalsValue);

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value matches the <code>value</code> in this object.
         * </p>
         * <p>
         * The following example would return data sources with an <code>animal</code> attribute whose value is
         * <code>cat</code>:
         * </p>
         * <p>
         * <code>"equals": { "key": "animal", "value": "cat" }</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #equalsValue(FilterAttribute)}.
         * 
         * @param equalsValue
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #equalsValue(FilterAttribute)
         */
        default Builder equalsValue(Consumer<FilterAttribute.Builder> equalsValue) {
            return equalsValue(FilterAttribute.builder().applyMutation(equalsValue).build());
        }

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value is greater than the <code>value</code> in this object.
         * </p>
         * <p>
         * The following example would return data sources with an <code>year</code> attribute whose value is greater
         * than <code>1989</code>:
         * </p>
         * <p>
         * <code>"greaterThan": { "key": "year", "value": 1989 }</code>
         * </p>
         * 
         * @param greaterThan
         *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         *        <code>key</code> and whose value is greater than the <code>value</code> in this object.</p>
         *        <p>
         *        The following example would return data sources with an <code>year</code> attribute whose value is
         *        greater than <code>1989</code>:
         *        </p>
         *        <p>
         *        <code>"greaterThan": { "key": "year", "value": 1989 }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThan(FilterAttribute greaterThan);

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value is greater than the <code>value</code> in this object.
         * </p>
         * <p>
         * The following example would return data sources with an <code>year</code> attribute whose value is greater
         * than <code>1989</code>:
         * </p>
         * <p>
         * <code>"greaterThan": { "key": "year", "value": 1989 }</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #greaterThan(FilterAttribute)}.
         * 
         * @param greaterThan
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greaterThan(FilterAttribute)
         */
        default Builder greaterThan(Consumer<FilterAttribute.Builder> greaterThan) {
            return greaterThan(FilterAttribute.builder().applyMutation(greaterThan).build());
        }

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value is greater than or equal to the <code>value</code> in this object.
         * </p>
         * <p>
         * The following example would return data sources with an <code>year</code> attribute whose value is greater
         * than or equal to <code>1989</code>:
         * </p>
         * <p>
         * <code>"greaterThanOrEquals": { "key": "year", "value": 1989 }</code>
         * </p>
         * 
         * @param greaterThanOrEquals
         *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         *        <code>key</code> and whose value is greater than or equal to the <code>value</code> in this
         *        object.</p>
         *        <p>
         *        The following example would return data sources with an <code>year</code> attribute whose value is
         *        greater than or equal to <code>1989</code>:
         *        </p>
         *        <p>
         *        <code>"greaterThanOrEquals": { "key": "year", "value": 1989 }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThanOrEquals(FilterAttribute greaterThanOrEquals);

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value is greater than or equal to the <code>value</code> in this object.
         * </p>
         * <p>
         * The following example would return data sources with an <code>year</code> attribute whose value is greater
         * than or equal to <code>1989</code>:
         * </p>
         * <p>
         * <code>"greaterThanOrEquals": { "key": "year", "value": 1989 }</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #greaterThanOrEquals(FilterAttribute)}.
         * 
         * @param greaterThanOrEquals
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greaterThanOrEquals(FilterAttribute)
         */
        default Builder greaterThanOrEquals(Consumer<FilterAttribute.Builder> greaterThanOrEquals) {
            return greaterThanOrEquals(FilterAttribute.builder().applyMutation(greaterThanOrEquals).build());
        }

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value is in the list specified in the <code>value</code> in this object.
         * </p>
         * <p>
         * The following example would return data sources with an <code>animal</code> attribute that is either
         * <code>cat</code> or <code>dog</code>:
         * </p>
         * <p>
         * <code>"in": { "key": "animal", "value": ["cat", "dog"] }</code>
         * </p>
         * 
         * @param in
         *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         *        <code>key</code> and whose value is in the list specified in the <code>value</code> in this
         *        object.</p>
         *        <p>
         *        The following example would return data sources with an <code>animal</code> attribute that is either
         *        <code>cat</code> or <code>dog</code>:
         *        </p>
         *        <p>
         *        <code>"in": { "key": "animal", "value": ["cat", "dog"] }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder in(FilterAttribute in);

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value is in the list specified in the <code>value</code> in this object.
         * </p>
         * <p>
         * The following example would return data sources with an <code>animal</code> attribute that is either
         * <code>cat</code> or <code>dog</code>:
         * </p>
         * <p>
         * <code>"in": { "key": "animal", "value": ["cat", "dog"] }</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #in(FilterAttribute)}.
         * 
         * @param in
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #in(FilterAttribute)
         */
        default Builder in(Consumer<FilterAttribute.Builder> in) {
            return in(FilterAttribute.builder().applyMutation(in).build());
        }

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value is less than the <code>value</code> in this object.
         * </p>
         * <p>
         * The following example would return data sources with an <code>year</code> attribute whose value is less than
         * to <code>1989</code>.
         * </p>
         * <p>
         * <code>"lessThan": { "key": "year", "value": 1989 }</code>
         * </p>
         * 
         * @param lessThan
         *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         *        <code>key</code> and whose value is less than the <code>value</code> in this object.</p>
         *        <p>
         *        The following example would return data sources with an <code>year</code> attribute whose value is
         *        less than to <code>1989</code>.
         *        </p>
         *        <p>
         *        <code>"lessThan": { "key": "year", "value": 1989 }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThan(FilterAttribute lessThan);

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value is less than the <code>value</code> in this object.
         * </p>
         * <p>
         * The following example would return data sources with an <code>year</code> attribute whose value is less than
         * to <code>1989</code>.
         * </p>
         * <p>
         * <code>"lessThan": { "key": "year", "value": 1989 }</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #lessThan(FilterAttribute)}.
         * 
         * @param lessThan
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lessThan(FilterAttribute)
         */
        default Builder lessThan(Consumer<FilterAttribute.Builder> lessThan) {
            return lessThan(FilterAttribute.builder().applyMutation(lessThan).build());
        }

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value is less than or equal to the <code>value</code> in this object.
         * </p>
         * <p>
         * The following example would return data sources with an <code>year</code> attribute whose value is less than
         * or equal to <code>1989</code>.
         * </p>
         * <p>
         * <code>"lessThanOrEquals": { "key": "year", "value": 1989 }</code>
         * </p>
         * 
         * @param lessThanOrEquals
         *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         *        <code>key</code> and whose value is less than or equal to the <code>value</code> in this object.</p>
         *        <p>
         *        The following example would return data sources with an <code>year</code> attribute whose value is
         *        less than or equal to <code>1989</code>.
         *        </p>
         *        <p>
         *        <code>"lessThanOrEquals": { "key": "year", "value": 1989 }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThanOrEquals(FilterAttribute lessThanOrEquals);

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value is less than or equal to the <code>value</code> in this object.
         * </p>
         * <p>
         * The following example would return data sources with an <code>year</code> attribute whose value is less than
         * or equal to <code>1989</code>.
         * </p>
         * <p>
         * <code>"lessThanOrEquals": { "key": "year", "value": 1989 }</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #lessThanOrEquals(FilterAttribute)}.
         * 
         * @param lessThanOrEquals
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lessThanOrEquals(FilterAttribute)
         */
        default Builder lessThanOrEquals(Consumer<FilterAttribute.Builder> lessThanOrEquals) {
            return lessThanOrEquals(FilterAttribute.builder().applyMutation(lessThanOrEquals).build());
        }

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value is a list that contains the <code>value</code> as one of its members.
         * </p>
         * <p>
         * The following example would return data sources with an <code>animals</code> attribute that is a list
         * containing a <code>cat</code> member (for example <code>["dog", "cat"]</code>).
         * </p>
         * <p>
         * <code>"listContains": { "key": "animals", "value": "cat" }</code>
         * </p>
         * 
         * @param listContains
         *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         *        <code>key</code> and whose value is a list that contains the <code>value</code> as one of its
         *        members.</p>
         *        <p>
         *        The following example would return data sources with an <code>animals</code> attribute that is a list
         *        containing a <code>cat</code> member (for example <code>["dog", "cat"]</code>).
         *        </p>
         *        <p>
         *        <code>"listContains": { "key": "animals", "value": "cat" }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listContains(FilterAttribute listContains);

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value is a list that contains the <code>value</code> as one of its members.
         * </p>
         * <p>
         * The following example would return data sources with an <code>animals</code> attribute that is a list
         * containing a <code>cat</code> member (for example <code>["dog", "cat"]</code>).
         * </p>
         * <p>
         * <code>"listContains": { "key": "animals", "value": "cat" }</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #listContains(FilterAttribute)}.
         * 
         * @param listContains
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listContains(FilterAttribute)
         */
        default Builder listContains(Consumer<FilterAttribute.Builder> listContains) {
            return listContains(FilterAttribute.builder().applyMutation(listContains).build());
        }

        /**
         * <p>
         * Knowledge base data sources that contain a metadata attribute whose name matches the <code>key</code> and
         * whose value doesn't match the <code>value</code> in this object are returned.
         * </p>
         * <p>
         * The following example would return data sources that don't contain an <code>animal</code> attribute whose
         * value is <code>cat</code>.
         * </p>
         * <p>
         * <code>"notEquals": { "key": "animal", "value": "cat" }</code>
         * </p>
         * 
         * @param notEquals
         *        Knowledge base data sources that contain a metadata attribute whose name matches the <code>key</code>
         *        and whose value doesn't match the <code>value</code> in this object are returned.</p>
         *        <p>
         *        The following example would return data sources that don't contain an <code>animal</code> attribute
         *        whose value is <code>cat</code>.
         *        </p>
         *        <p>
         *        <code>"notEquals": { "key": "animal", "value": "cat" }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEquals(FilterAttribute notEquals);

        /**
         * <p>
         * Knowledge base data sources that contain a metadata attribute whose name matches the <code>key</code> and
         * whose value doesn't match the <code>value</code> in this object are returned.
         * </p>
         * <p>
         * The following example would return data sources that don't contain an <code>animal</code> attribute whose
         * value is <code>cat</code>.
         * </p>
         * <p>
         * <code>"notEquals": { "key": "animal", "value": "cat" }</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #notEquals(FilterAttribute)}.
         * 
         * @param notEquals
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notEquals(FilterAttribute)
         */
        default Builder notEquals(Consumer<FilterAttribute.Builder> notEquals) {
            return notEquals(FilterAttribute.builder().applyMutation(notEquals).build());
        }

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value isn't in the list specified in the <code>value</code> in this object.
         * </p>
         * <p>
         * The following example would return data sources whose <code>animal</code> attribute is neither
         * <code>cat</code> nor <code>dog</code>.
         * </p>
         * <p>
         * <code>"notIn": { "key": "animal", "value": ["cat", "dog"] }</code>
         * </p>
         * 
         * @param notIn
         *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         *        <code>key</code> and whose value isn't in the list specified in the <code>value</code> in this
         *        object.</p>
         *        <p>
         *        The following example would return data sources whose <code>animal</code> attribute is neither
         *        <code>cat</code> nor <code>dog</code>.
         *        </p>
         *        <p>
         *        <code>"notIn": { "key": "animal", "value": ["cat", "dog"] }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notIn(FilterAttribute notIn);

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value isn't in the list specified in the <code>value</code> in this object.
         * </p>
         * <p>
         * The following example would return data sources whose <code>animal</code> attribute is neither
         * <code>cat</code> nor <code>dog</code>.
         * </p>
         * <p>
         * <code>"notIn": { "key": "animal", "value": ["cat", "dog"] }</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #notIn(FilterAttribute)}.
         * 
         * @param notIn
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notIn(FilterAttribute)
         */
        default Builder notIn(Consumer<FilterAttribute.Builder> notIn) {
            return notIn(FilterAttribute.builder().applyMutation(notIn).build());
        }

        /**
         * <p>
         * Knowledge base data sources are returned if their metadata attributes fulfill at least one of the filter
         * conditions inside this list.
         * </p>
         * 
         * @param orAll
         *        Knowledge base data sources are returned if their metadata attributes fulfill at least one of the
         *        filter conditions inside this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orAll(Collection<RetrievalFilter> orAll);

        /**
         * <p>
         * Knowledge base data sources are returned if their metadata attributes fulfill at least one of the filter
         * conditions inside this list.
         * </p>
         * 
         * @param orAll
         *        Knowledge base data sources are returned if their metadata attributes fulfill at least one of the
         *        filter conditions inside this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orAll(RetrievalFilter... orAll);

        /**
         * <p>
         * Knowledge base data sources are returned if their metadata attributes fulfill at least one of the filter
         * conditions inside this list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalFilter.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #orAll(List<RetrievalFilter>)}.
         * 
         * @param orAll
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orAll(java.util.Collection<RetrievalFilter>)
         */
        Builder orAll(Consumer<Builder>... orAll);

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value starts with the <code>value</code> in this object. This filter is currently
         * only supported for Amazon OpenSearch Serverless vector stores.
         * </p>
         * <p>
         * The following example would return data sources with an <code>animal</code> attribute starts with
         * <code>ca</code> (for example, <code>cat</code> or <code>camel</code>).
         * </p>
         * <p>
         * <code>"startsWith": { "key": "animal", "value": "ca" }</code>
         * </p>
         * 
         * @param startsWith
         *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         *        <code>key</code> and whose value starts with the <code>value</code> in this object. This filter is
         *        currently only supported for Amazon OpenSearch Serverless vector stores.</p>
         *        <p>
         *        The following example would return data sources with an <code>animal</code> attribute starts with
         *        <code>ca</code> (for example, <code>cat</code> or <code>camel</code>).
         *        </p>
         *        <p>
         *        <code>"startsWith": { "key": "animal", "value": "ca" }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startsWith(FilterAttribute startsWith);

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value starts with the <code>value</code> in this object. This filter is currently
         * only supported for Amazon OpenSearch Serverless vector stores.
         * </p>
         * <p>
         * The following example would return data sources with an <code>animal</code> attribute starts with
         * <code>ca</code> (for example, <code>cat</code> or <code>camel</code>).
         * </p>
         * <p>
         * <code>"startsWith": { "key": "animal", "value": "ca" }</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #startsWith(FilterAttribute)}.
         * 
         * @param startsWith
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startsWith(FilterAttribute)
         */
        default Builder startsWith(Consumer<FilterAttribute.Builder> startsWith) {
            return startsWith(FilterAttribute.builder().applyMutation(startsWith).build());
        }

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value is one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A string that contains the <code>value</code> as a substring. The following example would return data sources
         * with an <code>animal</code> attribute that contains the substring <code>at</code> (for example
         * <code>cat</code>).
         * </p>
         * <p>
         * <code>"stringContains": { "key": "animal", "value": "at" }</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * A list with a member that contains the <code>value</code> as a substring. The following example would return
         * data sources with an <code>animals</code> attribute that is a list containing a member that contains the
         * substring <code>at</code> (for example <code>["dog", "cat"]</code>).
         * </p>
         * <p>
         * <code>"stringContains": { "key": "animals", "value": "at" }</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param stringContains
         *        Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         *        <code>key</code> and whose value is one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        A string that contains the <code>value</code> as a substring. The following example would return data
         *        sources with an <code>animal</code> attribute that contains the substring <code>at</code> (for example
         *        <code>cat</code>).
         *        </p>
         *        <p>
         *        <code>"stringContains": { "key": "animal", "value": "at" }</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A list with a member that contains the <code>value</code> as a substring. The following example would
         *        return data sources with an <code>animals</code> attribute that is a list containing a member that
         *        contains the substring <code>at</code> (for example <code>["dog", "cat"]</code>).
         *        </p>
         *        <p>
         *        <code>"stringContains": { "key": "animals", "value": "at" }</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringContains(FilterAttribute stringContains);

        /**
         * <p>
         * Knowledge base data sources are returned if they contain a metadata attribute whose name matches the
         * <code>key</code> and whose value is one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A string that contains the <code>value</code> as a substring. The following example would return data sources
         * with an <code>animal</code> attribute that contains the substring <code>at</code> (for example
         * <code>cat</code>).
         * </p>
         * <p>
         * <code>"stringContains": { "key": "animal", "value": "at" }</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * A list with a member that contains the <code>value</code> as a substring. The following example would return
         * data sources with an <code>animals</code> attribute that is a list containing a member that contains the
         * substring <code>at</code> (for example <code>["dog", "cat"]</code>).
         * </p>
         * <p>
         * <code>"stringContains": { "key": "animals", "value": "at" }</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #stringContains(FilterAttribute)}.
         * 
         * @param stringContains
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringContains(FilterAttribute)
         */
        default Builder stringContains(Consumer<FilterAttribute.Builder> stringContains) {
            return stringContains(FilterAttribute.builder().applyMutation(stringContains).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<RetrievalFilter> andAll = DefaultSdkAutoConstructList.getInstance();

        private FilterAttribute equalsValue;

        private FilterAttribute greaterThan;

        private FilterAttribute greaterThanOrEquals;

        private FilterAttribute in;

        private FilterAttribute lessThan;

        private FilterAttribute lessThanOrEquals;

        private FilterAttribute listContains;

        private FilterAttribute notEquals;

        private FilterAttribute notIn;

        private List<RetrievalFilter> orAll = DefaultSdkAutoConstructList.getInstance();

        private FilterAttribute startsWith;

        private FilterAttribute stringContains;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievalFilter model) {
            andAll(model.andAll);
            equalsValue(model.equalsValue);
            greaterThan(model.greaterThan);
            greaterThanOrEquals(model.greaterThanOrEquals);
            in(model.in);
            lessThan(model.lessThan);
            lessThanOrEquals(model.lessThanOrEquals);
            listContains(model.listContains);
            notEquals(model.notEquals);
            notIn(model.notIn);
            orAll(model.orAll);
            startsWith(model.startsWith);
            stringContains(model.stringContains);
        }

        public final List<Builder> getAndAll() {
            List<Builder> result = RetrievalFilterListCopier.copyToBuilder(this.andAll);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndAll(Collection<BuilderImpl> andAll) {
            Object oldValue = this.andAll;
            this.andAll = RetrievalFilterListCopier.copyFromBuilder(andAll);
            handleUnionValueChange(Type.AND_ALL, oldValue, this.andAll);
        }

        @Override
        public final Builder andAll(Collection<RetrievalFilter> andAll) {
            Object oldValue = this.andAll;
            this.andAll = RetrievalFilterListCopier.copy(andAll);
            handleUnionValueChange(Type.AND_ALL, oldValue, this.andAll);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAll(RetrievalFilter... andAll) {
            andAll(Arrays.asList(andAll));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAll(Consumer<Builder>... andAll) {
            andAll(Stream.of(andAll).map(c -> RetrievalFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final FilterAttribute.Builder getEqualsValue() {
            return equalsValue != null ? equalsValue.toBuilder() : null;
        }

        public final void setEqualsValue(FilterAttribute.BuilderImpl equalsValue) {
            Object oldValue = this.equalsValue;
            this.equalsValue = equalsValue != null ? equalsValue.build() : null;
            handleUnionValueChange(Type.EQUALS, oldValue, this.equalsValue);
        }

        @Override
        public final Builder equalsValue(FilterAttribute equalsValue) {
            Object oldValue = this.equalsValue;
            this.equalsValue = equalsValue;
            handleUnionValueChange(Type.EQUALS, oldValue, this.equalsValue);
            return this;
        }

        public final FilterAttribute.Builder getGreaterThan() {
            return greaterThan != null ? greaterThan.toBuilder() : null;
        }

        public final void setGreaterThan(FilterAttribute.BuilderImpl greaterThan) {
            Object oldValue = this.greaterThan;
            this.greaterThan = greaterThan != null ? greaterThan.build() : null;
            handleUnionValueChange(Type.GREATER_THAN, oldValue, this.greaterThan);
        }

        @Override
        public final Builder greaterThan(FilterAttribute greaterThan) {
            Object oldValue = this.greaterThan;
            this.greaterThan = greaterThan;
            handleUnionValueChange(Type.GREATER_THAN, oldValue, this.greaterThan);
            return this;
        }

        public final FilterAttribute.Builder getGreaterThanOrEquals() {
            return greaterThanOrEquals != null ? greaterThanOrEquals.toBuilder() : null;
        }

        public final void setGreaterThanOrEquals(FilterAttribute.BuilderImpl greaterThanOrEquals) {
            Object oldValue = this.greaterThanOrEquals;
            this.greaterThanOrEquals = greaterThanOrEquals != null ? greaterThanOrEquals.build() : null;
            handleUnionValueChange(Type.GREATER_THAN_OR_EQUALS, oldValue, this.greaterThanOrEquals);
        }

        @Override
        public final Builder greaterThanOrEquals(FilterAttribute greaterThanOrEquals) {
            Object oldValue = this.greaterThanOrEquals;
            this.greaterThanOrEquals = greaterThanOrEquals;
            handleUnionValueChange(Type.GREATER_THAN_OR_EQUALS, oldValue, this.greaterThanOrEquals);
            return this;
        }

        public final FilterAttribute.Builder getIn() {
            return in != null ? in.toBuilder() : null;
        }

        public final void setIn(FilterAttribute.BuilderImpl in) {
            Object oldValue = this.in;
            this.in = in != null ? in.build() : null;
            handleUnionValueChange(Type.IN, oldValue, this.in);
        }

        @Override
        public final Builder in(FilterAttribute in) {
            Object oldValue = this.in;
            this.in = in;
            handleUnionValueChange(Type.IN, oldValue, this.in);
            return this;
        }

        public final FilterAttribute.Builder getLessThan() {
            return lessThan != null ? lessThan.toBuilder() : null;
        }

        public final void setLessThan(FilterAttribute.BuilderImpl lessThan) {
            Object oldValue = this.lessThan;
            this.lessThan = lessThan != null ? lessThan.build() : null;
            handleUnionValueChange(Type.LESS_THAN, oldValue, this.lessThan);
        }

        @Override
        public final Builder lessThan(FilterAttribute lessThan) {
            Object oldValue = this.lessThan;
            this.lessThan = lessThan;
            handleUnionValueChange(Type.LESS_THAN, oldValue, this.lessThan);
            return this;
        }

        public final FilterAttribute.Builder getLessThanOrEquals() {
            return lessThanOrEquals != null ? lessThanOrEquals.toBuilder() : null;
        }

        public final void setLessThanOrEquals(FilterAttribute.BuilderImpl lessThanOrEquals) {
            Object oldValue = this.lessThanOrEquals;
            this.lessThanOrEquals = lessThanOrEquals != null ? lessThanOrEquals.build() : null;
            handleUnionValueChange(Type.LESS_THAN_OR_EQUALS, oldValue, this.lessThanOrEquals);
        }

        @Override
        public final Builder lessThanOrEquals(FilterAttribute lessThanOrEquals) {
            Object oldValue = this.lessThanOrEquals;
            this.lessThanOrEquals = lessThanOrEquals;
            handleUnionValueChange(Type.LESS_THAN_OR_EQUALS, oldValue, this.lessThanOrEquals);
            return this;
        }

        public final FilterAttribute.Builder getListContains() {
            return listContains != null ? listContains.toBuilder() : null;
        }

        public final void setListContains(FilterAttribute.BuilderImpl listContains) {
            Object oldValue = this.listContains;
            this.listContains = listContains != null ? listContains.build() : null;
            handleUnionValueChange(Type.LIST_CONTAINS, oldValue, this.listContains);
        }

        @Override
        public final Builder listContains(FilterAttribute listContains) {
            Object oldValue = this.listContains;
            this.listContains = listContains;
            handleUnionValueChange(Type.LIST_CONTAINS, oldValue, this.listContains);
            return this;
        }

        public final FilterAttribute.Builder getNotEquals() {
            return notEquals != null ? notEquals.toBuilder() : null;
        }

        public final void setNotEquals(FilterAttribute.BuilderImpl notEquals) {
            Object oldValue = this.notEquals;
            this.notEquals = notEquals != null ? notEquals.build() : null;
            handleUnionValueChange(Type.NOT_EQUALS, oldValue, this.notEquals);
        }

        @Override
        public final Builder notEquals(FilterAttribute notEquals) {
            Object oldValue = this.notEquals;
            this.notEquals = notEquals;
            handleUnionValueChange(Type.NOT_EQUALS, oldValue, this.notEquals);
            return this;
        }

        public final FilterAttribute.Builder getNotIn() {
            return notIn != null ? notIn.toBuilder() : null;
        }

        public final void setNotIn(FilterAttribute.BuilderImpl notIn) {
            Object oldValue = this.notIn;
            this.notIn = notIn != null ? notIn.build() : null;
            handleUnionValueChange(Type.NOT_IN, oldValue, this.notIn);
        }

        @Override
        public final Builder notIn(FilterAttribute notIn) {
            Object oldValue = this.notIn;
            this.notIn = notIn;
            handleUnionValueChange(Type.NOT_IN, oldValue, this.notIn);
            return this;
        }

        public final List<Builder> getOrAll() {
            List<Builder> result = RetrievalFilterListCopier.copyToBuilder(this.orAll);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrAll(Collection<BuilderImpl> orAll) {
            Object oldValue = this.orAll;
            this.orAll = RetrievalFilterListCopier.copyFromBuilder(orAll);
            handleUnionValueChange(Type.OR_ALL, oldValue, this.orAll);
        }

        @Override
        public final Builder orAll(Collection<RetrievalFilter> orAll) {
            Object oldValue = this.orAll;
            this.orAll = RetrievalFilterListCopier.copy(orAll);
            handleUnionValueChange(Type.OR_ALL, oldValue, this.orAll);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAll(RetrievalFilter... orAll) {
            orAll(Arrays.asList(orAll));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAll(Consumer<Builder>... orAll) {
            orAll(Stream.of(orAll).map(c -> RetrievalFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final FilterAttribute.Builder getStartsWith() {
            return startsWith != null ? startsWith.toBuilder() : null;
        }

        public final void setStartsWith(FilterAttribute.BuilderImpl startsWith) {
            Object oldValue = this.startsWith;
            this.startsWith = startsWith != null ? startsWith.build() : null;
            handleUnionValueChange(Type.STARTS_WITH, oldValue, this.startsWith);
        }

        @Override
        public final Builder startsWith(FilterAttribute startsWith) {
            Object oldValue = this.startsWith;
            this.startsWith = startsWith;
            handleUnionValueChange(Type.STARTS_WITH, oldValue, this.startsWith);
            return this;
        }

        public final FilterAttribute.Builder getStringContains() {
            return stringContains != null ? stringContains.toBuilder() : null;
        }

        public final void setStringContains(FilterAttribute.BuilderImpl stringContains) {
            Object oldValue = this.stringContains;
            this.stringContains = stringContains != null ? stringContains.build() : null;
            handleUnionValueChange(Type.STRING_CONTAINS, oldValue, this.stringContains);
        }

        @Override
        public final Builder stringContains(FilterAttribute stringContains) {
            Object oldValue = this.stringContains;
            this.stringContains = stringContains;
            handleUnionValueChange(Type.STRING_CONTAINS, oldValue, this.stringContains);
            return this;
        }

        @Override
        public RetrievalFilter build() {
            return new RetrievalFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RetrievalFilter#type()
     */
    public enum Type {
        AND_ALL,

        EQUALS,

        GREATER_THAN,

        GREATER_THAN_OR_EQUALS,

        IN,

        LESS_THAN,

        LESS_THAN_OR_EQUALS,

        LIST_CONTAINS,

        NOT_EQUALS,

        NOT_IN,

        OR_ALL,

        STARTS_WITH,

        STRING_CONTAINS,

        UNKNOWN_TO_SDK_VERSION
    }
}
