/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockModelConfigurations;
import software.amazon.awssdk.services.bedrockagentruntime.model.PromptCreationConfigurations;
import software.amazon.awssdk.services.bedrockagentruntime.model.SessionState;
import software.amazon.awssdk.services.bedrockagentruntime.model.StreamingConfigurations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeAgentRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, InvokeAgentRequest> {
    private static final SdkField<SessionState> SESSION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sessionState").getter(InvokeAgentRequest.getter(InvokeAgentRequest::sessionState)).setter(InvokeAgentRequest.setter(Builder::sessionState)).constructor(SessionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionState").build()}).build();
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(InvokeAgentRequest.getter(InvokeAgentRequest::agentId)).setter(InvokeAgentRequest.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()}).build();
    private static final SdkField<String> AGENT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentAliasId").getter(InvokeAgentRequest.getter(InvokeAgentRequest::agentAliasId)).setter(InvokeAgentRequest.setter(Builder::agentAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentAliasId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(InvokeAgentRequest.getter(InvokeAgentRequest::sessionId)).setter(InvokeAgentRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final SdkField<Boolean> END_SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("endSession").getter(InvokeAgentRequest.getter(InvokeAgentRequest::endSession)).setter(InvokeAgentRequest.setter(Builder::endSession)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endSession").build()}).build();
    private static final SdkField<Boolean> ENABLE_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableTrace").getter(InvokeAgentRequest.getter(InvokeAgentRequest::enableTrace)).setter(InvokeAgentRequest.setter(Builder::enableTrace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableTrace").build()}).build();
    private static final SdkField<String> INPUT_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputText").getter(InvokeAgentRequest.getter(InvokeAgentRequest::inputText)).setter(InvokeAgentRequest.setter(Builder::inputText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputText").build()}).build();
    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryId").getter(InvokeAgentRequest.getter(InvokeAgentRequest::memoryId)).setter(InvokeAgentRequest.setter(Builder::memoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryId").build()}).build();
    private static final SdkField<BedrockModelConfigurations> BEDROCK_MODEL_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("bedrockModelConfigurations").getter(InvokeAgentRequest.getter(InvokeAgentRequest::bedrockModelConfigurations)).setter(InvokeAgentRequest.setter(Builder::bedrockModelConfigurations)).constructor(BedrockModelConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockModelConfigurations").build()}).build();
    private static final SdkField<StreamingConfigurations> STREAMING_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("streamingConfigurations").getter(InvokeAgentRequest.getter(InvokeAgentRequest::streamingConfigurations)).setter(InvokeAgentRequest.setter(Builder::streamingConfigurations)).constructor(StreamingConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingConfigurations").build()}).build();
    private static final SdkField<PromptCreationConfigurations> PROMPT_CREATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("promptCreationConfigurations").getter(InvokeAgentRequest.getter(InvokeAgentRequest::promptCreationConfigurations)).setter(InvokeAgentRequest.setter(Builder::promptCreationConfigurations)).constructor(PromptCreationConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptCreationConfigurations").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceArn").getter(InvokeAgentRequest.getter(InvokeAgentRequest::sourceArn)).setter(InvokeAgentRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-source-arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_STATE_FIELD, AGENT_ID_FIELD, AGENT_ALIAS_ID_FIELD, SESSION_ID_FIELD, END_SESSION_FIELD, ENABLE_TRACE_FIELD, INPUT_TEXT_FIELD, MEMORY_ID_FIELD, BEDROCK_MODEL_CONFIGURATIONS_FIELD, STREAMING_CONFIGURATIONS_FIELD, PROMPT_CREATION_CONFIGURATIONS_FIELD, SOURCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeAgentRequest.memberNameToFieldInitializer();
    private final SessionState sessionState;
    private final String agentId;
    private final String agentAliasId;
    private final String sessionId;
    private final Boolean endSession;
    private final Boolean enableTrace;
    private final String inputText;
    private final String memoryId;
    private final BedrockModelConfigurations bedrockModelConfigurations;
    private final StreamingConfigurations streamingConfigurations;
    private final PromptCreationConfigurations promptCreationConfigurations;
    private final String sourceArn;

    private InvokeAgentRequest(BuilderImpl builder) {
        super(builder);
        this.sessionState = builder.sessionState;
        this.agentId = builder.agentId;
        this.agentAliasId = builder.agentAliasId;
        this.sessionId = builder.sessionId;
        this.endSession = builder.endSession;
        this.enableTrace = builder.enableTrace;
        this.inputText = builder.inputText;
        this.memoryId = builder.memoryId;
        this.bedrockModelConfigurations = builder.bedrockModelConfigurations;
        this.streamingConfigurations = builder.streamingConfigurations;
        this.promptCreationConfigurations = builder.promptCreationConfigurations;
        this.sourceArn = builder.sourceArn;
    }

    public final SessionState sessionState() {
        return this.sessionState;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String agentAliasId() {
        return this.agentAliasId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Boolean endSession() {
        return this.endSession;
    }

    public final Boolean enableTrace() {
        return this.enableTrace;
    }

    public final String inputText() {
        return this.inputText;
    }

    public final String memoryId() {
        return this.memoryId;
    }

    public final BedrockModelConfigurations bedrockModelConfigurations() {
        return this.bedrockModelConfigurations;
    }

    public final StreamingConfigurations streamingConfigurations() {
        return this.streamingConfigurations;
    }

    public final PromptCreationConfigurations promptCreationConfigurations() {
        return this.promptCreationConfigurations;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endSession());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableTrace());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputText());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bedrockModelConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptCreationConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeAgentRequest)) {
            return false;
        }
        InvokeAgentRequest other = (InvokeAgentRequest)((Object)obj);
        return Objects.equals(this.sessionState(), other.sessionState()) && Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.agentAliasId(), other.agentAliasId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.endSession(), other.endSession()) && Objects.equals(this.enableTrace(), other.enableTrace()) && Objects.equals(this.inputText(), other.inputText()) && Objects.equals(this.memoryId(), other.memoryId()) && Objects.equals(this.bedrockModelConfigurations(), other.bedrockModelConfigurations()) && Objects.equals(this.streamingConfigurations(), other.streamingConfigurations()) && Objects.equals(this.promptCreationConfigurations(), other.promptCreationConfigurations()) && Objects.equals(this.sourceArn(), other.sourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeAgentRequest").add("SessionState", (Object)this.sessionState()).add("AgentId", (Object)this.agentId()).add("AgentAliasId", (Object)this.agentAliasId()).add("SessionId", (Object)this.sessionId()).add("EndSession", (Object)this.endSession()).add("EnableTrace", (Object)this.enableTrace()).add("InputText", (Object)(this.inputText() == null ? null : "*** Sensitive Data Redacted ***")).add("MemoryId", (Object)this.memoryId()).add("BedrockModelConfigurations", (Object)this.bedrockModelConfigurations()).add("StreamingConfigurations", (Object)this.streamingConfigurations()).add("PromptCreationConfigurations", (Object)this.promptCreationConfigurations()).add("SourceArn", (Object)this.sourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionState": {
                return Optional.ofNullable(clazz.cast(this.sessionState()));
            }
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "agentAliasId": {
                return Optional.ofNullable(clazz.cast(this.agentAliasId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "endSession": {
                return Optional.ofNullable(clazz.cast(this.endSession()));
            }
            case "enableTrace": {
                return Optional.ofNullable(clazz.cast(this.enableTrace()));
            }
            case "inputText": {
                return Optional.ofNullable(clazz.cast(this.inputText()));
            }
            case "memoryId": {
                return Optional.ofNullable(clazz.cast(this.memoryId()));
            }
            case "bedrockModelConfigurations": {
                return Optional.ofNullable(clazz.cast(this.bedrockModelConfigurations()));
            }
            case "streamingConfigurations": {
                return Optional.ofNullable(clazz.cast(this.streamingConfigurations()));
            }
            case "promptCreationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.promptCreationConfigurations()));
            }
            case "sourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionState", SESSION_STATE_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentAliasId", AGENT_ALIAS_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("endSession", END_SESSION_FIELD);
        map.put("enableTrace", ENABLE_TRACE_FIELD);
        map.put("inputText", INPUT_TEXT_FIELD);
        map.put("memoryId", MEMORY_ID_FIELD);
        map.put("bedrockModelConfigurations", BEDROCK_MODEL_CONFIGURATIONS_FIELD);
        map.put("streamingConfigurations", STREAMING_CONFIGURATIONS_FIELD);
        map.put("promptCreationConfigurations", PROMPT_CREATION_CONFIGURATIONS_FIELD);
        map.put("x-amz-source-arn", SOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeAgentRequest, T> g) {
        return obj -> g.apply((InvokeAgentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private SessionState sessionState;
        private String agentId;
        private String agentAliasId;
        private String sessionId;
        private Boolean endSession;
        private Boolean enableTrace;
        private String inputText;
        private String memoryId;
        private BedrockModelConfigurations bedrockModelConfigurations;
        private StreamingConfigurations streamingConfigurations;
        private PromptCreationConfigurations promptCreationConfigurations;
        private String sourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeAgentRequest model) {
            super(model);
            this.sessionState(model.sessionState);
            this.agentId(model.agentId);
            this.agentAliasId(model.agentAliasId);
            this.sessionId(model.sessionId);
            this.endSession(model.endSession);
            this.enableTrace(model.enableTrace);
            this.inputText(model.inputText);
            this.memoryId(model.memoryId);
            this.bedrockModelConfigurations(model.bedrockModelConfigurations);
            this.streamingConfigurations(model.streamingConfigurations);
            this.promptCreationConfigurations(model.promptCreationConfigurations);
            this.sourceArn(model.sourceArn);
        }

        public final SessionState.Builder getSessionState() {
            return this.sessionState != null ? this.sessionState.toBuilder() : null;
        }

        public final void setSessionState(SessionState.BuilderImpl sessionState) {
            this.sessionState = sessionState != null ? sessionState.build() : null;
        }

        @Override
        public final Builder sessionState(SessionState sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentAliasId() {
            return this.agentAliasId;
        }

        public final void setAgentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
        }

        @Override
        public final Builder agentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Boolean getEndSession() {
            return this.endSession;
        }

        public final void setEndSession(Boolean endSession) {
            this.endSession = endSession;
        }

        @Override
        public final Builder endSession(Boolean endSession) {
            this.endSession = endSession;
            return this;
        }

        public final Boolean getEnableTrace() {
            return this.enableTrace;
        }

        public final void setEnableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
        }

        @Override
        public final Builder enableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
            return this;
        }

        public final String getInputText() {
            return this.inputText;
        }

        public final void setInputText(String inputText) {
            this.inputText = inputText;
        }

        @Override
        public final Builder inputText(String inputText) {
            this.inputText = inputText;
            return this;
        }

        public final String getMemoryId() {
            return this.memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final BedrockModelConfigurations.Builder getBedrockModelConfigurations() {
            return this.bedrockModelConfigurations != null ? this.bedrockModelConfigurations.toBuilder() : null;
        }

        public final void setBedrockModelConfigurations(BedrockModelConfigurations.BuilderImpl bedrockModelConfigurations) {
            this.bedrockModelConfigurations = bedrockModelConfigurations != null ? bedrockModelConfigurations.build() : null;
        }

        @Override
        public final Builder bedrockModelConfigurations(BedrockModelConfigurations bedrockModelConfigurations) {
            this.bedrockModelConfigurations = bedrockModelConfigurations;
            return this;
        }

        public final StreamingConfigurations.Builder getStreamingConfigurations() {
            return this.streamingConfigurations != null ? this.streamingConfigurations.toBuilder() : null;
        }

        public final void setStreamingConfigurations(StreamingConfigurations.BuilderImpl streamingConfigurations) {
            this.streamingConfigurations = streamingConfigurations != null ? streamingConfigurations.build() : null;
        }

        @Override
        public final Builder streamingConfigurations(StreamingConfigurations streamingConfigurations) {
            this.streamingConfigurations = streamingConfigurations;
            return this;
        }

        public final PromptCreationConfigurations.Builder getPromptCreationConfigurations() {
            return this.promptCreationConfigurations != null ? this.promptCreationConfigurations.toBuilder() : null;
        }

        public final void setPromptCreationConfigurations(PromptCreationConfigurations.BuilderImpl promptCreationConfigurations) {
            this.promptCreationConfigurations = promptCreationConfigurations != null ? promptCreationConfigurations.build() : null;
        }

        @Override
        public final Builder promptCreationConfigurations(PromptCreationConfigurations promptCreationConfigurations) {
            this.promptCreationConfigurations = promptCreationConfigurations;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeAgentRequest build() {
            return new InvokeAgentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeAgentRequest> {
        public Builder sessionState(SessionState var1);

        default public Builder sessionState(Consumer<SessionState.Builder> sessionState) {
            return this.sessionState((SessionState)((SessionState.Builder)SessionState.builder().applyMutation(sessionState)).build());
        }

        public Builder agentId(String var1);

        public Builder agentAliasId(String var1);

        public Builder sessionId(String var1);

        public Builder endSession(Boolean var1);

        public Builder enableTrace(Boolean var1);

        public Builder inputText(String var1);

        public Builder memoryId(String var1);

        public Builder bedrockModelConfigurations(BedrockModelConfigurations var1);

        default public Builder bedrockModelConfigurations(Consumer<BedrockModelConfigurations.Builder> bedrockModelConfigurations) {
            return this.bedrockModelConfigurations((BedrockModelConfigurations)((BedrockModelConfigurations.Builder)BedrockModelConfigurations.builder().applyMutation(bedrockModelConfigurations)).build());
        }

        public Builder streamingConfigurations(StreamingConfigurations var1);

        default public Builder streamingConfigurations(Consumer<StreamingConfigurations.Builder> streamingConfigurations) {
            return this.streamingConfigurations((StreamingConfigurations)((StreamingConfigurations.Builder)StreamingConfigurations.builder().applyMutation(streamingConfigurations)).build());
        }

        public Builder promptCreationConfigurations(PromptCreationConfigurations var1);

        default public Builder promptCreationConfigurations(Consumer<PromptCreationConfigurations.Builder> promptCreationConfigurations) {
            return this.promptCreationConfigurations((PromptCreationConfigurations)((PromptCreationConfigurations.Builder)PromptCreationConfigurations.builder().applyMutation(promptCreationConfigurations)).build());
        }

        public Builder sourceArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

