/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankDocument;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RerankResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RerankResult> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("index").getter(RerankResult.getter(RerankResult::index)).setter(RerankResult.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()}).build();
    private static final SdkField<Float> RELEVANCE_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("relevanceScore").getter(RerankResult.getter(RerankResult::relevanceScore)).setter(RerankResult.setter(Builder::relevanceScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceScore").build()}).build();
    private static final SdkField<RerankDocument> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("document").getter(RerankResult.getter(RerankResult::document)).setter(RerankResult.setter(Builder::document)).constructor(RerankDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, RELEVANCE_SCORE_FIELD, DOCUMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RerankResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer index;
    private final Float relevanceScore;
    private final RerankDocument document;

    private RerankResult(BuilderImpl builder) {
        this.index = builder.index;
        this.relevanceScore = builder.relevanceScore;
        this.document = builder.document;
    }

    public final Integer index() {
        return this.index;
    }

    public final Float relevanceScore() {
        return this.relevanceScore;
    }

    public final RerankDocument document() {
        return this.document;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.relevanceScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RerankResult)) {
            return false;
        }
        RerankResult other = (RerankResult)obj;
        return Objects.equals(this.index(), other.index()) && Objects.equals(this.relevanceScore(), other.relevanceScore()) && Objects.equals(this.document(), other.document());
    }

    public final String toString() {
        return ToString.builder((String)"RerankResult").add("Index", (Object)this.index()).add("RelevanceScore", (Object)this.relevanceScore()).add("Document", (Object)(this.document() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "relevanceScore": {
                return Optional.ofNullable(clazz.cast(this.relevanceScore()));
            }
            case "document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("index", INDEX_FIELD);
        map.put("relevanceScore", RELEVANCE_SCORE_FIELD);
        map.put("document", DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RerankResult, T> g) {
        return obj -> g.apply((RerankResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer index;
        private Float relevanceScore;
        private RerankDocument document;

        private BuilderImpl() {
        }

        private BuilderImpl(RerankResult model) {
            this.index(model.index);
            this.relevanceScore(model.relevanceScore);
            this.document(model.document);
        }

        public final Integer getIndex() {
            return this.index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final Float getRelevanceScore() {
            return this.relevanceScore;
        }

        public final void setRelevanceScore(Float relevanceScore) {
            this.relevanceScore = relevanceScore;
        }

        @Override
        public final Builder relevanceScore(Float relevanceScore) {
            this.relevanceScore = relevanceScore;
            return this;
        }

        public final RerankDocument.Builder getDocument() {
            return this.document != null ? this.document.toBuilder() : null;
        }

        public final void setDocument(RerankDocument.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public final Builder document(RerankDocument document) {
            this.document = document;
            return this;
        }

        public RerankResult build() {
            return new RerankResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RerankResult> {
        public Builder index(Integer var1);

        public Builder relevanceScore(Float var1);

        public Builder document(RerankDocument var1);

        default public Builder document(Consumer<RerankDocument.Builder> document) {
            return this.document((RerankDocument)((RerankDocument.Builder)RerankDocument.builder().applyMutation(document)).build());
        }
    }
}

