/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateConfiguration;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateSessionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrieveAndGenerateRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, RetrieveAndGenerateRequest> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(RetrieveAndGenerateRequest.getter(RetrieveAndGenerateRequest::sessionId)).setter(RetrieveAndGenerateRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<RetrieveAndGenerateInput> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("input").getter(RetrieveAndGenerateRequest.getter(RetrieveAndGenerateRequest::input)).setter(RetrieveAndGenerateRequest.setter(Builder::input)).constructor(RetrieveAndGenerateInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<RetrieveAndGenerateConfiguration> RETRIEVE_AND_GENERATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retrieveAndGenerateConfiguration").getter(RetrieveAndGenerateRequest.getter(RetrieveAndGenerateRequest::retrieveAndGenerateConfiguration)).setter(RetrieveAndGenerateRequest.setter(Builder::retrieveAndGenerateConfiguration)).constructor(RetrieveAndGenerateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieveAndGenerateConfiguration").build()}).build();
    private static final SdkField<RetrieveAndGenerateSessionConfiguration> SESSION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sessionConfiguration").getter(RetrieveAndGenerateRequest.getter(RetrieveAndGenerateRequest::sessionConfiguration)).setter(RetrieveAndGenerateRequest.setter(Builder::sessionConfiguration)).constructor(RetrieveAndGenerateSessionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, INPUT_FIELD, RETRIEVE_AND_GENERATE_CONFIGURATION_FIELD, SESSION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetrieveAndGenerateRequest.memberNameToFieldInitializer();
    private final String sessionId;
    private final RetrieveAndGenerateInput input;
    private final RetrieveAndGenerateConfiguration retrieveAndGenerateConfiguration;
    private final RetrieveAndGenerateSessionConfiguration sessionConfiguration;

    private RetrieveAndGenerateRequest(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.input = builder.input;
        this.retrieveAndGenerateConfiguration = builder.retrieveAndGenerateConfiguration;
        this.sessionConfiguration = builder.sessionConfiguration;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final RetrieveAndGenerateInput input() {
        return this.input;
    }

    public final RetrieveAndGenerateConfiguration retrieveAndGenerateConfiguration() {
        return this.retrieveAndGenerateConfiguration;
    }

    public final RetrieveAndGenerateSessionConfiguration sessionConfiguration() {
        return this.sessionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrieveAndGenerateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveAndGenerateRequest)) {
            return false;
        }
        RetrieveAndGenerateRequest other = (RetrieveAndGenerateRequest)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.retrieveAndGenerateConfiguration(), other.retrieveAndGenerateConfiguration()) && Objects.equals(this.sessionConfiguration(), other.sessionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"RetrieveAndGenerateRequest").add("SessionId", (Object)this.sessionId()).add("Input", (Object)(this.input() == null ? null : "*** Sensitive Data Redacted ***")).add("RetrieveAndGenerateConfiguration", (Object)this.retrieveAndGenerateConfiguration()).add("SessionConfiguration", (Object)this.sessionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "retrieveAndGenerateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.retrieveAndGenerateConfiguration()));
            }
            case "sessionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sessionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("input", INPUT_FIELD);
        map.put("retrieveAndGenerateConfiguration", RETRIEVE_AND_GENERATE_CONFIGURATION_FIELD);
        map.put("sessionConfiguration", SESSION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrieveAndGenerateRequest, T> g) {
        return obj -> g.apply((RetrieveAndGenerateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private String sessionId;
        private RetrieveAndGenerateInput input;
        private RetrieveAndGenerateConfiguration retrieveAndGenerateConfiguration;
        private RetrieveAndGenerateSessionConfiguration sessionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveAndGenerateRequest model) {
            super(model);
            this.sessionId(model.sessionId);
            this.input(model.input);
            this.retrieveAndGenerateConfiguration(model.retrieveAndGenerateConfiguration);
            this.sessionConfiguration(model.sessionConfiguration);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final RetrieveAndGenerateInput.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        public final void setInput(RetrieveAndGenerateInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(RetrieveAndGenerateInput input) {
            this.input = input;
            return this;
        }

        public final RetrieveAndGenerateConfiguration.Builder getRetrieveAndGenerateConfiguration() {
            return this.retrieveAndGenerateConfiguration != null ? this.retrieveAndGenerateConfiguration.toBuilder() : null;
        }

        public final void setRetrieveAndGenerateConfiguration(RetrieveAndGenerateConfiguration.BuilderImpl retrieveAndGenerateConfiguration) {
            this.retrieveAndGenerateConfiguration = retrieveAndGenerateConfiguration != null ? retrieveAndGenerateConfiguration.build() : null;
        }

        @Override
        public final Builder retrieveAndGenerateConfiguration(RetrieveAndGenerateConfiguration retrieveAndGenerateConfiguration) {
            this.retrieveAndGenerateConfiguration = retrieveAndGenerateConfiguration;
            return this;
        }

        public final RetrieveAndGenerateSessionConfiguration.Builder getSessionConfiguration() {
            return this.sessionConfiguration != null ? this.sessionConfiguration.toBuilder() : null;
        }

        public final void setSessionConfiguration(RetrieveAndGenerateSessionConfiguration.BuilderImpl sessionConfiguration) {
            this.sessionConfiguration = sessionConfiguration != null ? sessionConfiguration.build() : null;
        }

        @Override
        public final Builder sessionConfiguration(RetrieveAndGenerateSessionConfiguration sessionConfiguration) {
            this.sessionConfiguration = sessionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetrieveAndGenerateRequest build() {
            return new RetrieveAndGenerateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RetrieveAndGenerateRequest> {
        public Builder sessionId(String var1);

        public Builder input(RetrieveAndGenerateInput var1);

        default public Builder input(Consumer<RetrieveAndGenerateInput.Builder> input) {
            return this.input((RetrieveAndGenerateInput)((RetrieveAndGenerateInput.Builder)RetrieveAndGenerateInput.builder().applyMutation(input)).build());
        }

        public Builder retrieveAndGenerateConfiguration(RetrieveAndGenerateConfiguration var1);

        default public Builder retrieveAndGenerateConfiguration(Consumer<RetrieveAndGenerateConfiguration.Builder> retrieveAndGenerateConfiguration) {
            return this.retrieveAndGenerateConfiguration((RetrieveAndGenerateConfiguration)((RetrieveAndGenerateConfiguration.Builder)RetrieveAndGenerateConfiguration.builder().applyMutation(retrieveAndGenerateConfiguration)).build());
        }

        public Builder sessionConfiguration(RetrieveAndGenerateSessionConfiguration var1);

        default public Builder sessionConfiguration(Consumer<RetrieveAndGenerateSessionConfiguration.Builder> sessionConfiguration) {
            return this.sessionConfiguration((RetrieveAndGenerateSessionConfiguration)((RetrieveAndGenerateSessionConfiguration.Builder)RetrieveAndGenerateSessionConfiguration.builder().applyMutation(sessionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

