/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockagentruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionEventsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionEventsResponse;

public class ListFlowExecutionEventsPublisher
implements SdkPublisher<ListFlowExecutionEventsResponse> {
    private final BedrockAgentRuntimeAsyncClient client;
    private final ListFlowExecutionEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFlowExecutionEventsPublisher(BedrockAgentRuntimeAsyncClient client, ListFlowExecutionEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFlowExecutionEventsPublisher(BedrockAgentRuntimeAsyncClient client, ListFlowExecutionEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFlowExecutionEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFlowExecutionEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FlowExecutionEvent> flowExecutionEvents() {
        Function<ListFlowExecutionEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowExecutionEvents() != null) {
                return response.flowExecutionEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFlowExecutionEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFlowExecutionEventsResponseFetcher
    implements AsyncPageFetcher<ListFlowExecutionEventsResponse> {
        private ListFlowExecutionEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowExecutionEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFlowExecutionEventsResponse> nextPage(ListFlowExecutionEventsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowExecutionEventsPublisher.this.client.listFlowExecutionEvents(ListFlowExecutionEventsPublisher.this.firstRequest);
            }
            return ListFlowExecutionEventsPublisher.this.client.listFlowExecutionEvents((ListFlowExecutionEventsRequest)((Object)ListFlowExecutionEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

