/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExecutionFlowSnapshotResponse
extends BedrockAgentRuntimeResponse
implements ToCopyableBuilder<Builder, GetExecutionFlowSnapshotResponse> {
    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowIdentifier").getter(GetExecutionFlowSnapshotResponse.getter(GetExecutionFlowSnapshotResponse::flowIdentifier)).setter(GetExecutionFlowSnapshotResponse.setter(Builder::flowIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowIdentifier").build()}).build();
    private static final SdkField<String> FLOW_ALIAS_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowAliasIdentifier").getter(GetExecutionFlowSnapshotResponse.getter(GetExecutionFlowSnapshotResponse::flowAliasIdentifier)).setter(GetExecutionFlowSnapshotResponse.setter(Builder::flowAliasIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowAliasIdentifier").build()}).build();
    private static final SdkField<String> FLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowVersion").getter(GetExecutionFlowSnapshotResponse.getter(GetExecutionFlowSnapshotResponse::flowVersion)).setter(GetExecutionFlowSnapshotResponse.setter(Builder::flowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowVersion").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(GetExecutionFlowSnapshotResponse.getter(GetExecutionFlowSnapshotResponse::executionRoleArn)).setter(GetExecutionFlowSnapshotResponse.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definition").getter(GetExecutionFlowSnapshotResponse.getter(GetExecutionFlowSnapshotResponse::definition)).setter(GetExecutionFlowSnapshotResponse.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerEncryptionKeyArn").getter(GetExecutionFlowSnapshotResponse.getter(GetExecutionFlowSnapshotResponse::customerEncryptionKeyArn)).setter(GetExecutionFlowSnapshotResponse.setter(Builder::customerEncryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_IDENTIFIER_FIELD, FLOW_ALIAS_IDENTIFIER_FIELD, FLOW_VERSION_FIELD, EXECUTION_ROLE_ARN_FIELD, DEFINITION_FIELD, CUSTOMER_ENCRYPTION_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetExecutionFlowSnapshotResponse.memberNameToFieldInitializer();
    private final String flowIdentifier;
    private final String flowAliasIdentifier;
    private final String flowVersion;
    private final String executionRoleArn;
    private final String definition;
    private final String customerEncryptionKeyArn;

    private GetExecutionFlowSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.flowIdentifier = builder.flowIdentifier;
        this.flowAliasIdentifier = builder.flowAliasIdentifier;
        this.flowVersion = builder.flowVersion;
        this.executionRoleArn = builder.executionRoleArn;
        this.definition = builder.definition;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
    }

    public final String flowIdentifier() {
        return this.flowIdentifier;
    }

    public final String flowAliasIdentifier() {
        return this.flowAliasIdentifier;
    }

    public final String flowVersion() {
        return this.flowVersion;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String definition() {
        return this.definition;
    }

    public final String customerEncryptionKeyArn() {
        return this.customerEncryptionKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowAliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEncryptionKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExecutionFlowSnapshotResponse)) {
            return false;
        }
        GetExecutionFlowSnapshotResponse other = (GetExecutionFlowSnapshotResponse)((Object)obj);
        return Objects.equals(this.flowIdentifier(), other.flowIdentifier()) && Objects.equals(this.flowAliasIdentifier(), other.flowAliasIdentifier()) && Objects.equals(this.flowVersion(), other.flowVersion()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.customerEncryptionKeyArn(), other.customerEncryptionKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetExecutionFlowSnapshotResponse").add("FlowIdentifier", (Object)this.flowIdentifier()).add("FlowAliasIdentifier", (Object)this.flowAliasIdentifier()).add("FlowVersion", (Object)this.flowVersion()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("Definition", (Object)this.definition()).add("CustomerEncryptionKeyArn", (Object)this.customerEncryptionKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowIdentifier()));
            }
            case "flowAliasIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowAliasIdentifier()));
            }
            case "flowVersion": {
                return Optional.ofNullable(clazz.cast(this.flowVersion()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "customerEncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.customerEncryptionKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        map.put("flowAliasIdentifier", FLOW_ALIAS_IDENTIFIER_FIELD);
        map.put("flowVersion", FLOW_VERSION_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("definition", DEFINITION_FIELD);
        map.put("customerEncryptionKeyArn", CUSTOMER_ENCRYPTION_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetExecutionFlowSnapshotResponse, T> g) {
        return obj -> g.apply((GetExecutionFlowSnapshotResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeResponse.BuilderImpl
    implements Builder {
        private String flowIdentifier;
        private String flowAliasIdentifier;
        private String flowVersion;
        private String executionRoleArn;
        private String definition;
        private String customerEncryptionKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExecutionFlowSnapshotResponse model) {
            super(model);
            this.flowIdentifier(model.flowIdentifier);
            this.flowAliasIdentifier(model.flowAliasIdentifier);
            this.flowVersion(model.flowVersion);
            this.executionRoleArn(model.executionRoleArn);
            this.definition(model.definition);
            this.customerEncryptionKeyArn(model.customerEncryptionKeyArn);
        }

        public final String getFlowIdentifier() {
            return this.flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final String getFlowAliasIdentifier() {
            return this.flowAliasIdentifier;
        }

        public final void setFlowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
        }

        @Override
        public final Builder flowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
            return this;
        }

        public final String getFlowVersion() {
            return this.flowVersion;
        }

        public final void setFlowVersion(String flowVersion) {
            this.flowVersion = flowVersion;
        }

        @Override
        public final Builder flowVersion(String flowVersion) {
            this.flowVersion = flowVersion;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return this.customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        @Override
        public GetExecutionFlowSnapshotResponse build() {
            return new GetExecutionFlowSnapshotResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExecutionFlowSnapshotResponse> {
        public Builder flowIdentifier(String var1);

        public Builder flowAliasIdentifier(String var1);

        public Builder flowVersion(String var1);

        public Builder executionRoleArn(String var1);

        public Builder definition(String var1);

        public Builder customerEncryptionKeyArn(String var1);
    }
}

