/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemorySessionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemorySessionSummary> {
    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryId").getter(MemorySessionSummary.getter(MemorySessionSummary::memoryId)).setter(MemorySessionSummary.setter(Builder::memoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(MemorySessionSummary.getter(MemorySessionSummary::sessionId)).setter(MemorySessionSummary.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<Instant> SESSION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("sessionStartTime").getter(MemorySessionSummary.getter(MemorySessionSummary::sessionStartTime)).setter(MemorySessionSummary.setter(Builder::sessionStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> SESSION_EXPIRY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("sessionExpiryTime").getter(MemorySessionSummary.getter(MemorySessionSummary::sessionExpiryTime)).setter(MemorySessionSummary.setter(Builder::sessionExpiryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionExpiryTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SUMMARY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("summaryText").getter(MemorySessionSummary.getter(MemorySessionSummary::summaryText)).setter(MemorySessionSummary.setter(Builder::summaryText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaryText").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_ID_FIELD, SESSION_ID_FIELD, SESSION_START_TIME_FIELD, SESSION_EXPIRY_TIME_FIELD, SUMMARY_TEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MemorySessionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String memoryId;
    private final String sessionId;
    private final Instant sessionStartTime;
    private final Instant sessionExpiryTime;
    private final String summaryText;

    private MemorySessionSummary(BuilderImpl builder) {
        this.memoryId = builder.memoryId;
        this.sessionId = builder.sessionId;
        this.sessionStartTime = builder.sessionStartTime;
        this.sessionExpiryTime = builder.sessionExpiryTime;
        this.summaryText = builder.summaryText;
    }

    public final String memoryId() {
        return this.memoryId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Instant sessionStartTime() {
        return this.sessionStartTime;
    }

    public final Instant sessionExpiryTime() {
        return this.sessionExpiryTime;
    }

    public final String summaryText() {
        return this.summaryText;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionExpiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.summaryText());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemorySessionSummary)) {
            return false;
        }
        MemorySessionSummary other = (MemorySessionSummary)obj;
        return Objects.equals(this.memoryId(), other.memoryId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.sessionStartTime(), other.sessionStartTime()) && Objects.equals(this.sessionExpiryTime(), other.sessionExpiryTime()) && Objects.equals(this.summaryText(), other.summaryText());
    }

    public final String toString() {
        return ToString.builder((String)"MemorySessionSummary").add("MemoryId", (Object)this.memoryId()).add("SessionId", (Object)this.sessionId()).add("SessionStartTime", (Object)this.sessionStartTime()).add("SessionExpiryTime", (Object)this.sessionExpiryTime()).add("SummaryText", (Object)this.summaryText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memoryId": {
                return Optional.ofNullable(clazz.cast(this.memoryId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "sessionStartTime": {
                return Optional.ofNullable(clazz.cast(this.sessionStartTime()));
            }
            case "sessionExpiryTime": {
                return Optional.ofNullable(clazz.cast(this.sessionExpiryTime()));
            }
            case "summaryText": {
                return Optional.ofNullable(clazz.cast(this.summaryText()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memoryId", MEMORY_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("sessionStartTime", SESSION_START_TIME_FIELD);
        map.put("sessionExpiryTime", SESSION_EXPIRY_TIME_FIELD);
        map.put("summaryText", SUMMARY_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemorySessionSummary, T> g) {
        return obj -> g.apply((MemorySessionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String memoryId;
        private String sessionId;
        private Instant sessionStartTime;
        private Instant sessionExpiryTime;
        private String summaryText;

        private BuilderImpl() {
        }

        private BuilderImpl(MemorySessionSummary model) {
            this.memoryId(model.memoryId);
            this.sessionId(model.sessionId);
            this.sessionStartTime(model.sessionStartTime);
            this.sessionExpiryTime(model.sessionExpiryTime);
            this.summaryText(model.summaryText);
        }

        public final String getMemoryId() {
            return this.memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getSessionStartTime() {
            return this.sessionStartTime;
        }

        public final void setSessionStartTime(Instant sessionStartTime) {
            this.sessionStartTime = sessionStartTime;
        }

        @Override
        public final Builder sessionStartTime(Instant sessionStartTime) {
            this.sessionStartTime = sessionStartTime;
            return this;
        }

        public final Instant getSessionExpiryTime() {
            return this.sessionExpiryTime;
        }

        public final void setSessionExpiryTime(Instant sessionExpiryTime) {
            this.sessionExpiryTime = sessionExpiryTime;
        }

        @Override
        public final Builder sessionExpiryTime(Instant sessionExpiryTime) {
            this.sessionExpiryTime = sessionExpiryTime;
            return this;
        }

        public final String getSummaryText() {
            return this.summaryText;
        }

        public final void setSummaryText(String summaryText) {
            this.summaryText = summaryText;
        }

        @Override
        public final Builder summaryText(String summaryText) {
            this.summaryText = summaryText;
            return this;
        }

        public MemorySessionSummary build() {
            return new MemorySessionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemorySessionSummary> {
        public Builder memoryId(String var1);

        public Builder sessionId(String var1);

        public Builder sessionStartTime(Instant var1);

        public Builder sessionExpiryTime(Instant var1);

        public Builder summaryText(String var1);
    }
}

