/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockagentruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.Memory;

public class GetAgentMemoryPublisher
implements SdkPublisher<GetAgentMemoryResponse> {
    private final BedrockAgentRuntimeAsyncClient client;
    private final GetAgentMemoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAgentMemoryPublisher(BedrockAgentRuntimeAsyncClient client, GetAgentMemoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAgentMemoryPublisher(BedrockAgentRuntimeAsyncClient client, GetAgentMemoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAgentMemoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAgentMemoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Memory> memoryContents() {
        return this.flatMapIterable(response -> response.memoryContents());
    }

    private class GetAgentMemoryResponseFetcher
    implements AsyncPageFetcher<GetAgentMemoryResponse> {
        private GetAgentMemoryResponseFetcher() {
        }

        public boolean hasNextPage(GetAgentMemoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetAgentMemoryResponse> nextPage(GetAgentMemoryResponse previousPage) {
            if (previousPage == null) {
                return GetAgentMemoryPublisher.this.client.getAgentMemory(GetAgentMemoryPublisher.this.firstRequest);
            }
            return GetAgentMemoryPublisher.this.client.getAgentMemory((GetAgentMemoryRequest)((Object)GetAgentMemoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

