/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockagentruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankResult;

public class RerankPublisher
implements SdkPublisher<RerankResponse> {
    private final BedrockAgentRuntimeAsyncClient client;
    private final RerankRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public RerankPublisher(BedrockAgentRuntimeAsyncClient client, RerankRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private RerankPublisher(BedrockAgentRuntimeAsyncClient client, RerankRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new RerankResponseFetcher();
    }

    public void subscribe(Subscriber<? super RerankResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RerankResult> results() {
        return this.flatMapIterable(response -> response.results());
    }

    private class RerankResponseFetcher
    implements AsyncPageFetcher<RerankResponse> {
        private RerankResponseFetcher() {
        }

        public boolean hasNextPage(RerankResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<RerankResponse> nextPage(RerankResponse previousPage) {
            if (previousPage == null) {
                return RerankPublisher.this.client.rerank(RerankPublisher.this.firstRequest);
            }
            return RerankPublisher.this.client.rerank((RerankRequest)((Object)RerankPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

