/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.S3Object;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlueprintOptimizationSample
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlueprintOptimizationSample> {
    private static final SdkField<S3Object> ASSET_S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetS3Object").getter(BlueprintOptimizationSample.getter(BlueprintOptimizationSample::assetS3Object)).setter(BlueprintOptimizationSample.setter(Builder::assetS3Object)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetS3Object").build()}).build();
    private static final SdkField<S3Object> GROUND_TRUTH_S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("groundTruthS3Object").getter(BlueprintOptimizationSample.getter(BlueprintOptimizationSample::groundTruthS3Object)).setter(BlueprintOptimizationSample.setter(Builder::groundTruthS3Object)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundTruthS3Object").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_S3_OBJECT_FIELD, GROUND_TRUTH_S3_OBJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BlueprintOptimizationSample.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3Object assetS3Object;
    private final S3Object groundTruthS3Object;

    private BlueprintOptimizationSample(BuilderImpl builder) {
        this.assetS3Object = builder.assetS3Object;
        this.groundTruthS3Object = builder.groundTruthS3Object;
    }

    public final S3Object assetS3Object() {
        return this.assetS3Object;
    }

    public final S3Object groundTruthS3Object() {
        return this.groundTruthS3Object;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetS3Object());
        hashCode = 31 * hashCode + Objects.hashCode(this.groundTruthS3Object());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueprintOptimizationSample)) {
            return false;
        }
        BlueprintOptimizationSample other = (BlueprintOptimizationSample)obj;
        return Objects.equals(this.assetS3Object(), other.assetS3Object()) && Objects.equals(this.groundTruthS3Object(), other.groundTruthS3Object());
    }

    public final String toString() {
        return ToString.builder((String)"BlueprintOptimizationSample").add("AssetS3Object", (Object)this.assetS3Object()).add("GroundTruthS3Object", (Object)this.groundTruthS3Object()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetS3Object": {
                return Optional.ofNullable(clazz.cast(this.assetS3Object()));
            }
            case "groundTruthS3Object": {
                return Optional.ofNullable(clazz.cast(this.groundTruthS3Object()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<S3Object>> map = new HashMap<String, SdkField<S3Object>>();
        map.put("assetS3Object", ASSET_S3_OBJECT_FIELD);
        map.put("groundTruthS3Object", GROUND_TRUTH_S3_OBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlueprintOptimizationSample, T> g) {
        return obj -> g.apply((BlueprintOptimizationSample)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Object assetS3Object;
        private S3Object groundTruthS3Object;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueprintOptimizationSample model) {
            this.assetS3Object(model.assetS3Object);
            this.groundTruthS3Object(model.groundTruthS3Object);
        }

        public final S3Object.Builder getAssetS3Object() {
            return this.assetS3Object != null ? this.assetS3Object.toBuilder() : null;
        }

        public final void setAssetS3Object(S3Object.BuilderImpl assetS3Object) {
            this.assetS3Object = assetS3Object != null ? assetS3Object.build() : null;
        }

        @Override
        public final Builder assetS3Object(S3Object assetS3Object) {
            this.assetS3Object = assetS3Object;
            return this;
        }

        public final S3Object.Builder getGroundTruthS3Object() {
            return this.groundTruthS3Object != null ? this.groundTruthS3Object.toBuilder() : null;
        }

        public final void setGroundTruthS3Object(S3Object.BuilderImpl groundTruthS3Object) {
            this.groundTruthS3Object = groundTruthS3Object != null ? groundTruthS3Object.build() : null;
        }

        @Override
        public final Builder groundTruthS3Object(S3Object groundTruthS3Object) {
            this.groundTruthS3Object = groundTruthS3Object;
            return this;
        }

        public BlueprintOptimizationSample build() {
            return new BlueprintOptimizationSample(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlueprintOptimizationSample> {
        public Builder assetS3Object(S3Object var1);

        default public Builder assetS3Object(Consumer<S3Object.Builder> assetS3Object) {
            return this.assetS3Object((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(assetS3Object)).build());
        }

        public Builder groundTruthS3Object(S3Object var1);

        default public Builder groundTruthS3Object(Consumer<S3Object.Builder> groundTruthS3Object) {
            return this.groundTruthS3Object((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(groundTruthS3Object)).build());
        }
    }
}

