/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockdataautomation.model.PIIEntitiesConfiguration;
import software.amazon.awssdk.services.bedrockdataautomation.model.SensitiveDataDetectionMode;
import software.amazon.awssdk.services.bedrockdataautomation.model.SensitiveDataDetectionScopeCopier;
import software.amazon.awssdk.services.bedrockdataautomation.model.SensitiveDataDetectionScopeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SensitiveDataConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SensitiveDataConfiguration> {
    private static final SdkField<String> DETECTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectionMode").getter(SensitiveDataConfiguration.getter(SensitiveDataConfiguration::detectionModeAsString)).setter(SensitiveDataConfiguration.setter(Builder::detectionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectionMode").build()}).build();
    private static final SdkField<List<String>> DETECTION_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("detectionScope").getter(SensitiveDataConfiguration.getter(SensitiveDataConfiguration::detectionScopeAsStrings)).setter(SensitiveDataConfiguration.setter(Builder::detectionScopeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectionScope").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PIIEntitiesConfiguration> PII_ENTITIES_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("piiEntitiesConfiguration").getter(SensitiveDataConfiguration.getter(SensitiveDataConfiguration::piiEntitiesConfiguration)).setter(SensitiveDataConfiguration.setter(Builder::piiEntitiesConfiguration)).constructor(PIIEntitiesConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("piiEntitiesConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTION_MODE_FIELD, DETECTION_SCOPE_FIELD, PII_ENTITIES_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SensitiveDataConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String detectionMode;
    private final List<String> detectionScope;
    private final PIIEntitiesConfiguration piiEntitiesConfiguration;

    private SensitiveDataConfiguration(BuilderImpl builder) {
        this.detectionMode = builder.detectionMode;
        this.detectionScope = builder.detectionScope;
        this.piiEntitiesConfiguration = builder.piiEntitiesConfiguration;
    }

    public final SensitiveDataDetectionMode detectionMode() {
        return SensitiveDataDetectionMode.fromValue(this.detectionMode);
    }

    public final String detectionModeAsString() {
        return this.detectionMode;
    }

    public final List<SensitiveDataDetectionScopeType> detectionScope() {
        return SensitiveDataDetectionScopeCopier.copyStringToEnum(this.detectionScope);
    }

    public final boolean hasDetectionScope() {
        return this.detectionScope != null && !(this.detectionScope instanceof SdkAutoConstructList);
    }

    public final List<String> detectionScopeAsStrings() {
        return this.detectionScope;
    }

    public final PIIEntitiesConfiguration piiEntitiesConfiguration() {
        return this.piiEntitiesConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetectionScope() ? this.detectionScopeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.piiEntitiesConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SensitiveDataConfiguration)) {
            return false;
        }
        SensitiveDataConfiguration other = (SensitiveDataConfiguration)obj;
        return Objects.equals(this.detectionModeAsString(), other.detectionModeAsString()) && this.hasDetectionScope() == other.hasDetectionScope() && Objects.equals(this.detectionScopeAsStrings(), other.detectionScopeAsStrings()) && Objects.equals(this.piiEntitiesConfiguration(), other.piiEntitiesConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SensitiveDataConfiguration").add("DetectionMode", (Object)this.detectionModeAsString()).add("DetectionScope", this.hasDetectionScope() ? this.detectionScopeAsStrings() : null).add("PiiEntitiesConfiguration", (Object)this.piiEntitiesConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectionMode": {
                return Optional.ofNullable(clazz.cast(this.detectionModeAsString()));
            }
            case "detectionScope": {
                return Optional.ofNullable(clazz.cast(this.detectionScopeAsStrings()));
            }
            case "piiEntitiesConfiguration": {
                return Optional.ofNullable(clazz.cast(this.piiEntitiesConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("detectionMode", DETECTION_MODE_FIELD);
        map.put("detectionScope", DETECTION_SCOPE_FIELD);
        map.put("piiEntitiesConfiguration", PII_ENTITIES_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SensitiveDataConfiguration, T> g) {
        return obj -> g.apply((SensitiveDataConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String detectionMode;
        private List<String> detectionScope = DefaultSdkAutoConstructList.getInstance();
        private PIIEntitiesConfiguration piiEntitiesConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SensitiveDataConfiguration model) {
            this.detectionMode(model.detectionMode);
            this.detectionScopeWithStrings(model.detectionScope);
            this.piiEntitiesConfiguration(model.piiEntitiesConfiguration);
        }

        public final String getDetectionMode() {
            return this.detectionMode;
        }

        public final void setDetectionMode(String detectionMode) {
            this.detectionMode = detectionMode;
        }

        @Override
        public final Builder detectionMode(String detectionMode) {
            this.detectionMode = detectionMode;
            return this;
        }

        @Override
        public final Builder detectionMode(SensitiveDataDetectionMode detectionMode) {
            this.detectionMode(detectionMode == null ? null : detectionMode.toString());
            return this;
        }

        public final Collection<String> getDetectionScope() {
            if (this.detectionScope instanceof SdkAutoConstructList) {
                return null;
            }
            return this.detectionScope;
        }

        public final void setDetectionScope(Collection<String> detectionScope) {
            this.detectionScope = SensitiveDataDetectionScopeCopier.copy(detectionScope);
        }

        @Override
        public final Builder detectionScopeWithStrings(Collection<String> detectionScope) {
            this.detectionScope = SensitiveDataDetectionScopeCopier.copy(detectionScope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectionScopeWithStrings(String ... detectionScope) {
            this.detectionScopeWithStrings(Arrays.asList(detectionScope));
            return this;
        }

        @Override
        public final Builder detectionScope(Collection<SensitiveDataDetectionScopeType> detectionScope) {
            this.detectionScope = SensitiveDataDetectionScopeCopier.copyEnumToString(detectionScope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectionScope(SensitiveDataDetectionScopeType ... detectionScope) {
            this.detectionScope(Arrays.asList(detectionScope));
            return this;
        }

        public final PIIEntitiesConfiguration.Builder getPiiEntitiesConfiguration() {
            return this.piiEntitiesConfiguration != null ? this.piiEntitiesConfiguration.toBuilder() : null;
        }

        public final void setPiiEntitiesConfiguration(PIIEntitiesConfiguration.BuilderImpl piiEntitiesConfiguration) {
            this.piiEntitiesConfiguration = piiEntitiesConfiguration != null ? piiEntitiesConfiguration.build() : null;
        }

        @Override
        public final Builder piiEntitiesConfiguration(PIIEntitiesConfiguration piiEntitiesConfiguration) {
            this.piiEntitiesConfiguration = piiEntitiesConfiguration;
            return this;
        }

        public SensitiveDataConfiguration build() {
            return new SensitiveDataConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SensitiveDataConfiguration> {
        public Builder detectionMode(String var1);

        public Builder detectionMode(SensitiveDataDetectionMode var1);

        public Builder detectionScopeWithStrings(Collection<String> var1);

        public Builder detectionScopeWithStrings(String ... var1);

        public Builder detectionScope(Collection<SensitiveDataDetectionScopeType> var1);

        public Builder detectionScope(SensitiveDataDetectionScopeType ... var1);

        public Builder piiEntitiesConfiguration(PIIEntitiesConfiguration var1);

        default public Builder piiEntitiesConfiguration(Consumer<PIIEntitiesConfiguration.Builder> piiEntitiesConfiguration) {
            return this.piiEntitiesConfiguration((PIIEntitiesConfiguration)((PIIEntitiesConfiguration.Builder)PIIEntitiesConfiguration.builder().applyMutation(piiEntitiesConfiguration)).build());
        }
    }
}

