/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class GuardrailCustomWordListCopier {
    static List<GuardrailCustomWord> copy(Collection<? extends GuardrailCustomWord> guardrailCustomWordListParam) {
        List<GuardrailCustomWord> list;
        if (guardrailCustomWordListParam == null || guardrailCustomWordListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<GuardrailCustomWord> modifiableList = new ArrayList<>();
            guardrailCustomWordListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<GuardrailCustomWord> copyFromBuilder(
            Collection<? extends GuardrailCustomWord.Builder> guardrailCustomWordListParam) {
        List<GuardrailCustomWord> list;
        if (guardrailCustomWordListParam == null || guardrailCustomWordListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<GuardrailCustomWord> modifiableList = new ArrayList<>();
            guardrailCustomWordListParam.forEach(entry -> {
                GuardrailCustomWord member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<GuardrailCustomWord.Builder> copyToBuilder(Collection<? extends GuardrailCustomWord> guardrailCustomWordListParam) {
        List<GuardrailCustomWord.Builder> list;
        if (guardrailCustomWordListParam == null || guardrailCustomWordListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<GuardrailCustomWord.Builder> modifiableList = new ArrayList<>();
            guardrailCustomWordListParam.forEach(entry -> {
                GuardrailCustomWord.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
