/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockruntime.model.AsyncInvokeSummary;
import software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesResponse;

public class ListAsyncInvokesPublisher
implements SdkPublisher<ListAsyncInvokesResponse> {
    private final BedrockRuntimeAsyncClient client;
    private final ListAsyncInvokesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAsyncInvokesPublisher(BedrockRuntimeAsyncClient client, ListAsyncInvokesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAsyncInvokesPublisher(BedrockRuntimeAsyncClient client, ListAsyncInvokesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAsyncInvokesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAsyncInvokesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AsyncInvokeSummary> asyncInvokeSummaries() {
        return this.flatMapIterable(response -> response.asyncInvokeSummaries());
    }

    private class ListAsyncInvokesResponseFetcher
    implements AsyncPageFetcher<ListAsyncInvokesResponse> {
        private ListAsyncInvokesResponseFetcher() {
        }

        public boolean hasNextPage(ListAsyncInvokesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAsyncInvokesResponse> nextPage(ListAsyncInvokesResponse previousPage) {
            if (previousPage == null) {
                return ListAsyncInvokesPublisher.this.client.listAsyncInvokes(ListAsyncInvokesPublisher.this.firstRequest);
            }
            return ListAsyncInvokesPublisher.this.client.listAsyncInvokes((ListAsyncInvokesRequest)((Object)ListAsyncInvokesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

