/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.endpoints;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class BillingEndpointParams
implements ToCopyableBuilder<Builder, BillingEndpointParams> {
    private final Boolean useDualStack;
    private final Boolean useFIPS;
    private final String endpoint;
    private final Region region;

    private BillingEndpointParams(BuilderImpl builder) {
        this.useDualStack = builder.useDualStack;
        this.useFIPS = builder.useFIPS;
        this.endpoint = builder.endpoint;
        this.region = builder.region;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Boolean useDualStack() {
        return this.useDualStack;
    }

    public Boolean useFips() {
        return this.useFIPS;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public Region region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    private static class BuilderImpl
    implements Builder {
        private Boolean useDualStack = false;
        private Boolean useFIPS = false;
        private String endpoint;
        private Region region;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingEndpointParams builder) {
            this.useDualStack = builder.useDualStack;
            this.useFIPS = builder.useFIPS;
            this.endpoint = builder.endpoint;
            this.region = builder.region;
        }

        @Override
        public Builder useDualStack(Boolean useDualStack) {
            this.useDualStack = useDualStack;
            if (this.useDualStack == null) {
                this.useDualStack = false;
            }
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public BillingEndpointParams build() {
            return new BillingEndpointParams(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BillingEndpointParams> {
        public Builder useDualStack(Boolean var1);

        public Builder useFips(Boolean var1);

        public Builder endpoint(String var1);

        public Builder region(Region var1);

        public BillingEndpointParams build();
    }
}

