/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BillingViewStatusReason {
    SOURCE_VIEW_UNHEALTHY("SOURCE_VIEW_UNHEALTHY"),
    SOURCE_VIEW_UPDATING("SOURCE_VIEW_UPDATING"),
    SOURCE_VIEW_ACCESS_DENIED("SOURCE_VIEW_ACCESS_DENIED"),
    SOURCE_VIEW_NOT_FOUND("SOURCE_VIEW_NOT_FOUND"),
    CYCLIC_DEPENDENCY("CYCLIC_DEPENDENCY"),
    SOURCE_VIEW_DEPTH_EXCEEDED("SOURCE_VIEW_DEPTH_EXCEEDED"),
    AGGREGATE_SOURCE("AGGREGATE_SOURCE"),
    VIEW_OWNER_NOT_MANAGEMENT_ACCOUNT("VIEW_OWNER_NOT_MANAGEMENT_ACCOUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BillingViewStatusReason> VALUE_MAP;
    private final String value;

    private BillingViewStatusReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BillingViewStatusReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BillingViewStatusReason> knownValues() {
        EnumSet<BillingViewStatusReason> knownValues = EnumSet.allOf(BillingViewStatusReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BillingViewStatusReason.class, BillingViewStatusReason::toString);
    }
}

