/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BillingViewStatus {
    HEALTHY("HEALTHY"),
    UNHEALTHY("UNHEALTHY"),
    CREATING("CREATING"),
    UPDATING("UPDATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BillingViewStatus> VALUE_MAP;
    private final String value;

    private BillingViewStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BillingViewStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BillingViewStatus> knownValues() {
        EnumSet<BillingViewStatus> knownValues = EnumSet.allOf(BillingViewStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BillingViewStatus.class, BillingViewStatus::toString);
    }
}

