/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billing.model.BillingResponse;
import software.amazon.awssdk.services.billing.model.BillingViewSourceViewsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSourceViewsForBillingViewResponse
extends BillingResponse
implements ToCopyableBuilder<Builder, ListSourceViewsForBillingViewResponse> {
    private static final SdkField<List<String>> SOURCE_VIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceViews").getter(ListSourceViewsForBillingViewResponse.getter(ListSourceViewsForBillingViewResponse::sourceViews)).setter(ListSourceViewsForBillingViewResponse.setter(Builder::sourceViews)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceViews").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSourceViewsForBillingViewResponse.getter(ListSourceViewsForBillingViewResponse::nextToken)).setter(ListSourceViewsForBillingViewResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_VIEWS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSourceViewsForBillingViewResponse.memberNameToFieldInitializer();
    private final List<String> sourceViews;
    private final String nextToken;

    private ListSourceViewsForBillingViewResponse(BuilderImpl builder) {
        super(builder);
        this.sourceViews = builder.sourceViews;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSourceViews() {
        return this.sourceViews != null && !(this.sourceViews instanceof SdkAutoConstructList);
    }

    public final List<String> sourceViews() {
        return this.sourceViews;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceViews() ? this.sourceViews() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSourceViewsForBillingViewResponse)) {
            return false;
        }
        ListSourceViewsForBillingViewResponse other = (ListSourceViewsForBillingViewResponse)((Object)obj);
        return this.hasSourceViews() == other.hasSourceViews() && Objects.equals(this.sourceViews(), other.sourceViews()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSourceViewsForBillingViewResponse").add("SourceViews", this.hasSourceViews() ? this.sourceViews() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceViews": {
                return Optional.ofNullable(clazz.cast(this.sourceViews()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceViews", SOURCE_VIEWS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSourceViewsForBillingViewResponse, T> g) {
        return obj -> g.apply((ListSourceViewsForBillingViewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingResponse.BuilderImpl
    implements Builder {
        private List<String> sourceViews = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSourceViewsForBillingViewResponse model) {
            super(model);
            this.sourceViews(model.sourceViews);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getSourceViews() {
            if (this.sourceViews instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceViews;
        }

        public final void setSourceViews(Collection<String> sourceViews) {
            this.sourceViews = BillingViewSourceViewsListCopier.copy(sourceViews);
        }

        @Override
        public final Builder sourceViews(Collection<String> sourceViews) {
            this.sourceViews = BillingViewSourceViewsListCopier.copy(sourceViews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceViews(String ... sourceViews) {
            this.sourceViews(Arrays.asList(sourceViews));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSourceViewsForBillingViewResponse build() {
            return new ListSourceViewsForBillingViewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BillingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSourceViewsForBillingViewResponse> {
        public Builder sourceViews(Collection<String> var1);

        public Builder sourceViews(String ... var1);

        public Builder nextToken(String var1);
    }
}

