/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorResponse;
import software.amazon.awssdk.services.billingconductor.model.PricingPlanListCopier;
import software.amazon.awssdk.services.billingconductor.model.PricingPlanListElement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPricingPlansResponse
extends BillingconductorResponse
implements ToCopyableBuilder<Builder, ListPricingPlansResponse> {
    private static final SdkField<String> BILLING_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingPeriod").getter(ListPricingPlansResponse.getter(ListPricingPlansResponse::billingPeriod)).setter(ListPricingPlansResponse.setter(Builder::billingPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriod").build()}).build();
    private static final SdkField<List<PricingPlanListElement>> PRICING_PLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PricingPlans").getter(ListPricingPlansResponse.getter(ListPricingPlansResponse::pricingPlans)).setter(ListPricingPlansResponse.setter(Builder::pricingPlans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PricingPlanListElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPricingPlansResponse.getter(ListPricingPlansResponse::nextToken)).setter(ListPricingPlansResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_PERIOD_FIELD, PRICING_PLANS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPricingPlansResponse.memberNameToFieldInitializer();
    private final String billingPeriod;
    private final List<PricingPlanListElement> pricingPlans;
    private final String nextToken;

    private ListPricingPlansResponse(BuilderImpl builder) {
        super(builder);
        this.billingPeriod = builder.billingPeriod;
        this.pricingPlans = builder.pricingPlans;
        this.nextToken = builder.nextToken;
    }

    public final String billingPeriod() {
        return this.billingPeriod;
    }

    public final boolean hasPricingPlans() {
        return this.pricingPlans != null && !(this.pricingPlans instanceof SdkAutoConstructList);
    }

    public final List<PricingPlanListElement> pricingPlans() {
        return this.pricingPlans;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPricingPlans() ? this.pricingPlans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPricingPlansResponse)) {
            return false;
        }
        ListPricingPlansResponse other = (ListPricingPlansResponse)((Object)obj);
        return Objects.equals(this.billingPeriod(), other.billingPeriod()) && this.hasPricingPlans() == other.hasPricingPlans() && Objects.equals(this.pricingPlans(), other.pricingPlans()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPricingPlansResponse").add("BillingPeriod", (Object)this.billingPeriod()).add("PricingPlans", this.hasPricingPlans() ? this.pricingPlans() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BillingPeriod": {
                return Optional.ofNullable(clazz.cast(this.billingPeriod()));
            }
            case "PricingPlans": {
                return Optional.ofNullable(clazz.cast(this.pricingPlans()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BillingPeriod", BILLING_PERIOD_FIELD);
        map.put("PricingPlans", PRICING_PLANS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPricingPlansResponse, T> g) {
        return obj -> g.apply((ListPricingPlansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorResponse.BuilderImpl
    implements Builder {
        private String billingPeriod;
        private List<PricingPlanListElement> pricingPlans = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPricingPlansResponse model) {
            super(model);
            this.billingPeriod(model.billingPeriod);
            this.pricingPlans(model.pricingPlans);
            this.nextToken(model.nextToken);
        }

        public final String getBillingPeriod() {
            return this.billingPeriod;
        }

        public final void setBillingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
        }

        @Override
        public final Builder billingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final List<PricingPlanListElement.Builder> getPricingPlans() {
            List<PricingPlanListElement.Builder> result = PricingPlanListCopier.copyToBuilder(this.pricingPlans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPricingPlans(Collection<PricingPlanListElement.BuilderImpl> pricingPlans) {
            this.pricingPlans = PricingPlanListCopier.copyFromBuilder(pricingPlans);
        }

        @Override
        public final Builder pricingPlans(Collection<PricingPlanListElement> pricingPlans) {
            this.pricingPlans = PricingPlanListCopier.copy(pricingPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingPlans(PricingPlanListElement ... pricingPlans) {
            this.pricingPlans(Arrays.asList(pricingPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingPlans(Consumer<PricingPlanListElement.Builder> ... pricingPlans) {
            this.pricingPlans(Stream.of(pricingPlans).map(c -> (PricingPlanListElement)((PricingPlanListElement.Builder)PricingPlanListElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPricingPlansResponse build() {
            return new ListPricingPlansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BillingconductorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPricingPlansResponse> {
        public Builder billingPeriod(String var1);

        public Builder pricingPlans(Collection<PricingPlanListElement> var1);

        public Builder pricingPlans(PricingPlanListElement ... var1);

        public Builder pricingPlans(Consumer<PricingPlanListElement.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

