/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.braket.model.BraketException;
import software.amazon.awssdk.services.braket.model.ProgramSetValidationFailure;
import software.amazon.awssdk.services.braket.model.ProgramSetValidationFailuresListCopier;
import software.amazon.awssdk.services.braket.model.ValidationExceptionReason;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidationException
extends BraketException
implements ToCopyableBuilder<Builder, ValidationException> {
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(ValidationException.getter(ValidationException::reasonAsString)).setter(ValidationException.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<List<ProgramSetValidationFailure>> PROGRAM_SET_VALIDATION_FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("programSetValidationFailures").getter(ValidationException.getter(ValidationException::programSetValidationFailures)).setter(ValidationException.setter(Builder::programSetValidationFailures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programSetValidationFailures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProgramSetValidationFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD, PROGRAM_SET_VALIDATION_FAILURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValidationException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String reason;
    private final List<ProgramSetValidationFailure> programSetValidationFailures;

    private ValidationException(BuilderImpl builder) {
        super(builder);
        this.reason = builder.reason;
        this.programSetValidationFailures = builder.programSetValidationFailures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public ValidationExceptionReason reason() {
        return ValidationExceptionReason.fromValue(this.reason);
    }

    public String reasonAsString() {
        return this.reason;
    }

    public boolean hasProgramSetValidationFailures() {
        return this.programSetValidationFailures != null && !(this.programSetValidationFailures instanceof SdkAutoConstructList);
    }

    public List<ProgramSetValidationFailure> programSetValidationFailures() {
        return this.programSetValidationFailures;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reason", REASON_FIELD);
        map.put("programSetValidationFailures", PROGRAM_SET_VALIDATION_FAILURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationException, T> g) {
        return obj -> g.apply((ValidationException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketException.BuilderImpl
    implements Builder {
        private String reason;
        private List<ProgramSetValidationFailure> programSetValidationFailures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationException model) {
            super(model);
            this.reason(model.reason);
            this.programSetValidationFailures(model.programSetValidationFailures);
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ValidationExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final List<ProgramSetValidationFailure.Builder> getProgramSetValidationFailures() {
            List<ProgramSetValidationFailure.Builder> result = ProgramSetValidationFailuresListCopier.copyToBuilder(this.programSetValidationFailures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProgramSetValidationFailures(Collection<ProgramSetValidationFailure.BuilderImpl> programSetValidationFailures) {
            this.programSetValidationFailures = ProgramSetValidationFailuresListCopier.copyFromBuilder(programSetValidationFailures);
        }

        @Override
        public final Builder programSetValidationFailures(Collection<ProgramSetValidationFailure> programSetValidationFailures) {
            this.programSetValidationFailures = ProgramSetValidationFailuresListCopier.copy(programSetValidationFailures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programSetValidationFailures(ProgramSetValidationFailure ... programSetValidationFailures) {
            this.programSetValidationFailures(Arrays.asList(programSetValidationFailures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programSetValidationFailures(Consumer<ProgramSetValidationFailure.Builder> ... programSetValidationFailures) {
            this.programSetValidationFailures(Stream.of(programSetValidationFailures).map(c -> (ProgramSetValidationFailure)((ProgramSetValidationFailure.Builder)ProgramSetValidationFailure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public ValidationException build() {
            return new ValidationException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidationException>,
    BraketException.Builder {
        public Builder reason(String var1);

        public Builder reason(ValidationExceptionReason var1);

        public Builder programSetValidationFailures(Collection<ProgramSetValidationFailure> var1);

        public Builder programSetValidationFailures(ProgramSetValidationFailure ... var1);

        public Builder programSetValidationFailures(Consumer<ProgramSetValidationFailure.Builder> ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);

        @Override
        public Builder numAttempts(Integer var1);
    }
}

