/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.braket.BraketAsyncClient;
import software.amazon.awssdk.services.braket.internal.UserAgentUtils;
import software.amazon.awssdk.services.braket.model.SearchSpendingLimitsRequest;
import software.amazon.awssdk.services.braket.model.SearchSpendingLimitsResponse;
import software.amazon.awssdk.services.braket.model.SpendingLimitSummary;

public class SearchSpendingLimitsPublisher
implements SdkPublisher<SearchSpendingLimitsResponse> {
    private final BraketAsyncClient client;
    private final SearchSpendingLimitsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchSpendingLimitsPublisher(BraketAsyncClient client, SearchSpendingLimitsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchSpendingLimitsPublisher(BraketAsyncClient client, SearchSpendingLimitsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchSpendingLimitsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchSpendingLimitsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SpendingLimitSummary> spendingLimits() {
        Function<SearchSpendingLimitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.spendingLimits() != null) {
                return response.spendingLimits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchSpendingLimitsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchSpendingLimitsResponseFetcher
    implements AsyncPageFetcher<SearchSpendingLimitsResponse> {
        private SearchSpendingLimitsResponseFetcher() {
        }

        public boolean hasNextPage(SearchSpendingLimitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchSpendingLimitsResponse> nextPage(SearchSpendingLimitsResponse previousPage) {
            if (previousPage == null) {
                return SearchSpendingLimitsPublisher.this.client.searchSpendingLimits(SearchSpendingLimitsPublisher.this.firstRequest);
            }
            return SearchSpendingLimitsPublisher.this.client.searchSpendingLimits((SearchSpendingLimitsRequest)((Object)SearchSpendingLimitsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

