/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.ChimeServiceClientConfiguration;
import software.amazon.awssdk.services.chime.internal.ChimeServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.chime.model.AccessDeniedException;
import software.amazon.awssdk.services.chime.model.AssociatePhoneNumberWithUserRequest;
import software.amazon.awssdk.services.chime.model.AssociatePhoneNumberWithUserResponse;
import software.amazon.awssdk.services.chime.model.AssociateSigninDelegateGroupsWithAccountRequest;
import software.amazon.awssdk.services.chime.model.AssociateSigninDelegateGroupsWithAccountResponse;
import software.amazon.awssdk.services.chime.model.BadRequestException;
import software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipRequest;
import software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipResponse;
import software.amazon.awssdk.services.chime.model.BatchDeletePhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.BatchDeletePhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.BatchSuspendUserRequest;
import software.amazon.awssdk.services.chime.model.BatchSuspendUserResponse;
import software.amazon.awssdk.services.chime.model.BatchUnsuspendUserRequest;
import software.amazon.awssdk.services.chime.model.BatchUnsuspendUserResponse;
import software.amazon.awssdk.services.chime.model.BatchUpdatePhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.BatchUpdatePhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.BatchUpdateUserRequest;
import software.amazon.awssdk.services.chime.model.BatchUpdateUserResponse;
import software.amazon.awssdk.services.chime.model.ChimeException;
import software.amazon.awssdk.services.chime.model.ConflictException;
import software.amazon.awssdk.services.chime.model.CreateAccountRequest;
import software.amazon.awssdk.services.chime.model.CreateAccountResponse;
import software.amazon.awssdk.services.chime.model.CreateBotRequest;
import software.amazon.awssdk.services.chime.model.CreateBotResponse;
import software.amazon.awssdk.services.chime.model.CreateMeetingDialOutRequest;
import software.amazon.awssdk.services.chime.model.CreateMeetingDialOutResponse;
import software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderRequest;
import software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderResponse;
import software.amazon.awssdk.services.chime.model.CreateRoomMembershipRequest;
import software.amazon.awssdk.services.chime.model.CreateRoomMembershipResponse;
import software.amazon.awssdk.services.chime.model.CreateRoomRequest;
import software.amazon.awssdk.services.chime.model.CreateRoomResponse;
import software.amazon.awssdk.services.chime.model.CreateUserRequest;
import software.amazon.awssdk.services.chime.model.CreateUserResponse;
import software.amazon.awssdk.services.chime.model.DeleteAccountRequest;
import software.amazon.awssdk.services.chime.model.DeleteAccountResponse;
import software.amazon.awssdk.services.chime.model.DeleteEventsConfigurationRequest;
import software.amazon.awssdk.services.chime.model.DeleteEventsConfigurationResponse;
import software.amazon.awssdk.services.chime.model.DeletePhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.DeletePhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.DeleteRoomMembershipRequest;
import software.amazon.awssdk.services.chime.model.DeleteRoomMembershipResponse;
import software.amazon.awssdk.services.chime.model.DeleteRoomRequest;
import software.amazon.awssdk.services.chime.model.DeleteRoomResponse;
import software.amazon.awssdk.services.chime.model.DisassociatePhoneNumberFromUserRequest;
import software.amazon.awssdk.services.chime.model.DisassociatePhoneNumberFromUserResponse;
import software.amazon.awssdk.services.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest;
import software.amazon.awssdk.services.chime.model.DisassociateSigninDelegateGroupsFromAccountResponse;
import software.amazon.awssdk.services.chime.model.ForbiddenException;
import software.amazon.awssdk.services.chime.model.GetAccountRequest;
import software.amazon.awssdk.services.chime.model.GetAccountResponse;
import software.amazon.awssdk.services.chime.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.chime.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.chime.model.GetBotRequest;
import software.amazon.awssdk.services.chime.model.GetBotResponse;
import software.amazon.awssdk.services.chime.model.GetEventsConfigurationRequest;
import software.amazon.awssdk.services.chime.model.GetEventsConfigurationResponse;
import software.amazon.awssdk.services.chime.model.GetGlobalSettingsRequest;
import software.amazon.awssdk.services.chime.model.GetGlobalSettingsResponse;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderRequest;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderResponse;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberSettingsRequest;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberSettingsResponse;
import software.amazon.awssdk.services.chime.model.GetRetentionSettingsRequest;
import software.amazon.awssdk.services.chime.model.GetRetentionSettingsResponse;
import software.amazon.awssdk.services.chime.model.GetRoomRequest;
import software.amazon.awssdk.services.chime.model.GetRoomResponse;
import software.amazon.awssdk.services.chime.model.GetUserRequest;
import software.amazon.awssdk.services.chime.model.GetUserResponse;
import software.amazon.awssdk.services.chime.model.GetUserSettingsRequest;
import software.amazon.awssdk.services.chime.model.GetUserSettingsResponse;
import software.amazon.awssdk.services.chime.model.InviteUsersRequest;
import software.amazon.awssdk.services.chime.model.InviteUsersResponse;
import software.amazon.awssdk.services.chime.model.ListAccountsRequest;
import software.amazon.awssdk.services.chime.model.ListAccountsResponse;
import software.amazon.awssdk.services.chime.model.ListBotsRequest;
import software.amazon.awssdk.services.chime.model.ListBotsResponse;
import software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersRequest;
import software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersResponse;
import software.amazon.awssdk.services.chime.model.ListPhoneNumbersRequest;
import software.amazon.awssdk.services.chime.model.ListPhoneNumbersResponse;
import software.amazon.awssdk.services.chime.model.ListRoomMembershipsRequest;
import software.amazon.awssdk.services.chime.model.ListRoomMembershipsResponse;
import software.amazon.awssdk.services.chime.model.ListRoomsRequest;
import software.amazon.awssdk.services.chime.model.ListRoomsResponse;
import software.amazon.awssdk.services.chime.model.ListSupportedPhoneNumberCountriesRequest;
import software.amazon.awssdk.services.chime.model.ListSupportedPhoneNumberCountriesResponse;
import software.amazon.awssdk.services.chime.model.ListUsersRequest;
import software.amazon.awssdk.services.chime.model.ListUsersResponse;
import software.amazon.awssdk.services.chime.model.LogoutUserRequest;
import software.amazon.awssdk.services.chime.model.LogoutUserResponse;
import software.amazon.awssdk.services.chime.model.NotFoundException;
import software.amazon.awssdk.services.chime.model.PutEventsConfigurationRequest;
import software.amazon.awssdk.services.chime.model.PutEventsConfigurationResponse;
import software.amazon.awssdk.services.chime.model.PutRetentionSettingsRequest;
import software.amazon.awssdk.services.chime.model.PutRetentionSettingsResponse;
import software.amazon.awssdk.services.chime.model.RedactConversationMessageRequest;
import software.amazon.awssdk.services.chime.model.RedactConversationMessageResponse;
import software.amazon.awssdk.services.chime.model.RedactRoomMessageRequest;
import software.amazon.awssdk.services.chime.model.RedactRoomMessageResponse;
import software.amazon.awssdk.services.chime.model.RegenerateSecurityTokenRequest;
import software.amazon.awssdk.services.chime.model.RegenerateSecurityTokenResponse;
import software.amazon.awssdk.services.chime.model.ResetPersonalPinRequest;
import software.amazon.awssdk.services.chime.model.ResetPersonalPinResponse;
import software.amazon.awssdk.services.chime.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.chime.model.RestorePhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.RestorePhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersRequest;
import software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersResponse;
import software.amazon.awssdk.services.chime.model.ServiceFailureException;
import software.amazon.awssdk.services.chime.model.ServiceUnavailableException;
import software.amazon.awssdk.services.chime.model.ThrottledClientException;
import software.amazon.awssdk.services.chime.model.UnauthorizedClientException;
import software.amazon.awssdk.services.chime.model.UnprocessableEntityException;
import software.amazon.awssdk.services.chime.model.UpdateAccountRequest;
import software.amazon.awssdk.services.chime.model.UpdateAccountResponse;
import software.amazon.awssdk.services.chime.model.UpdateAccountSettingsRequest;
import software.amazon.awssdk.services.chime.model.UpdateAccountSettingsResponse;
import software.amazon.awssdk.services.chime.model.UpdateBotRequest;
import software.amazon.awssdk.services.chime.model.UpdateBotResponse;
import software.amazon.awssdk.services.chime.model.UpdateGlobalSettingsRequest;
import software.amazon.awssdk.services.chime.model.UpdateGlobalSettingsResponse;
import software.amazon.awssdk.services.chime.model.UpdatePhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.UpdatePhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.UpdatePhoneNumberSettingsRequest;
import software.amazon.awssdk.services.chime.model.UpdatePhoneNumberSettingsResponse;
import software.amazon.awssdk.services.chime.model.UpdateRoomMembershipRequest;
import software.amazon.awssdk.services.chime.model.UpdateRoomMembershipResponse;
import software.amazon.awssdk.services.chime.model.UpdateRoomRequest;
import software.amazon.awssdk.services.chime.model.UpdateRoomResponse;
import software.amazon.awssdk.services.chime.model.UpdateUserRequest;
import software.amazon.awssdk.services.chime.model.UpdateUserResponse;
import software.amazon.awssdk.services.chime.model.UpdateUserSettingsRequest;
import software.amazon.awssdk.services.chime.model.UpdateUserSettingsResponse;
import software.amazon.awssdk.services.chime.transform.AssociatePhoneNumberWithUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.AssociateSigninDelegateGroupsWithAccountRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.BatchCreateRoomMembershipRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.BatchDeletePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.BatchSuspendUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.BatchUnsuspendUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.BatchUpdatePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.BatchUpdateUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateAccountRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateBotRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateMeetingDialOutRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreatePhoneNumberOrderRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateRoomMembershipRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateRoomRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteAccountRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteEventsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeletePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteRoomMembershipRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteRoomRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DisassociatePhoneNumberFromUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DisassociateSigninDelegateGroupsFromAccountRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetAccountRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetBotRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetEventsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetGlobalSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetPhoneNumberOrderRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetPhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetPhoneNumberSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetRetentionSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetRoomRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.InviteUsersRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListAccountsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListBotsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListPhoneNumberOrdersRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListPhoneNumbersRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListRoomMembershipsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListRoomsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListSupportedPhoneNumberCountriesRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.LogoutUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.PutEventsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.PutRetentionSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.RedactConversationMessageRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.RedactRoomMessageRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.RegenerateSecurityTokenRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ResetPersonalPinRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.RestorePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.SearchAvailablePhoneNumbersRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateAccountRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateBotRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateGlobalSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdatePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdatePhoneNumberSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateRoomMembershipRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateRoomRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateUserSettingsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultChimeClient
implements ChimeClient {
    private static final Logger log = Logger.loggerFor(DefaultChimeClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultChimeClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Chime#2.35.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociatePhoneNumberWithUserResponse associatePhoneNumberWithUser(AssociatePhoneNumberWithUserRequest associatePhoneNumberWithUserRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, AccessDeniedException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociatePhoneNumberWithUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associatePhoneNumberWithUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, associatePhoneNumberWithUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociatePhoneNumberWithUser");
            AssociatePhoneNumberWithUserResponse associatePhoneNumberWithUserResponse = (AssociatePhoneNumberWithUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociatePhoneNumberWithUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associatePhoneNumberWithUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociatePhoneNumberWithUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associatePhoneNumberWithUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$associatePhoneNumberWithUser$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateSigninDelegateGroupsWithAccountResponse associateSigninDelegateGroupsWithAccount(AssociateSigninDelegateGroupsWithAccountRequest associateSigninDelegateGroupsWithAccountRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateSigninDelegateGroupsWithAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateSigninDelegateGroupsWithAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, associateSigninDelegateGroupsWithAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateSigninDelegateGroupsWithAccount");
            AssociateSigninDelegateGroupsWithAccountResponse associateSigninDelegateGroupsWithAccountResponse = (AssociateSigninDelegateGroupsWithAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateSigninDelegateGroupsWithAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateSigninDelegateGroupsWithAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateSigninDelegateGroupsWithAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateSigninDelegateGroupsWithAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$associateSigninDelegateGroupsWithAccount$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchCreateRoomMembershipResponse batchCreateRoomMembership(BatchCreateRoomMembershipRequest batchCreateRoomMembershipRequest) throws UnauthorizedClientException, NotFoundException, BadRequestException, ForbiddenException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchCreateRoomMembershipResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchCreateRoomMembershipRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, batchCreateRoomMembershipRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchCreateRoomMembership");
            BatchCreateRoomMembershipResponse batchCreateRoomMembershipResponse = (BatchCreateRoomMembershipResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchCreateRoomMembership").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchCreateRoomMembershipRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchCreateRoomMembershipRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchCreateRoomMembershipResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$batchCreateRoomMembership$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeletePhoneNumberResponse batchDeletePhoneNumber(BatchDeletePhoneNumberRequest batchDeletePhoneNumberRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeletePhoneNumberResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDeletePhoneNumberRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, batchDeletePhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeletePhoneNumber");
            BatchDeletePhoneNumberResponse batchDeletePhoneNumberResponse = (BatchDeletePhoneNumberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeletePhoneNumber").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDeletePhoneNumberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeletePhoneNumberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeletePhoneNumberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$batchDeletePhoneNumber$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchSuspendUserResponse batchSuspendUser(BatchSuspendUserRequest batchSuspendUserRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchSuspendUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchSuspendUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, batchSuspendUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchSuspendUser");
            BatchSuspendUserResponse batchSuspendUserResponse = (BatchSuspendUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchSuspendUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchSuspendUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchSuspendUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchSuspendUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$batchSuspendUser$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchUnsuspendUserResponse batchUnsuspendUser(BatchUnsuspendUserRequest batchUnsuspendUserRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUnsuspendUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchUnsuspendUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, batchUnsuspendUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUnsuspendUser");
            BatchUnsuspendUserResponse batchUnsuspendUserResponse = (BatchUnsuspendUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUnsuspendUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchUnsuspendUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchUnsuspendUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchUnsuspendUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$batchUnsuspendUser$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchUpdatePhoneNumberResponse batchUpdatePhoneNumber(BatchUpdatePhoneNumberRequest batchUpdatePhoneNumberRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUpdatePhoneNumberResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchUpdatePhoneNumberRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, batchUpdatePhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUpdatePhoneNumber");
            BatchUpdatePhoneNumberResponse batchUpdatePhoneNumberResponse = (BatchUpdatePhoneNumberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUpdatePhoneNumber").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchUpdatePhoneNumberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchUpdatePhoneNumberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchUpdatePhoneNumberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$batchUpdatePhoneNumber$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchUpdateUserResponse batchUpdateUser(BatchUpdateUserRequest batchUpdateUserRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUpdateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchUpdateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, batchUpdateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUpdateUser");
            BatchUpdateUserResponse batchUpdateUserResponse = (BatchUpdateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUpdateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchUpdateUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchUpdateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchUpdateUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$batchUpdateUser$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAccountResponse createAccount(CreateAccountRequest createAccountRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, createAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccount");
            CreateAccountResponse createAccountResponse = (CreateAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$createAccount$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBotResponse createBot(CreateBotRequest createBotRequest) throws ServiceUnavailableException, ServiceFailureException, ForbiddenException, BadRequestException, UnauthorizedClientException, ResourceLimitExceededException, NotFoundException, ThrottledClientException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, createBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBot");
            CreateBotResponse createBotResponse = (CreateBotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$createBot$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMeetingDialOutResponse createMeetingDialOut(CreateMeetingDialOutRequest createMeetingDialOutRequest) throws BadRequestException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException, UnauthorizedClientException, AccessDeniedException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMeetingDialOutResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMeetingDialOutRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, createMeetingDialOutRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMeetingDialOut");
            CreateMeetingDialOutResponse createMeetingDialOutResponse = (CreateMeetingDialOutResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMeetingDialOut").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createMeetingDialOutRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMeetingDialOutRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMeetingDialOutResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$createMeetingDialOut$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePhoneNumberOrderResponse createPhoneNumberOrder(CreatePhoneNumberOrderRequest createPhoneNumberOrderRequest) throws BadRequestException, ForbiddenException, AccessDeniedException, UnauthorizedClientException, ThrottledClientException, ResourceLimitExceededException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePhoneNumberOrderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPhoneNumberOrderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, createPhoneNumberOrderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePhoneNumberOrder");
            CreatePhoneNumberOrderResponse createPhoneNumberOrderResponse = (CreatePhoneNumberOrderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePhoneNumberOrder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPhoneNumberOrderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePhoneNumberOrderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPhoneNumberOrderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$createPhoneNumberOrder$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRoomResponse createRoom(CreateRoomRequest createRoomRequest) throws NotFoundException, BadRequestException, ForbiddenException, UnauthorizedClientException, ResourceLimitExceededException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRoomResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRoomRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, createRoomRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRoom");
            CreateRoomResponse createRoomResponse = (CreateRoomResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRoom").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createRoomRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRoomRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRoomResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$createRoom$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRoomMembershipResponse createRoomMembership(CreateRoomMembershipRequest createRoomMembershipRequest) throws ConflictException, UnauthorizedClientException, NotFoundException, BadRequestException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRoomMembershipResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRoomMembershipRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, createRoomMembershipRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRoomMembership");
            CreateRoomMembershipResponse createRoomMembershipResponse = (CreateRoomMembershipResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRoomMembership").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createRoomMembershipRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRoomMembershipRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRoomMembershipResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$createRoomMembership$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws UnauthorizedClientException, NotFoundException, ConflictException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, createUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUser");
            CreateUserResponse createUserResponse = (CreateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$createUser$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccountResponse deleteAccount(DeleteAccountRequest deleteAccountRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, UnprocessableEntityException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, deleteAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccount");
            DeleteAccountResponse deleteAccountResponse = (DeleteAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$deleteAccount$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEventsConfigurationResponse deleteEventsConfiguration(DeleteEventsConfigurationRequest deleteEventsConfigurationRequest) throws ServiceUnavailableException, ServiceFailureException, ForbiddenException, BadRequestException, UnauthorizedClientException, ResourceLimitExceededException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventsConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEventsConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, deleteEventsConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventsConfiguration");
            DeleteEventsConfigurationResponse deleteEventsConfigurationResponse = (DeleteEventsConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventsConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteEventsConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEventsConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEventsConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$deleteEventsConfiguration$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePhoneNumberResponse deletePhoneNumber(DeletePhoneNumberRequest deletePhoneNumberRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePhoneNumberResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePhoneNumberRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, deletePhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePhoneNumber");
            DeletePhoneNumberResponse deletePhoneNumberResponse = (DeletePhoneNumberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePhoneNumber").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePhoneNumberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePhoneNumberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePhoneNumberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$deletePhoneNumber$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRoomResponse deleteRoom(DeleteRoomRequest deleteRoomRequest) throws BadRequestException, ForbiddenException, NotFoundException, UnauthorizedClientException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRoomResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRoomRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, deleteRoomRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRoom");
            DeleteRoomResponse deleteRoomResponse = (DeleteRoomResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRoom").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteRoomRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRoomRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRoomResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$deleteRoom$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRoomMembershipResponse deleteRoomMembership(DeleteRoomMembershipRequest deleteRoomMembershipRequest) throws UnauthorizedClientException, NotFoundException, BadRequestException, ForbiddenException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRoomMembershipResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRoomMembershipRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, deleteRoomMembershipRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRoomMembership");
            DeleteRoomMembershipResponse deleteRoomMembershipResponse = (DeleteRoomMembershipResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRoomMembership").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteRoomMembershipRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRoomMembershipRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRoomMembershipResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$deleteRoomMembership$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociatePhoneNumberFromUserResponse disassociatePhoneNumberFromUser(DisassociatePhoneNumberFromUserRequest disassociatePhoneNumberFromUserRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociatePhoneNumberFromUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociatePhoneNumberFromUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, disassociatePhoneNumberFromUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociatePhoneNumberFromUser");
            DisassociatePhoneNumberFromUserResponse disassociatePhoneNumberFromUserResponse = (DisassociatePhoneNumberFromUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociatePhoneNumberFromUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociatePhoneNumberFromUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociatePhoneNumberFromUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociatePhoneNumberFromUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$disassociatePhoneNumberFromUser$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateSigninDelegateGroupsFromAccountResponse disassociateSigninDelegateGroupsFromAccount(DisassociateSigninDelegateGroupsFromAccountRequest disassociateSigninDelegateGroupsFromAccountRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateSigninDelegateGroupsFromAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateSigninDelegateGroupsFromAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, disassociateSigninDelegateGroupsFromAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateSigninDelegateGroupsFromAccount");
            DisassociateSigninDelegateGroupsFromAccountResponse disassociateSigninDelegateGroupsFromAccountResponse = (DisassociateSigninDelegateGroupsFromAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateSigninDelegateGroupsFromAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateSigninDelegateGroupsFromAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateSigninDelegateGroupsFromAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateSigninDelegateGroupsFromAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$disassociateSigninDelegateGroupsFromAccount$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccountResponse getAccount(GetAccountRequest getAccountRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, getAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccount");
            GetAccountResponse getAccountResponse = (GetAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$getAccount$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccountSettingsResponse getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest) throws UnauthorizedClientException, NotFoundException, BadRequestException, ForbiddenException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccountSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAccountSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, getAccountSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccountSettings");
            GetAccountSettingsResponse getAccountSettingsResponse = (GetAccountSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccountSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAccountSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAccountSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAccountSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$getAccountSettings$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBotResponse getBot(GetBotRequest getBotRequest) throws ServiceUnavailableException, ServiceFailureException, ForbiddenException, UnauthorizedClientException, NotFoundException, BadRequestException, ThrottledClientException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, getBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBot");
            GetBotResponse getBotResponse = (GetBotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$getBot$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEventsConfigurationResponse getEventsConfiguration(GetEventsConfigurationRequest getEventsConfigurationRequest) throws ServiceUnavailableException, ServiceFailureException, ForbiddenException, BadRequestException, UnauthorizedClientException, ResourceLimitExceededException, NotFoundException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEventsConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEventsConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, getEventsConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEventsConfiguration");
            GetEventsConfigurationResponse getEventsConfigurationResponse = (GetEventsConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEventsConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getEventsConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEventsConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEventsConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$getEventsConfiguration$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGlobalSettingsResponse getGlobalSettings(GetGlobalSettingsRequest getGlobalSettingsRequest) throws UnauthorizedClientException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGlobalSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getGlobalSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, getGlobalSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGlobalSettings");
            GetGlobalSettingsResponse getGlobalSettingsResponse = (GetGlobalSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGlobalSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getGlobalSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGlobalSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGlobalSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$getGlobalSettings$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPhoneNumberResponse getPhoneNumber(GetPhoneNumberRequest getPhoneNumberRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPhoneNumberResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPhoneNumberRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, getPhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPhoneNumber");
            GetPhoneNumberResponse getPhoneNumberResponse = (GetPhoneNumberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPhoneNumber").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPhoneNumberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPhoneNumberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPhoneNumberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$getPhoneNumber$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPhoneNumberOrderResponse getPhoneNumberOrder(GetPhoneNumberOrderRequest getPhoneNumberOrderRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPhoneNumberOrderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPhoneNumberOrderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, getPhoneNumberOrderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPhoneNumberOrder");
            GetPhoneNumberOrderResponse getPhoneNumberOrderResponse = (GetPhoneNumberOrderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPhoneNumberOrder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPhoneNumberOrderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPhoneNumberOrderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPhoneNumberOrderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$getPhoneNumberOrder$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPhoneNumberSettingsResponse getPhoneNumberSettings(GetPhoneNumberSettingsRequest getPhoneNumberSettingsRequest) throws UnauthorizedClientException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPhoneNumberSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPhoneNumberSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, getPhoneNumberSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPhoneNumberSettings");
            GetPhoneNumberSettingsResponse getPhoneNumberSettingsResponse = (GetPhoneNumberSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPhoneNumberSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPhoneNumberSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPhoneNumberSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPhoneNumberSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$getPhoneNumberSettings$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRetentionSettingsResponse getRetentionSettings(GetRetentionSettingsRequest getRetentionSettingsRequest) throws UnauthorizedClientException, NotFoundException, BadRequestException, ForbiddenException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRetentionSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRetentionSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, getRetentionSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRetentionSettings");
            GetRetentionSettingsResponse getRetentionSettingsResponse = (GetRetentionSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRetentionSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRetentionSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRetentionSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRetentionSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$getRetentionSettings$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRoomResponse getRoom(GetRoomRequest getRoomRequest) throws BadRequestException, ForbiddenException, NotFoundException, UnauthorizedClientException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRoomResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRoomRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, getRoomRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRoom");
            GetRoomResponse getRoomResponse = (GetRoomResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRoom").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRoomRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRoomRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRoomResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$getRoom$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUserResponse getUser(GetUserRequest getUserRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, getUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUser");
            GetUserResponse getUserResponse = (GetUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$getUser$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUserSettingsResponse getUserSettings(GetUserSettingsRequest getUserSettingsRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUserSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getUserSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, getUserSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUserSettings");
            GetUserSettingsResponse getUserSettingsResponse = (GetUserSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUserSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getUserSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetUserSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUserSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$getUserSettings$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InviteUsersResponse inviteUsers(InviteUsersRequest inviteUsersRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InviteUsersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)inviteUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, inviteUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InviteUsers");
            InviteUsersResponse inviteUsersResponse = (InviteUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InviteUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)inviteUsersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new InviteUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return inviteUsersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$inviteUsers$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccountsResponse listAccounts(ListAccountsRequest listAccountsRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAccountsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, listAccountsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccounts");
            ListAccountsResponse listAccountsResponse = (ListAccountsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccounts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAccountsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAccountsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$listAccounts$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBotsResponse listBots(ListBotsRequest listBotsRequest) throws ServiceUnavailableException, ServiceFailureException, ForbiddenException, UnauthorizedClientException, BadRequestException, NotFoundException, ThrottledClientException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBotsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, listBotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBots");
            ListBotsResponse listBotsResponse = (ListBotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listBotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$listBots$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPhoneNumberOrdersResponse listPhoneNumberOrders(ListPhoneNumberOrdersRequest listPhoneNumberOrdersRequest) throws UnauthorizedClientException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPhoneNumberOrdersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPhoneNumberOrdersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, listPhoneNumberOrdersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPhoneNumberOrders");
            ListPhoneNumberOrdersResponse listPhoneNumberOrdersResponse = (ListPhoneNumberOrdersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPhoneNumberOrders").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPhoneNumberOrdersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPhoneNumberOrdersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPhoneNumberOrdersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$listPhoneNumberOrders$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPhoneNumbersResponse listPhoneNumbers(ListPhoneNumbersRequest listPhoneNumbersRequest) throws UnauthorizedClientException, ForbiddenException, BadRequestException, NotFoundException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPhoneNumbersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPhoneNumbersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, listPhoneNumbersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPhoneNumbers");
            ListPhoneNumbersResponse listPhoneNumbersResponse = (ListPhoneNumbersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPhoneNumbers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPhoneNumbersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPhoneNumbersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPhoneNumbersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$listPhoneNumbers$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRoomMembershipsResponse listRoomMemberships(ListRoomMembershipsRequest listRoomMembershipsRequest) throws NotFoundException, BadRequestException, ForbiddenException, UnauthorizedClientException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRoomMembershipsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRoomMembershipsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, listRoomMembershipsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRoomMemberships");
            ListRoomMembershipsResponse listRoomMembershipsResponse = (ListRoomMembershipsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRoomMemberships").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRoomMembershipsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRoomMembershipsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRoomMembershipsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$listRoomMemberships$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRoomsResponse listRooms(ListRoomsRequest listRoomsRequest) throws NotFoundException, BadRequestException, ForbiddenException, UnauthorizedClientException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRoomsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRoomsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, listRoomsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRooms");
            ListRoomsResponse listRoomsResponse = (ListRoomsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRooms").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRoomsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRoomsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRoomsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$listRooms$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSupportedPhoneNumberCountriesResponse listSupportedPhoneNumberCountries(ListSupportedPhoneNumberCountriesRequest listSupportedPhoneNumberCountriesRequest) throws BadRequestException, ForbiddenException, AccessDeniedException, UnauthorizedClientException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSupportedPhoneNumberCountriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSupportedPhoneNumberCountriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, listSupportedPhoneNumberCountriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSupportedPhoneNumberCountries");
            ListSupportedPhoneNumberCountriesResponse listSupportedPhoneNumberCountriesResponse = (ListSupportedPhoneNumberCountriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSupportedPhoneNumberCountries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSupportedPhoneNumberCountriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSupportedPhoneNumberCountriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSupportedPhoneNumberCountriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$listSupportedPhoneNumberCountries$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, listUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUsers");
            ListUsersResponse listUsersResponse = (ListUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listUsersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listUsersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$listUsers$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogoutUserResponse logoutUser(LogoutUserRequest logoutUserRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, LogoutUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)logoutUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, logoutUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"LogoutUser");
            LogoutUserResponse logoutUserResponse = (LogoutUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("LogoutUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)logoutUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new LogoutUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return logoutUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$logoutUser$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEventsConfigurationResponse putEventsConfiguration(PutEventsConfigurationRequest putEventsConfigurationRequest) throws ServiceUnavailableException, ServiceFailureException, ForbiddenException, BadRequestException, UnauthorizedClientException, ResourceLimitExceededException, NotFoundException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEventsConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putEventsConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, putEventsConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEventsConfiguration");
            PutEventsConfigurationResponse putEventsConfigurationResponse = (PutEventsConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEventsConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putEventsConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutEventsConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putEventsConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$putEventsConfiguration$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRetentionSettingsResponse putRetentionSettings(PutRetentionSettingsRequest putRetentionSettingsRequest) throws UnauthorizedClientException, NotFoundException, BadRequestException, ForbiddenException, ConflictException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRetentionSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putRetentionSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, putRetentionSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRetentionSettings");
            PutRetentionSettingsResponse putRetentionSettingsResponse = (PutRetentionSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRetentionSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putRetentionSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutRetentionSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putRetentionSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$putRetentionSettings$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RedactConversationMessageResponse redactConversationMessage(RedactConversationMessageRequest redactConversationMessageRequest) throws NotFoundException, ForbiddenException, UnauthorizedClientException, ThrottledClientException, BadRequestException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RedactConversationMessageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)redactConversationMessageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, redactConversationMessageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RedactConversationMessage");
            RedactConversationMessageResponse redactConversationMessageResponse = (RedactConversationMessageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RedactConversationMessage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)redactConversationMessageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RedactConversationMessageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return redactConversationMessageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$redactConversationMessage$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RedactRoomMessageResponse redactRoomMessage(RedactRoomMessageRequest redactRoomMessageRequest) throws NotFoundException, ForbiddenException, UnauthorizedClientException, ThrottledClientException, BadRequestException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RedactRoomMessageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)redactRoomMessageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, redactRoomMessageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RedactRoomMessage");
            RedactRoomMessageResponse redactRoomMessageResponse = (RedactRoomMessageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RedactRoomMessage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)redactRoomMessageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RedactRoomMessageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return redactRoomMessageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$redactRoomMessage$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegenerateSecurityTokenResponse regenerateSecurityToken(RegenerateSecurityTokenRequest regenerateSecurityTokenRequest) throws ServiceUnavailableException, ServiceFailureException, ForbiddenException, BadRequestException, UnauthorizedClientException, NotFoundException, ThrottledClientException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegenerateSecurityTokenResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)regenerateSecurityTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, regenerateSecurityTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegenerateSecurityToken");
            RegenerateSecurityTokenResponse regenerateSecurityTokenResponse = (RegenerateSecurityTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegenerateSecurityToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)regenerateSecurityTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegenerateSecurityTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return regenerateSecurityTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$regenerateSecurityToken$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResetPersonalPinResponse resetPersonalPIN(ResetPersonalPinRequest resetPersonalPinRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetPersonalPinResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resetPersonalPinRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, resetPersonalPinRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetPersonalPIN");
            ResetPersonalPinResponse resetPersonalPinResponse = (ResetPersonalPinResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetPersonalPIN").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)resetPersonalPinRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResetPersonalPinRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resetPersonalPinResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$resetPersonalPIN$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestorePhoneNumberResponse restorePhoneNumber(RestorePhoneNumberRequest restorePhoneNumberRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ResourceLimitExceededException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestorePhoneNumberResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restorePhoneNumberRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, restorePhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestorePhoneNumber");
            RestorePhoneNumberResponse restorePhoneNumberResponse = (RestorePhoneNumberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestorePhoneNumber").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)restorePhoneNumberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestorePhoneNumberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restorePhoneNumberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$restorePhoneNumber$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchAvailablePhoneNumbersResponse searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersRequest searchAvailablePhoneNumbersRequest) throws BadRequestException, ForbiddenException, AccessDeniedException, UnauthorizedClientException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchAvailablePhoneNumbersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchAvailablePhoneNumbersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, searchAvailablePhoneNumbersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchAvailablePhoneNumbers");
            SearchAvailablePhoneNumbersResponse searchAvailablePhoneNumbersResponse = (SearchAvailablePhoneNumbersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchAvailablePhoneNumbers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)searchAvailablePhoneNumbersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchAvailablePhoneNumbersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchAvailablePhoneNumbersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$searchAvailablePhoneNumbers$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAccountResponse updateAccount(UpdateAccountRequest updateAccountRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, updateAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAccount");
            UpdateAccountResponse updateAccountResponse = (UpdateAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$updateAccount$105((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAccountSettingsResponse updateAccountSettings(UpdateAccountSettingsRequest updateAccountSettingsRequest) throws UnauthorizedClientException, NotFoundException, BadRequestException, ForbiddenException, ConflictException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAccountSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAccountSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, updateAccountSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAccountSettings");
            UpdateAccountSettingsResponse updateAccountSettingsResponse = (UpdateAccountSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccountSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAccountSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAccountSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAccountSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$updateAccountSettings$107((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBotResponse updateBot(UpdateBotRequest updateBotRequest) throws ServiceUnavailableException, ServiceFailureException, ForbiddenException, BadRequestException, UnauthorizedClientException, NotFoundException, ThrottledClientException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, updateBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBot");
            UpdateBotResponse updateBotResponse = (UpdateBotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateBotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$updateBot$109((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGlobalSettingsResponse updateGlobalSettings(UpdateGlobalSettingsRequest updateGlobalSettingsRequest) throws UnauthorizedClientException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGlobalSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGlobalSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, updateGlobalSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGlobalSettings");
            UpdateGlobalSettingsResponse updateGlobalSettingsResponse = (UpdateGlobalSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGlobalSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateGlobalSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGlobalSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGlobalSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$updateGlobalSettings$111((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePhoneNumberResponse updatePhoneNumber(UpdatePhoneNumberRequest updatePhoneNumberRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ConflictException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePhoneNumberResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePhoneNumberRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, updatePhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePhoneNumber");
            UpdatePhoneNumberResponse updatePhoneNumberResponse = (UpdatePhoneNumberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePhoneNumber").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updatePhoneNumberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePhoneNumberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePhoneNumberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$updatePhoneNumber$113((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePhoneNumberSettingsResponse updatePhoneNumberSettings(UpdatePhoneNumberSettingsRequest updatePhoneNumberSettingsRequest) throws UnauthorizedClientException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePhoneNumberSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePhoneNumberSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, updatePhoneNumberSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePhoneNumberSettings");
            UpdatePhoneNumberSettingsResponse updatePhoneNumberSettingsResponse = (UpdatePhoneNumberSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePhoneNumberSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updatePhoneNumberSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePhoneNumberSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePhoneNumberSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$updatePhoneNumberSettings$115((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRoomResponse updateRoom(UpdateRoomRequest updateRoomRequest) throws BadRequestException, ForbiddenException, NotFoundException, UnauthorizedClientException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRoomResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRoomRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, updateRoomRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRoom");
            UpdateRoomResponse updateRoomResponse = (UpdateRoomResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRoom").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateRoomRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRoomRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRoomResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$updateRoom$117((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRoomMembershipResponse updateRoomMembership(UpdateRoomMembershipRequest updateRoomMembershipRequest) throws UnauthorizedClientException, NotFoundException, BadRequestException, ForbiddenException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRoomMembershipResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRoomMembershipRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, updateRoomMembershipRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRoomMembership");
            UpdateRoomMembershipResponse updateRoomMembershipResponse = (UpdateRoomMembershipResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRoomMembership").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateRoomMembershipRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRoomMembershipRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRoomMembershipResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$updateRoomMembership$119((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, updateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUser");
            UpdateUserResponse updateUserResponse = (UpdateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$updateUser$121((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateUserSettingsResponse updateUserSettings(UpdateUserSettingsRequest updateUserSettingsRequest) throws UnauthorizedClientException, NotFoundException, ForbiddenException, BadRequestException, ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthorizedClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "ThrottledClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledClientException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledClientException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateUserSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeClient.resolveMetricPublishers(clientConfiguration, updateUserSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUserSettings");
            UpdateUserSettingsResponse updateUserSettingsResponse = (UpdateUserSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUserSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateUserSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateUserSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateUserSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeClient.lambda$updateUserSettings$123((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "chime";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ChimeServiceClientConfigurationBuilder serviceConfigBuilder = new ChimeServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ChimeException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final ChimeServiceClientConfiguration serviceClientConfiguration() {
        return new ChimeServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateUserSettings$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateUser$121(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRoomMembership$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRoom$117(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePhoneNumberSettings$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePhoneNumber$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGlobalSettings$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBot$109(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAccountSettings$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAccount$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchAvailablePhoneNumbers$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restorePhoneNumber$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetPersonalPIN$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$regenerateSecurityToken$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$redactRoomMessage$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$redactConversationMessage$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putRetentionSettings$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putEventsConfiguration$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$logoutUser$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUsers$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSupportedPhoneNumberCountries$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRooms$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRoomMemberships$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPhoneNumbers$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPhoneNumberOrders$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBots$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccounts$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$inviteUsers$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUserSettings$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUser$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRoom$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRetentionSettings$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPhoneNumberSettings$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPhoneNumberOrder$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPhoneNumber$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGlobalSettings$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEventsConfiguration$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBot$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccountSettings$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccount$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateSigninDelegateGroupsFromAccount$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociatePhoneNumberFromUser$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRoomMembership$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRoom$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePhoneNumber$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEventsConfiguration$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccount$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUser$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRoomMembership$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRoom$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPhoneNumberOrder$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMeetingDialOut$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBot$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccount$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUpdateUser$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUpdatePhoneNumber$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUnsuspendUser$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchSuspendUser$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeletePhoneNumber$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchCreateRoomMembership$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateSigninDelegateGroupsWithAccount$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associatePhoneNumberWithUser$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

