/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamPipelineSinkType;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaStreamSink
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaStreamSink> {
    private static final SdkField<String> SINK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SinkArn").getter(MediaStreamSink.getter(MediaStreamSink::sinkArn)).setter(MediaStreamSink.setter(Builder::sinkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkArn").build()}).build();
    private static final SdkField<String> SINK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SinkType").getter(MediaStreamSink.getter(MediaStreamSink::sinkTypeAsString)).setter(MediaStreamSink.setter(Builder::sinkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkType").build()}).build();
    private static final SdkField<Integer> RESERVED_STREAM_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReservedStreamCapacity").getter(MediaStreamSink.getter(MediaStreamSink::reservedStreamCapacity)).setter(MediaStreamSink.setter(Builder::reservedStreamCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedStreamCapacity").build()}).build();
    private static final SdkField<String> MEDIA_STREAM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaStreamType").getter(MediaStreamSink.getter(MediaStreamSink::mediaStreamTypeAsString)).setter(MediaStreamSink.setter(Builder::mediaStreamType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaStreamType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SINK_ARN_FIELD, SINK_TYPE_FIELD, RESERVED_STREAM_CAPACITY_FIELD, MEDIA_STREAM_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaStreamSink.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sinkArn;
    private final String sinkType;
    private final Integer reservedStreamCapacity;
    private final String mediaStreamType;

    private MediaStreamSink(BuilderImpl builder) {
        this.sinkArn = builder.sinkArn;
        this.sinkType = builder.sinkType;
        this.reservedStreamCapacity = builder.reservedStreamCapacity;
        this.mediaStreamType = builder.mediaStreamType;
    }

    public final String sinkArn() {
        return this.sinkArn;
    }

    public final MediaStreamPipelineSinkType sinkType() {
        return MediaStreamPipelineSinkType.fromValue(this.sinkType);
    }

    public final String sinkTypeAsString() {
        return this.sinkType;
    }

    public final Integer reservedStreamCapacity() {
        return this.reservedStreamCapacity;
    }

    public final MediaStreamType mediaStreamType() {
        return MediaStreamType.fromValue(this.mediaStreamType);
    }

    public final String mediaStreamTypeAsString() {
        return this.mediaStreamType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sinkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sinkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedStreamCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaStreamTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaStreamSink)) {
            return false;
        }
        MediaStreamSink other = (MediaStreamSink)obj;
        return Objects.equals(this.sinkArn(), other.sinkArn()) && Objects.equals(this.sinkTypeAsString(), other.sinkTypeAsString()) && Objects.equals(this.reservedStreamCapacity(), other.reservedStreamCapacity()) && Objects.equals(this.mediaStreamTypeAsString(), other.mediaStreamTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MediaStreamSink").add("SinkArn", (Object)(this.sinkArn() == null ? null : "*** Sensitive Data Redacted ***")).add("SinkType", (Object)this.sinkTypeAsString()).add("ReservedStreamCapacity", (Object)this.reservedStreamCapacity()).add("MediaStreamType", (Object)this.mediaStreamTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SinkArn": {
                return Optional.ofNullable(clazz.cast(this.sinkArn()));
            }
            case "SinkType": {
                return Optional.ofNullable(clazz.cast(this.sinkTypeAsString()));
            }
            case "ReservedStreamCapacity": {
                return Optional.ofNullable(clazz.cast(this.reservedStreamCapacity()));
            }
            case "MediaStreamType": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SinkArn", SINK_ARN_FIELD);
        map.put("SinkType", SINK_TYPE_FIELD);
        map.put("ReservedStreamCapacity", RESERVED_STREAM_CAPACITY_FIELD);
        map.put("MediaStreamType", MEDIA_STREAM_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaStreamSink, T> g) {
        return obj -> g.apply((MediaStreamSink)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sinkArn;
        private String sinkType;
        private Integer reservedStreamCapacity;
        private String mediaStreamType;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaStreamSink model) {
            this.sinkArn(model.sinkArn);
            this.sinkType(model.sinkType);
            this.reservedStreamCapacity(model.reservedStreamCapacity);
            this.mediaStreamType(model.mediaStreamType);
        }

        public final String getSinkArn() {
            return this.sinkArn;
        }

        public final void setSinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
        }

        @Override
        public final Builder sinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
            return this;
        }

        public final String getSinkType() {
            return this.sinkType;
        }

        public final void setSinkType(String sinkType) {
            this.sinkType = sinkType;
        }

        @Override
        public final Builder sinkType(String sinkType) {
            this.sinkType = sinkType;
            return this;
        }

        @Override
        public final Builder sinkType(MediaStreamPipelineSinkType sinkType) {
            this.sinkType(sinkType == null ? null : sinkType.toString());
            return this;
        }

        public final Integer getReservedStreamCapacity() {
            return this.reservedStreamCapacity;
        }

        public final void setReservedStreamCapacity(Integer reservedStreamCapacity) {
            this.reservedStreamCapacity = reservedStreamCapacity;
        }

        @Override
        public final Builder reservedStreamCapacity(Integer reservedStreamCapacity) {
            this.reservedStreamCapacity = reservedStreamCapacity;
            return this;
        }

        public final String getMediaStreamType() {
            return this.mediaStreamType;
        }

        public final void setMediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
        }

        @Override
        public final Builder mediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
            return this;
        }

        @Override
        public final Builder mediaStreamType(MediaStreamType mediaStreamType) {
            this.mediaStreamType(mediaStreamType == null ? null : mediaStreamType.toString());
            return this;
        }

        public MediaStreamSink build() {
            return new MediaStreamSink(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaStreamSink> {
        public Builder sinkArn(String var1);

        public Builder sinkType(String var1);

        public Builder sinkType(MediaStreamPipelineSinkType var1);

        public Builder reservedStreamCapacity(Integer var1);

        public Builder mediaStreamType(String var1);

        public Builder mediaStreamType(MediaStreamType var1);
    }
}

