/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMeetingWithAttendeesRequest extends ChimeSdkMeetingsRequest implements
        ToCopyableBuilder<CreateMeetingWithAttendeesRequest.Builder, CreateMeetingWithAttendeesRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateMeetingWithAttendeesRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> MEDIA_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaRegion").getter(getter(CreateMeetingWithAttendeesRequest::mediaRegion))
            .setter(setter(Builder::mediaRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaRegion").build()).build();

    private static final SdkField<String> MEETING_HOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeetingHostId").getter(getter(CreateMeetingWithAttendeesRequest::meetingHostId))
            .setter(setter(Builder::meetingHostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingHostId").build()).build();

    private static final SdkField<String> EXTERNAL_MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalMeetingId").getter(getter(CreateMeetingWithAttendeesRequest::externalMeetingId))
            .setter(setter(Builder::externalMeetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalMeetingId").build()).build();

    private static final SdkField<MeetingFeaturesConfiguration> MEETING_FEATURES_FIELD = SdkField
            .<MeetingFeaturesConfiguration> builder(MarshallingType.SDK_POJO).memberName("MeetingFeatures")
            .getter(getter(CreateMeetingWithAttendeesRequest::meetingFeatures)).setter(setter(Builder::meetingFeatures))
            .constructor(MeetingFeaturesConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingFeatures").build()).build();

    private static final SdkField<NotificationsConfiguration> NOTIFICATIONS_CONFIGURATION_FIELD = SdkField
            .<NotificationsConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("NotificationsConfiguration")
            .getter(getter(CreateMeetingWithAttendeesRequest::notificationsConfiguration))
            .setter(setter(Builder::notificationsConfiguration))
            .constructor(NotificationsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationsConfiguration").build())
            .build();

    private static final SdkField<List<CreateAttendeeRequestItem>> ATTENDEES_FIELD = SdkField
            .<List<CreateAttendeeRequestItem>> builder(MarshallingType.LIST)
            .memberName("Attendees")
            .getter(getter(CreateMeetingWithAttendeesRequest::attendees))
            .setter(setter(Builder::attendees))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendees").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateAttendeeRequestItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateAttendeeRequestItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            MEDIA_REGION_FIELD, MEETING_HOST_ID_FIELD, EXTERNAL_MEETING_ID_FIELD, MEETING_FEATURES_FIELD,
            NOTIFICATIONS_CONFIGURATION_FIELD, ATTENDEES_FIELD));

    private final String clientRequestToken;

    private final String mediaRegion;

    private final String meetingHostId;

    private final String externalMeetingId;

    private final MeetingFeaturesConfiguration meetingFeatures;

    private final NotificationsConfiguration notificationsConfiguration;

    private final List<CreateAttendeeRequestItem> attendees;

    private CreateMeetingWithAttendeesRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.mediaRegion = builder.mediaRegion;
        this.meetingHostId = builder.meetingHostId;
        this.externalMeetingId = builder.externalMeetingId;
        this.meetingFeatures = builder.meetingFeatures;
        this.notificationsConfiguration = builder.notificationsConfiguration;
        this.attendees = builder.attendees;
    }

    /**
     * <p>
     * The unique identifier for the client request. Use a different token for different meetings.
     * </p>
     * 
     * @return The unique identifier for the client request. Use a different token for different meetings.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The Region in which to create the meeting.
     * </p>
     * 
     * @return The Region in which to create the meeting.
     */
    public final String mediaRegion() {
        return mediaRegion;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String meetingHostId() {
        return meetingHostId;
    }

    /**
     * <p>
     * The external meeting ID.
     * </p>
     * 
     * @return The external meeting ID.
     */
    public final String externalMeetingId() {
        return externalMeetingId;
    }

    /**
     * <p>
     * Lists the audio and video features enabled for a meeting, such as echo reduction.
     * </p>
     * 
     * @return Lists the audio and video features enabled for a meeting, such as echo reduction.
     */
    public final MeetingFeaturesConfiguration meetingFeatures() {
        return meetingFeatures;
    }

    /**
     * <p>
     * The configuration for resource targets to receive notifications when meeting and attendee events occur.
     * </p>
     * 
     * @return The configuration for resource targets to receive notifications when meeting and attendee events occur.
     */
    public final NotificationsConfiguration notificationsConfiguration() {
        return notificationsConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attendees property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttendees() {
        return attendees != null && !(attendees instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attendee information, including attendees' IDs and join tokens.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttendees} method.
     * </p>
     * 
     * @return The attendee information, including attendees' IDs and join tokens.
     */
    public final List<CreateAttendeeRequestItem> attendees() {
        return attendees;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(mediaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(meetingHostId());
        hashCode = 31 * hashCode + Objects.hashCode(externalMeetingId());
        hashCode = 31 * hashCode + Objects.hashCode(meetingFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(notificationsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttendees() ? attendees() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeetingWithAttendeesRequest)) {
            return false;
        }
        CreateMeetingWithAttendeesRequest other = (CreateMeetingWithAttendeesRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(mediaRegion(), other.mediaRegion()) && Objects.equals(meetingHostId(), other.meetingHostId())
                && Objects.equals(externalMeetingId(), other.externalMeetingId())
                && Objects.equals(meetingFeatures(), other.meetingFeatures())
                && Objects.equals(notificationsConfiguration(), other.notificationsConfiguration())
                && hasAttendees() == other.hasAttendees() && Objects.equals(attendees(), other.attendees());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMeetingWithAttendeesRequest")
                .add("ClientRequestToken", clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MediaRegion", mediaRegion())
                .add("MeetingHostId", meetingHostId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExternalMeetingId", externalMeetingId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MeetingFeatures", meetingFeatures()).add("NotificationsConfiguration", notificationsConfiguration())
                .add("Attendees", hasAttendees() ? attendees() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "MediaRegion":
            return Optional.ofNullable(clazz.cast(mediaRegion()));
        case "MeetingHostId":
            return Optional.ofNullable(clazz.cast(meetingHostId()));
        case "ExternalMeetingId":
            return Optional.ofNullable(clazz.cast(externalMeetingId()));
        case "MeetingFeatures":
            return Optional.ofNullable(clazz.cast(meetingFeatures()));
        case "NotificationsConfiguration":
            return Optional.ofNullable(clazz.cast(notificationsConfiguration()));
        case "Attendees":
            return Optional.ofNullable(clazz.cast(attendees()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMeetingWithAttendeesRequest, T> g) {
        return obj -> g.apply((CreateMeetingWithAttendeesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMeetingsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMeetingWithAttendeesRequest> {
        /**
         * <p>
         * The unique identifier for the client request. Use a different token for different meetings.
         * </p>
         * 
         * @param clientRequestToken
         *        The unique identifier for the client request. Use a different token for different meetings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The Region in which to create the meeting.
         * </p>
         * 
         * @param mediaRegion
         *        The Region in which to create the meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaRegion(String mediaRegion);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param meetingHostId
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingHostId(String meetingHostId);

        /**
         * <p>
         * The external meeting ID.
         * </p>
         * 
         * @param externalMeetingId
         *        The external meeting ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalMeetingId(String externalMeetingId);

        /**
         * <p>
         * Lists the audio and video features enabled for a meeting, such as echo reduction.
         * </p>
         * 
         * @param meetingFeatures
         *        Lists the audio and video features enabled for a meeting, such as echo reduction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingFeatures(MeetingFeaturesConfiguration meetingFeatures);

        /**
         * <p>
         * Lists the audio and video features enabled for a meeting, such as echo reduction.
         * </p>
         * This is a convenience that creates an instance of the {@link MeetingFeaturesConfiguration.Builder} avoiding
         * the need to create one manually via {@link MeetingFeaturesConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MeetingFeaturesConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #meetingFeatures(MeetingFeaturesConfiguration)}.
         * 
         * @param meetingFeatures
         *        a consumer that will call methods on {@link MeetingFeaturesConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meetingFeatures(MeetingFeaturesConfiguration)
         */
        default Builder meetingFeatures(Consumer<MeetingFeaturesConfiguration.Builder> meetingFeatures) {
            return meetingFeatures(MeetingFeaturesConfiguration.builder().applyMutation(meetingFeatures).build());
        }

        /**
         * <p>
         * The configuration for resource targets to receive notifications when meeting and attendee events occur.
         * </p>
         * 
         * @param notificationsConfiguration
         *        The configuration for resource targets to receive notifications when meeting and attendee events
         *        occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationsConfiguration(NotificationsConfiguration notificationsConfiguration);

        /**
         * <p>
         * The configuration for resource targets to receive notifications when meeting and attendee events occur.
         * </p>
         * This is a convenience that creates an instance of the {@link NotificationsConfiguration.Builder} avoiding the
         * need to create one manually via {@link NotificationsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #notificationsConfiguration(NotificationsConfiguration)}.
         * 
         * @param notificationsConfiguration
         *        a consumer that will call methods on {@link NotificationsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationsConfiguration(NotificationsConfiguration)
         */
        default Builder notificationsConfiguration(Consumer<NotificationsConfiguration.Builder> notificationsConfiguration) {
            return notificationsConfiguration(NotificationsConfiguration.builder().applyMutation(notificationsConfiguration)
                    .build());
        }

        /**
         * <p>
         * The attendee information, including attendees' IDs and join tokens.
         * </p>
         * 
         * @param attendees
         *        The attendee information, including attendees' IDs and join tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendees(Collection<CreateAttendeeRequestItem> attendees);

        /**
         * <p>
         * The attendee information, including attendees' IDs and join tokens.
         * </p>
         * 
         * @param attendees
         *        The attendee information, including attendees' IDs and join tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendees(CreateAttendeeRequestItem... attendees);

        /**
         * <p>
         * The attendee information, including attendees' IDs and join tokens.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CreateAttendeeRequestItem>.Builder}
         * avoiding the need to create one manually via {@link List<CreateAttendeeRequestItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CreateAttendeeRequestItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #attendees(List<CreateAttendeeRequestItem>)}.
         * 
         * @param attendees
         *        a consumer that will call methods on {@link List<CreateAttendeeRequestItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attendees(List<CreateAttendeeRequestItem>)
         */
        Builder attendees(Consumer<CreateAttendeeRequestItem.Builder>... attendees);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMeetingsRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String mediaRegion;

        private String meetingHostId;

        private String externalMeetingId;

        private MeetingFeaturesConfiguration meetingFeatures;

        private NotificationsConfiguration notificationsConfiguration;

        private List<CreateAttendeeRequestItem> attendees = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMeetingWithAttendeesRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            mediaRegion(model.mediaRegion);
            meetingHostId(model.meetingHostId);
            externalMeetingId(model.externalMeetingId);
            meetingFeatures(model.meetingFeatures);
            notificationsConfiguration(model.notificationsConfiguration);
            attendees(model.attendees);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getMediaRegion() {
            return mediaRegion;
        }

        public final void setMediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
        }

        @Override
        @Transient
        public final Builder mediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
            return this;
        }

        public final String getMeetingHostId() {
            return meetingHostId;
        }

        public final void setMeetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
        }

        @Override
        @Transient
        public final Builder meetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
            return this;
        }

        public final String getExternalMeetingId() {
            return externalMeetingId;
        }

        public final void setExternalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
        }

        @Override
        @Transient
        public final Builder externalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
            return this;
        }

        public final MeetingFeaturesConfiguration.Builder getMeetingFeatures() {
            return meetingFeatures != null ? meetingFeatures.toBuilder() : null;
        }

        public final void setMeetingFeatures(MeetingFeaturesConfiguration.BuilderImpl meetingFeatures) {
            this.meetingFeatures = meetingFeatures != null ? meetingFeatures.build() : null;
        }

        @Override
        @Transient
        public final Builder meetingFeatures(MeetingFeaturesConfiguration meetingFeatures) {
            this.meetingFeatures = meetingFeatures;
            return this;
        }

        public final NotificationsConfiguration.Builder getNotificationsConfiguration() {
            return notificationsConfiguration != null ? notificationsConfiguration.toBuilder() : null;
        }

        public final void setNotificationsConfiguration(NotificationsConfiguration.BuilderImpl notificationsConfiguration) {
            this.notificationsConfiguration = notificationsConfiguration != null ? notificationsConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder notificationsConfiguration(NotificationsConfiguration notificationsConfiguration) {
            this.notificationsConfiguration = notificationsConfiguration;
            return this;
        }

        public final List<CreateAttendeeRequestItem.Builder> getAttendees() {
            List<CreateAttendeeRequestItem.Builder> result = CreateMeetingWithAttendeesRequestItemListCopier
                    .copyToBuilder(this.attendees);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttendees(Collection<CreateAttendeeRequestItem.BuilderImpl> attendees) {
            this.attendees = CreateMeetingWithAttendeesRequestItemListCopier.copyFromBuilder(attendees);
        }

        @Override
        @Transient
        public final Builder attendees(Collection<CreateAttendeeRequestItem> attendees) {
            this.attendees = CreateMeetingWithAttendeesRequestItemListCopier.copy(attendees);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attendees(CreateAttendeeRequestItem... attendees) {
            attendees(Arrays.asList(attendees));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attendees(Consumer<CreateAttendeeRequestItem.Builder>... attendees) {
            attendees(Stream.of(attendees).map(c -> CreateAttendeeRequestItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMeetingWithAttendeesRequest build() {
            return new CreateMeetingWithAttendeesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
