/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAttendeeResponse extends ChimeSdkMeetingsResponse implements
        ToCopyableBuilder<GetAttendeeResponse.Builder, GetAttendeeResponse> {
    private static final SdkField<Attendee> ATTENDEE_FIELD = SdkField.<Attendee> builder(MarshallingType.SDK_POJO)
            .memberName("Attendee").getter(getter(GetAttendeeResponse::attendee)).setter(setter(Builder::attendee))
            .constructor(Attendee::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendee").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTENDEE_FIELD));

    private final Attendee attendee;

    private GetAttendeeResponse(BuilderImpl builder) {
        super(builder);
        this.attendee = builder.attendee;
    }

    /**
     * <p>
     * The Amazon Chime SDK attendee information.
     * </p>
     * 
     * @return The Amazon Chime SDK attendee information.
     */
    public final Attendee attendee() {
        return attendee;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attendee());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAttendeeResponse)) {
            return false;
        }
        GetAttendeeResponse other = (GetAttendeeResponse) obj;
        return Objects.equals(attendee(), other.attendee());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAttendeeResponse").add("Attendee", attendee()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attendee":
            return Optional.ofNullable(clazz.cast(attendee()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAttendeeResponse, T> g) {
        return obj -> g.apply((GetAttendeeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMeetingsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAttendeeResponse> {
        /**
         * <p>
         * The Amazon Chime SDK attendee information.
         * </p>
         * 
         * @param attendee
         *        The Amazon Chime SDK attendee information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendee(Attendee attendee);

        /**
         * <p>
         * The Amazon Chime SDK attendee information.
         * </p>
         * This is a convenience that creates an instance of the {@link Attendee.Builder} avoiding the need to create
         * one manually via {@link Attendee#builder()}.
         *
         * When the {@link Consumer} completes, {@link Attendee.Builder#build()} is called immediately and its result is
         * passed to {@link #attendee(Attendee)}.
         * 
         * @param attendee
         *        a consumer that will call methods on {@link Attendee.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attendee(Attendee)
         */
        default Builder attendee(Consumer<Attendee.Builder> attendee) {
            return attendee(Attendee.builder().applyMutation(attendee).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkMeetingsResponse.BuilderImpl implements Builder {
        private Attendee attendee;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAttendeeResponse model) {
            super(model);
            attendee(model.attendee);
        }

        public final Attendee.Builder getAttendee() {
            return attendee != null ? attendee.toBuilder() : null;
        }

        public final void setAttendee(Attendee.BuilderImpl attendee) {
            this.attendee = attendee != null ? attendee.build() : null;
        }

        @Override
        @Transient
        public final Builder attendee(Attendee attendee) {
            this.attendee = attendee;
            return this;
        }

        @Override
        public GetAttendeeResponse build() {
            return new GetAttendeeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
