/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationChangeSpecification;
import software.amazon.awssdk.services.cleanrooms.model.MemberChangeSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChangeSpecification> {
    private static final SdkField<MemberChangeSpecification> MEMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("member").getter(ChangeSpecification.getter(ChangeSpecification::member)).setter(ChangeSpecification.setter(Builder::member)).constructor(MemberChangeSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build();
    private static final SdkField<CollaborationChangeSpecification> COLLABORATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("collaboration").getter(ChangeSpecification.getter(ChangeSpecification::collaboration)).setter(ChangeSpecification.setter(Builder::collaboration)).constructor(CollaborationChangeSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_FIELD, COLLABORATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChangeSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final MemberChangeSpecification member;
    private final CollaborationChangeSpecification collaboration;
    private final Type type;

    private ChangeSpecification(BuilderImpl builder) {
        this.member = builder.member;
        this.collaboration = builder.collaboration;
        this.type = builder.type;
    }

    public final MemberChangeSpecification member() {
        return this.member;
    }

    public final CollaborationChangeSpecification collaboration() {
        return this.collaboration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.member());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaboration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeSpecification)) {
            return false;
        }
        ChangeSpecification other = (ChangeSpecification)obj;
        return Objects.equals(this.member(), other.member()) && Objects.equals(this.collaboration(), other.collaboration());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeSpecification").add("Member", (Object)this.member()).add("Collaboration", (Object)this.collaboration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "member": {
                return Optional.ofNullable(clazz.cast(this.member()));
            }
            case "collaboration": {
                return Optional.ofNullable(clazz.cast(this.collaboration()));
            }
        }
        return Optional.empty();
    }

    public static ChangeSpecification fromMember(MemberChangeSpecification member) {
        return (ChangeSpecification)ChangeSpecification.builder().member(member).build();
    }

    public static ChangeSpecification fromMember(Consumer<MemberChangeSpecification.Builder> member) {
        MemberChangeSpecification.Builder builder = MemberChangeSpecification.builder();
        member.accept(builder);
        return ChangeSpecification.fromMember((MemberChangeSpecification)builder.build());
    }

    public static ChangeSpecification fromCollaboration(CollaborationChangeSpecification collaboration) {
        return (ChangeSpecification)ChangeSpecification.builder().collaboration(collaboration).build();
    }

    public static ChangeSpecification fromCollaboration(Consumer<CollaborationChangeSpecification.Builder> collaboration) {
        CollaborationChangeSpecification.Builder builder = CollaborationChangeSpecification.builder();
        collaboration.accept(builder);
        return ChangeSpecification.fromCollaboration((CollaborationChangeSpecification)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("member", MEMBER_FIELD);
        map.put("collaboration", COLLABORATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeSpecification, T> g) {
        return obj -> g.apply((ChangeSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        MEMBER,
        COLLABORATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private MemberChangeSpecification member;
        private CollaborationChangeSpecification collaboration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeSpecification model) {
            this.member(model.member);
            this.collaboration(model.collaboration);
        }

        public final MemberChangeSpecification.Builder getMember() {
            return this.member != null ? this.member.toBuilder() : null;
        }

        public final void setMember(MemberChangeSpecification.BuilderImpl member) {
            MemberChangeSpecification oldValue = this.member;
            this.member = member != null ? member.build() : null;
            this.handleUnionValueChange(Type.MEMBER, oldValue, this.member);
        }

        @Override
        public final Builder member(MemberChangeSpecification member) {
            MemberChangeSpecification oldValue = this.member;
            this.member = member;
            this.handleUnionValueChange(Type.MEMBER, oldValue, this.member);
            return this;
        }

        public final CollaborationChangeSpecification.Builder getCollaboration() {
            return this.collaboration != null ? this.collaboration.toBuilder() : null;
        }

        public final void setCollaboration(CollaborationChangeSpecification.BuilderImpl collaboration) {
            CollaborationChangeSpecification oldValue = this.collaboration;
            this.collaboration = collaboration != null ? collaboration.build() : null;
            this.handleUnionValueChange(Type.COLLABORATION, oldValue, this.collaboration);
        }

        @Override
        public final Builder collaboration(CollaborationChangeSpecification collaboration) {
            CollaborationChangeSpecification oldValue = this.collaboration;
            this.collaboration = collaboration;
            this.handleUnionValueChange(Type.COLLABORATION, oldValue, this.collaboration);
            return this;
        }

        public ChangeSpecification build() {
            return new ChangeSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChangeSpecification> {
        public Builder member(MemberChangeSpecification var1);

        default public Builder member(Consumer<MemberChangeSpecification.Builder> member) {
            return this.member((MemberChangeSpecification)((MemberChangeSpecification.Builder)MemberChangeSpecification.builder().applyMutation(member)).build());
        }

        public Builder collaboration(CollaborationChangeSpecification var1);

        default public Builder collaboration(Consumer<CollaborationChangeSpecification.Builder> collaboration) {
            return this.collaboration((CollaborationChangeSpecification)((CollaborationChangeSpecification.Builder)CollaborationChangeSpecification.builder().applyMutation(collaboration)).build());
        }
    }
}

