/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.BudgetParameter;
import software.amazon.awssdk.services.cleanrooms.model.BudgetParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessBudgetsPrivacyTemplateParametersOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessBudgetsPrivacyTemplateParametersOutput> {
    private static final SdkField<List<BudgetParameter>> BUDGET_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("budgetParameters").getter(AccessBudgetsPrivacyTemplateParametersOutput.getter(AccessBudgetsPrivacyTemplateParametersOutput::budgetParameters)).setter(AccessBudgetsPrivacyTemplateParametersOutput.setter(Builder::budgetParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("budgetParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BudgetParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(AccessBudgetsPrivacyTemplateParametersOutput.getter(AccessBudgetsPrivacyTemplateParametersOutput::resourceArn)).setter(AccessBudgetsPrivacyTemplateParametersOutput.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGET_PARAMETERS_FIELD, RESOURCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccessBudgetsPrivacyTemplateParametersOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<BudgetParameter> budgetParameters;
    private final String resourceArn;

    private AccessBudgetsPrivacyTemplateParametersOutput(BuilderImpl builder) {
        this.budgetParameters = builder.budgetParameters;
        this.resourceArn = builder.resourceArn;
    }

    public final boolean hasBudgetParameters() {
        return this.budgetParameters != null && !(this.budgetParameters instanceof SdkAutoConstructList);
    }

    public final List<BudgetParameter> budgetParameters() {
        return this.budgetParameters;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBudgetParameters() ? this.budgetParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessBudgetsPrivacyTemplateParametersOutput)) {
            return false;
        }
        AccessBudgetsPrivacyTemplateParametersOutput other = (AccessBudgetsPrivacyTemplateParametersOutput)obj;
        return this.hasBudgetParameters() == other.hasBudgetParameters() && Objects.equals(this.budgetParameters(), other.budgetParameters()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"AccessBudgetsPrivacyTemplateParametersOutput").add("BudgetParameters", this.hasBudgetParameters() ? this.budgetParameters() : null).add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "budgetParameters": {
                return Optional.ofNullable(clazz.cast(this.budgetParameters()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("budgetParameters", BUDGET_PARAMETERS_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessBudgetsPrivacyTemplateParametersOutput, T> g) {
        return obj -> g.apply((AccessBudgetsPrivacyTemplateParametersOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<BudgetParameter> budgetParameters = DefaultSdkAutoConstructList.getInstance();
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessBudgetsPrivacyTemplateParametersOutput model) {
            this.budgetParameters(model.budgetParameters);
            this.resourceArn(model.resourceArn);
        }

        public final List<BudgetParameter.Builder> getBudgetParameters() {
            List<BudgetParameter.Builder> result = BudgetParametersCopier.copyToBuilder(this.budgetParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBudgetParameters(Collection<BudgetParameter.BuilderImpl> budgetParameters) {
            this.budgetParameters = BudgetParametersCopier.copyFromBuilder(budgetParameters);
        }

        @Override
        public final Builder budgetParameters(Collection<BudgetParameter> budgetParameters) {
            this.budgetParameters = BudgetParametersCopier.copy(budgetParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgetParameters(BudgetParameter ... budgetParameters) {
            this.budgetParameters(Arrays.asList(budgetParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgetParameters(Consumer<BudgetParameter.Builder> ... budgetParameters) {
            this.budgetParameters(Stream.of(budgetParameters).map(c -> (BudgetParameter)((BudgetParameter.Builder)BudgetParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public AccessBudgetsPrivacyTemplateParametersOutput build() {
            return new AccessBudgetsPrivacyTemplateParametersOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessBudgetsPrivacyTemplateParametersOutput> {
        public Builder budgetParameters(Collection<BudgetParameter> var1);

        public Builder budgetParameters(BudgetParameter ... var1);

        public Builder budgetParameters(Consumer<BudgetParameter.Builder> ... var1);

        public Builder resourceArn(String var1);
    }
}

