/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AnalysisFormat {
    SQL("SQL"),
    PYSPARK_1_0("PYSPARK_1_0"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AnalysisFormat> VALUE_MAP;
    private final String value;

    private AnalysisFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AnalysisFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AnalysisFormat> knownValues() {
        EnumSet<AnalysisFormat> knownValues = EnumSet.allOf(AnalysisFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AnalysisFormat.class, AnalysisFormat::toString);
    }
}

