/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.CustomDataIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomEntityConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomEntityConfig> {
    private static final SdkField<List<String>> CUSTOM_DATA_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customDataIdentifiers").getter(CustomEntityConfig.getter(CustomEntityConfig::customDataIdentifiers)).setter(CustomEntityConfig.setter(Builder::customDataIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDataIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DATA_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomEntityConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> customDataIdentifiers;

    private CustomEntityConfig(BuilderImpl builder) {
        this.customDataIdentifiers = builder.customDataIdentifiers;
    }

    public final boolean hasCustomDataIdentifiers() {
        return this.customDataIdentifiers != null && !(this.customDataIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> customDataIdentifiers() {
        return this.customDataIdentifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomDataIdentifiers() ? this.customDataIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomEntityConfig)) {
            return false;
        }
        CustomEntityConfig other = (CustomEntityConfig)obj;
        return this.hasCustomDataIdentifiers() == other.hasCustomDataIdentifiers() && Objects.equals(this.customDataIdentifiers(), other.customDataIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"CustomEntityConfig").add("CustomDataIdentifiers", this.hasCustomDataIdentifiers() ? this.customDataIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customDataIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.customDataIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("customDataIdentifiers", CUSTOM_DATA_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomEntityConfig, T> g) {
        return obj -> g.apply((CustomEntityConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> customDataIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomEntityConfig model) {
            this.customDataIdentifiers(model.customDataIdentifiers);
        }

        public final Collection<String> getCustomDataIdentifiers() {
            if (this.customDataIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customDataIdentifiers;
        }

        public final void setCustomDataIdentifiers(Collection<String> customDataIdentifiers) {
            this.customDataIdentifiers = CustomDataIdentifierListCopier.copy(customDataIdentifiers);
        }

        @Override
        public final Builder customDataIdentifiers(Collection<String> customDataIdentifiers) {
            this.customDataIdentifiers = CustomDataIdentifierListCopier.copy(customDataIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDataIdentifiers(String ... customDataIdentifiers) {
            this.customDataIdentifiers(Arrays.asList(customDataIdentifiers));
            return this;
        }

        public CustomEntityConfig build() {
            return new CustomEntityConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomEntityConfig> {
        public Builder customDataIdentifiers(Collection<String> var1);

        public Builder customDataIdentifiers(String ... var1);
    }
}

