/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelSummary;

public class ListTrainedModelVersionsPublisher
implements SdkPublisher<ListTrainedModelVersionsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListTrainedModelVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrainedModelVersionsPublisher(CleanRoomsMlAsyncClient client, ListTrainedModelVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrainedModelVersionsPublisher(CleanRoomsMlAsyncClient client, ListTrainedModelVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrainedModelVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrainedModelVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrainedModelSummary> trainedModels() {
        Function<ListTrainedModelVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trainedModels() != null) {
                return response.trainedModels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTrainedModelVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTrainedModelVersionsResponseFetcher
    implements AsyncPageFetcher<ListTrainedModelVersionsResponse> {
        private ListTrainedModelVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrainedModelVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrainedModelVersionsResponse> nextPage(ListTrainedModelVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListTrainedModelVersionsPublisher.this.client.listTrainedModelVersions(ListTrainedModelVersionsPublisher.this.firstRequest);
            }
            return ListTrainedModelVersionsPublisher.this.client.listTrainedModelVersions((ListTrainedModelVersionsRequest)((Object)ListTrainedModelVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

