/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttribute;
import software.amazon.awssdk.services.clouddirectory.model.UpdateActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FacetAttributeUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FacetAttributeUpdate> {
    private static final SdkField<FacetAttribute> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attribute").getter(FacetAttributeUpdate.getter(FacetAttributeUpdate::attribute)).setter(FacetAttributeUpdate.setter(Builder::attribute)).constructor(FacetAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(FacetAttributeUpdate.getter(FacetAttributeUpdate::actionAsString)).setter(FacetAttributeUpdate.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FacetAttributeUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FacetAttribute attribute;
    private final String action;

    private FacetAttributeUpdate(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.action = builder.action;
    }

    public final FacetAttribute attribute() {
        return this.attribute;
    }

    public final UpdateActionType action() {
        return UpdateActionType.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetAttributeUpdate)) {
            return false;
        }
        FacetAttributeUpdate other = (FacetAttributeUpdate)obj;
        return Objects.equals(this.attribute(), other.attribute()) && Objects.equals(this.actionAsString(), other.actionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FacetAttributeUpdate").add("Attribute", (Object)this.attribute()).add("Action", (Object)this.actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attribute()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Attribute", ATTRIBUTE_FIELD);
        map.put("Action", ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FacetAttributeUpdate, T> g) {
        return obj -> g.apply((FacetAttributeUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FacetAttribute attribute;
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(FacetAttributeUpdate model) {
            this.attribute(model.attribute);
            this.action(model.action);
        }

        public final FacetAttribute.Builder getAttribute() {
            return this.attribute != null ? this.attribute.toBuilder() : null;
        }

        public final void setAttribute(FacetAttribute.BuilderImpl attribute) {
            this.attribute = attribute != null ? attribute.build() : null;
        }

        @Override
        public final Builder attribute(FacetAttribute attribute) {
            this.attribute = attribute;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(UpdateActionType action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public FacetAttributeUpdate build() {
            return new FacetAttributeUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FacetAttributeUpdate> {
        public Builder attribute(FacetAttribute var1);

        default public Builder attribute(Consumer<FacetAttribute.Builder> attribute) {
            return this.attribute((FacetAttribute)((FacetAttribute.Builder)FacetAttribute.builder().applyMutation(attribute)).build());
        }

        public Builder action(String var1);

        public Builder action(UpdateActionType var1);
    }
}

