/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryServiceClientConfiguration;
import software.amazon.awssdk.services.clouddirectory.internal.CloudDirectoryServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.clouddirectory.model.AccessDeniedException;
import software.amazon.awssdk.services.clouddirectory.model.AddFacetToObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.AddFacetToObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.ApplySchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.ApplySchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachToIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachToIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadRequest;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteException;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteRequest;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteResponse;
import software.amazon.awssdk.services.clouddirectory.model.CannotListParentOfRootException;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryException;
import software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateTypedLinkFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateTypedLinkFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteTypedLinkFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteTypedLinkFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachFromIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachFromIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachTypedLinkRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachTypedLinkResponse;
import software.amazon.awssdk.services.clouddirectory.model.DirectoryAlreadyExistsException;
import software.amazon.awssdk.services.clouddirectory.model.DirectoryDeletedException;
import software.amazon.awssdk.services.clouddirectory.model.DirectoryNotDisabledException;
import software.amazon.awssdk.services.clouddirectory.model.DirectoryNotEnabledException;
import software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.FacetAlreadyExistsException;
import software.amazon.awssdk.services.clouddirectory.model.FacetInUseException;
import software.amazon.awssdk.services.clouddirectory.model.FacetNotFoundException;
import software.amazon.awssdk.services.clouddirectory.model.FacetValidationException;
import software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectInformationRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectInformationResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetTypedLinkFacetInformationRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetTypedLinkFacetInformationResponse;
import software.amazon.awssdk.services.clouddirectory.model.IncompatibleSchemaException;
import software.amazon.awssdk.services.clouddirectory.model.IndexedAttributeMissingException;
import software.amazon.awssdk.services.clouddirectory.model.InternalServiceException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidArnException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidAttachmentException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidFacetUpdateException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidNextTokenException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidRuleException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidSchemaDocException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidTaggingRequestException;
import software.amazon.awssdk.services.clouddirectory.model.LimitExceededException;
import software.amazon.awssdk.services.clouddirectory.model.LinkNameAlreadyInUseException;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListIncomingTypedLinksRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListIncomingTypedLinksResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListOutgoingTypedLinksRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListOutgoingTypedLinksResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.NotIndexException;
import software.amazon.awssdk.services.clouddirectory.model.NotNodeException;
import software.amazon.awssdk.services.clouddirectory.model.NotPolicyException;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAlreadyDetachedException;
import software.amazon.awssdk.services.clouddirectory.model.ObjectNotDetachedException;
import software.amazon.awssdk.services.clouddirectory.model.PublishSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.PublishSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonRequest;
import software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonResponse;
import software.amazon.awssdk.services.clouddirectory.model.RemoveFacetFromObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.RemoveFacetFromObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.ResourceNotFoundException;
import software.amazon.awssdk.services.clouddirectory.model.RetryableConflictException;
import software.amazon.awssdk.services.clouddirectory.model.SchemaAlreadyExistsException;
import software.amazon.awssdk.services.clouddirectory.model.SchemaAlreadyPublishedException;
import software.amazon.awssdk.services.clouddirectory.model.StillContainsLinksException;
import software.amazon.awssdk.services.clouddirectory.model.TagResourceRequest;
import software.amazon.awssdk.services.clouddirectory.model.TagResourceResponse;
import software.amazon.awssdk.services.clouddirectory.model.UnsupportedIndexTypeException;
import software.amazon.awssdk.services.clouddirectory.model.UntagResourceRequest;
import software.amazon.awssdk.services.clouddirectory.model.UntagResourceResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateLinkAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateLinkAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateObjectAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateTypedLinkFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateTypedLinkFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.ValidationException;
import software.amazon.awssdk.services.clouddirectory.transform.AddFacetToObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ApplySchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.AttachObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.AttachPolicyRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.AttachToIndexRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.AttachTypedLinkRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchReadRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchWriteRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateDirectoryRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateIndexRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateSchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateTypedLinkFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DeleteDirectoryRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DeleteFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DeleteObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DeleteSchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DeleteTypedLinkFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DetachFromIndexRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DetachObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DetachPolicyRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DetachTypedLinkRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DisableDirectoryRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.EnableDirectoryRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetAppliedSchemaVersionRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetDirectoryRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetLinkAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetObjectAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetObjectInformationRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetSchemaAsJsonRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetTypedLinkFacetInformationRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListAppliedSchemaArnsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListAttachedIndicesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListDevelopmentSchemaArnsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListFacetAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListFacetNamesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListIncomingTypedLinksRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListIndexRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListManagedSchemaArnsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListObjectAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListObjectChildrenRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListObjectParentPathsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListObjectParentsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListObjectPoliciesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListOutgoingTypedLinksRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListPolicyAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListPublishedSchemaArnsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListTypedLinkFacetAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListTypedLinkFacetNamesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.LookupPolicyRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.PublishSchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.PutSchemaFromJsonRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.RemoveFacetFromObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpdateFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpdateLinkAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpdateObjectAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpdateSchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpdateTypedLinkFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpgradeAppliedSchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpgradePublishedSchemaRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCloudDirectoryClient
implements CloudDirectoryClient {
    private static final Logger log = Logger.loggerFor(DefaultCloudDirectoryClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudDirectoryClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"CloudDirectory#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddFacetToObjectResponse addFacetToObject(AddFacetToObjectRequest addFacetToObjectRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, FacetValidationException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddFacetToObjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addFacetToObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, addFacetToObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddFacetToObject");
            AddFacetToObjectResponse addFacetToObjectResponse = (AddFacetToObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddFacetToObject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addFacetToObjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddFacetToObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addFacetToObjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$addFacetToObject$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplySchemaResponse applySchema(ApplySchemaRequest applySchemaRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, SchemaAlreadyExistsException, ResourceNotFoundException, InvalidAttachmentException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ApplySchemaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)applySchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, applySchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ApplySchema");
            ApplySchemaResponse applySchemaResponse = (ApplySchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplySchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)applySchemaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ApplySchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return applySchemaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$applySchema$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachObjectResponse attachObject(AttachObjectRequest attachObjectRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, LinkNameAlreadyInUseException, InvalidAttachmentException, FacetValidationException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachObjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, attachObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachObject");
            AttachObjectResponse attachObjectResponse = (AttachObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachObject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)attachObjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AttachObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return attachObjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$attachObject$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachPolicyResponse attachPolicy(AttachPolicyRequest attachPolicyRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, NotPolicyException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, attachPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachPolicy");
            AttachPolicyResponse attachPolicyResponse = (AttachPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)attachPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AttachPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return attachPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$attachPolicy$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachToIndexResponse attachToIndex(AttachToIndexRequest attachToIndexRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, InvalidAttachmentException, ResourceNotFoundException, LinkNameAlreadyInUseException, IndexedAttributeMissingException, NotIndexException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachToIndexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachToIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, attachToIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachToIndex");
            AttachToIndexResponse attachToIndexResponse = (AttachToIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachToIndex").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)attachToIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AttachToIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return attachToIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$attachToIndex$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachTypedLinkResponse attachTypedLink(AttachTypedLinkRequest attachTypedLinkRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, InvalidAttachmentException, FacetValidationException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachTypedLinkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachTypedLinkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, attachTypedLinkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachTypedLink");
            AttachTypedLinkResponse attachTypedLinkResponse = (AttachTypedLinkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachTypedLink").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)attachTypedLinkRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AttachTypedLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return attachTypedLinkResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$attachTypedLink$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchReadResponse batchRead(BatchReadRequest batchReadRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchReadResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchReadRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, batchReadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchRead");
            BatchReadResponse batchReadResponse = (BatchReadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchRead").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchReadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchReadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchReadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$batchRead$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchWriteResponse batchWrite(BatchWriteRequest batchWriteRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, BatchWriteException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchWriteResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchWriteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, batchWriteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchWrite");
            BatchWriteResponse batchWriteResponse = (BatchWriteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchWrite").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchWriteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchWriteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchWriteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$batchWrite$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDirectoryResponse createDirectory(CreateDirectoryRequest createDirectoryRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryAlreadyExistsException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, createDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDirectory");
            CreateDirectoryResponse createDirectoryResponse = (CreateDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$createDirectory$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFacetResponse createFacet(CreateFacetRequest createFacetRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, FacetAlreadyExistsException, InvalidRuleException, FacetValidationException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFacetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFacetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, createFacetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFacet");
            CreateFacetResponse createFacetResponse = (CreateFacetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFacet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createFacetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFacetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFacetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$createFacet$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateIndexResponse createIndex(CreateIndexRequest createIndexRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, FacetValidationException, LinkNameAlreadyInUseException, UnsupportedIndexTypeException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIndexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, createIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIndex");
            CreateIndexResponse createIndexResponse = (CreateIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIndex").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$createIndex$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateObjectResponse createObject(CreateObjectRequest createObjectRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, FacetValidationException, LinkNameAlreadyInUseException, UnsupportedIndexTypeException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateObjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, createObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateObject");
            CreateObjectResponse createObjectResponse = (CreateObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateObject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createObjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createObjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$createObject$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSchemaResponse createSchema(CreateSchemaRequest createSchemaRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, SchemaAlreadyExistsException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSchemaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, createSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSchema");
            CreateSchemaResponse createSchemaResponse = (CreateSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createSchemaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSchemaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$createSchema$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTypedLinkFacetResponse createTypedLinkFacet(CreateTypedLinkFacetRequest createTypedLinkFacetRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, FacetAlreadyExistsException, InvalidRuleException, FacetValidationException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTypedLinkFacetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTypedLinkFacetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, createTypedLinkFacetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTypedLinkFacet");
            CreateTypedLinkFacetResponse createTypedLinkFacetResponse = (CreateTypedLinkFacetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTypedLinkFacet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTypedLinkFacetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTypedLinkFacetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTypedLinkFacetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$createTypedLinkFacet$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDirectoryResponse deleteDirectory(DeleteDirectoryRequest deleteDirectoryRequest) throws ResourceNotFoundException, DirectoryNotDisabledException, InternalServiceException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryDeletedException, RetryableConflictException, InvalidArnException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, deleteDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDirectory");
            DeleteDirectoryResponse deleteDirectoryResponse = (DeleteDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$deleteDirectory$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFacetResponse deleteFacet(DeleteFacetRequest deleteFacetRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, FacetNotFoundException, FacetInUseException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFacetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFacetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, deleteFacetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFacet");
            DeleteFacetResponse deleteFacetResponse = (DeleteFacetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFacet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFacetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFacetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFacetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$deleteFacet$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteObjectResponse deleteObject(DeleteObjectRequest deleteObjectRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, ObjectNotDetachedException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteObjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, deleteObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteObject");
            DeleteObjectResponse deleteObjectResponse = (DeleteObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteObjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteObjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$deleteObject$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSchemaResponse deleteSchema(DeleteSchemaRequest deleteSchemaRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, StillContainsLinksException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSchemaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, deleteSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSchema");
            DeleteSchemaResponse deleteSchemaResponse = (DeleteSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSchemaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSchemaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$deleteSchema$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTypedLinkFacetResponse deleteTypedLinkFacet(DeleteTypedLinkFacetRequest deleteTypedLinkFacetRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, FacetNotFoundException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTypedLinkFacetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTypedLinkFacetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, deleteTypedLinkFacetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTypedLinkFacet");
            DeleteTypedLinkFacetResponse deleteTypedLinkFacetResponse = (DeleteTypedLinkFacetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTypedLinkFacet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTypedLinkFacetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTypedLinkFacetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTypedLinkFacetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$deleteTypedLinkFacet$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachFromIndexResponse detachFromIndex(DetachFromIndexRequest detachFromIndexRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, ObjectAlreadyDetachedException, NotIndexException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachFromIndexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachFromIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, detachFromIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachFromIndex");
            DetachFromIndexResponse detachFromIndexResponse = (DetachFromIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachFromIndex").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detachFromIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetachFromIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detachFromIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$detachFromIndex$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachObjectResponse detachObject(DetachObjectRequest detachObjectRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, NotNodeException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachObjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, detachObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachObject");
            DetachObjectResponse detachObjectResponse = (DetachObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachObject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detachObjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetachObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detachObjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$detachObject$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachPolicyResponse detachPolicy(DetachPolicyRequest detachPolicyRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, NotPolicyException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, detachPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachPolicy");
            DetachPolicyResponse detachPolicyResponse = (DetachPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detachPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetachPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detachPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$detachPolicy$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachTypedLinkResponse detachTypedLink(DetachTypedLinkRequest detachTypedLinkRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, FacetValidationException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachTypedLinkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachTypedLinkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, detachTypedLinkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachTypedLink");
            DetachTypedLinkResponse detachTypedLinkResponse = (DetachTypedLinkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachTypedLink").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detachTypedLinkRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetachTypedLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detachTypedLinkResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$detachTypedLink$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableDirectoryResponse disableDirectory(DisableDirectoryRequest disableDirectoryRequest) throws ResourceNotFoundException, DirectoryDeletedException, InternalServiceException, ValidationException, LimitExceededException, AccessDeniedException, RetryableConflictException, InvalidArnException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, disableDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableDirectory");
            DisableDirectoryResponse disableDirectoryResponse = (DisableDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$disableDirectory$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableDirectoryResponse enableDirectory(EnableDirectoryRequest enableDirectoryRequest) throws ResourceNotFoundException, DirectoryDeletedException, InternalServiceException, ValidationException, LimitExceededException, AccessDeniedException, RetryableConflictException, InvalidArnException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, enableDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableDirectory");
            EnableDirectoryResponse enableDirectoryResponse = (EnableDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$enableDirectory$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAppliedSchemaVersionResponse getAppliedSchemaVersion(GetAppliedSchemaVersionRequest getAppliedSchemaVersionRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppliedSchemaVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAppliedSchemaVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, getAppliedSchemaVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAppliedSchemaVersion");
            GetAppliedSchemaVersionResponse getAppliedSchemaVersionResponse = (GetAppliedSchemaVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAppliedSchemaVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAppliedSchemaVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAppliedSchemaVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAppliedSchemaVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$getAppliedSchemaVersion$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDirectoryResponse getDirectory(GetDirectoryRequest getDirectoryRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, getDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDirectory");
            GetDirectoryResponse getDirectoryResponse = (GetDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$getDirectory$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFacetResponse getFacet(GetFacetRequest getFacetRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, FacetNotFoundException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFacetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getFacetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, getFacetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFacet");
            GetFacetResponse getFacetResponse = (GetFacetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFacet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getFacetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetFacetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFacetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$getFacet$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLinkAttributesResponse getLinkAttributes(GetLinkAttributesRequest getLinkAttributesRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, FacetValidationException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLinkAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLinkAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, getLinkAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLinkAttributes");
            GetLinkAttributesResponse getLinkAttributesResponse = (GetLinkAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLinkAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getLinkAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLinkAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLinkAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$getLinkAttributes$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetObjectAttributesResponse getObjectAttributes(GetObjectAttributesRequest getObjectAttributesRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, FacetValidationException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetObjectAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getObjectAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, getObjectAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetObjectAttributes");
            GetObjectAttributesResponse getObjectAttributesResponse = (GetObjectAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getObjectAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetObjectAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getObjectAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$getObjectAttributes$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetObjectInformationResponse getObjectInformation(GetObjectInformationRequest getObjectInformationRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetObjectInformationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getObjectInformationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, getObjectInformationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetObjectInformation");
            GetObjectInformationResponse getObjectInformationResponse = (GetObjectInformationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectInformation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getObjectInformationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetObjectInformationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getObjectInformationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$getObjectInformation$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSchemaAsJsonResponse getSchemaAsJson(GetSchemaAsJsonRequest getSchemaAsJsonRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSchemaAsJsonResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSchemaAsJsonRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, getSchemaAsJsonRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSchemaAsJson");
            GetSchemaAsJsonResponse getSchemaAsJsonResponse = (GetSchemaAsJsonResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSchemaAsJson").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSchemaAsJsonRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSchemaAsJsonRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSchemaAsJsonResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$getSchemaAsJson$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTypedLinkFacetInformationResponse getTypedLinkFacetInformation(GetTypedLinkFacetInformationRequest getTypedLinkFacetInformationRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, InvalidNextTokenException, FacetNotFoundException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTypedLinkFacetInformationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTypedLinkFacetInformationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, getTypedLinkFacetInformationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTypedLinkFacetInformation");
            GetTypedLinkFacetInformationResponse getTypedLinkFacetInformationResponse = (GetTypedLinkFacetInformationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTypedLinkFacetInformation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTypedLinkFacetInformationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTypedLinkFacetInformationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTypedLinkFacetInformationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$getTypedLinkFacetInformation$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAppliedSchemaArnsResponse listAppliedSchemaArns(ListAppliedSchemaArnsRequest listAppliedSchemaArnsRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAppliedSchemaArnsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAppliedSchemaArnsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listAppliedSchemaArnsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAppliedSchemaArns");
            ListAppliedSchemaArnsResponse listAppliedSchemaArnsResponse = (ListAppliedSchemaArnsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAppliedSchemaArns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAppliedSchemaArnsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAppliedSchemaArnsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAppliedSchemaArnsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listAppliedSchemaArns$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAttachedIndicesResponse listAttachedIndices(ListAttachedIndicesRequest listAttachedIndicesRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAttachedIndicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAttachedIndicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listAttachedIndicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAttachedIndices");
            ListAttachedIndicesResponse listAttachedIndicesResponse = (ListAttachedIndicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAttachedIndices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAttachedIndicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAttachedIndicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAttachedIndicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listAttachedIndices$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDevelopmentSchemaArnsResponse listDevelopmentSchemaArns(ListDevelopmentSchemaArnsRequest listDevelopmentSchemaArnsRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevelopmentSchemaArnsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDevelopmentSchemaArnsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listDevelopmentSchemaArnsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDevelopmentSchemaArns");
            ListDevelopmentSchemaArnsResponse listDevelopmentSchemaArnsResponse = (ListDevelopmentSchemaArnsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevelopmentSchemaArns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDevelopmentSchemaArnsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDevelopmentSchemaArnsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDevelopmentSchemaArnsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listDevelopmentSchemaArns$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDirectoriesResponse listDirectories(ListDirectoriesRequest listDirectoriesRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, InvalidNextTokenException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDirectoriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDirectoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listDirectoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDirectories");
            ListDirectoriesResponse listDirectoriesResponse = (ListDirectoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDirectories").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDirectoriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDirectoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDirectoriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listDirectories$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFacetAttributesResponse listFacetAttributes(ListFacetAttributesRequest listFacetAttributesRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, FacetNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFacetAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFacetAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listFacetAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFacetAttributes");
            ListFacetAttributesResponse listFacetAttributesResponse = (ListFacetAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFacetAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listFacetAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFacetAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFacetAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listFacetAttributes$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFacetNamesResponse listFacetNames(ListFacetNamesRequest listFacetNamesRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFacetNamesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFacetNamesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listFacetNamesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFacetNames");
            ListFacetNamesResponse listFacetNamesResponse = (ListFacetNamesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFacetNames").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listFacetNamesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFacetNamesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFacetNamesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listFacetNames$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIncomingTypedLinksResponse listIncomingTypedLinks(ListIncomingTypedLinksRequest listIncomingTypedLinksRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, InvalidNextTokenException, FacetValidationException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIncomingTypedLinksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listIncomingTypedLinksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listIncomingTypedLinksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIncomingTypedLinks");
            ListIncomingTypedLinksResponse listIncomingTypedLinksResponse = (ListIncomingTypedLinksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIncomingTypedLinks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listIncomingTypedLinksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIncomingTypedLinksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIncomingTypedLinksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listIncomingTypedLinks$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIndexResponse listIndex(ListIndexRequest listIndexRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, FacetValidationException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, InvalidNextTokenException, ResourceNotFoundException, NotIndexException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIndexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIndex");
            ListIndexResponse listIndexResponse = (ListIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIndex").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listIndex$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListManagedSchemaArnsResponse listManagedSchemaArns(ListManagedSchemaArnsRequest listManagedSchemaArnsRequest) throws InternalServiceException, InvalidArnException, ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListManagedSchemaArnsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listManagedSchemaArnsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listManagedSchemaArnsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListManagedSchemaArns");
            ListManagedSchemaArnsResponse listManagedSchemaArnsResponse = (ListManagedSchemaArnsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListManagedSchemaArns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listManagedSchemaArnsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListManagedSchemaArnsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listManagedSchemaArnsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listManagedSchemaArns$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListObjectAttributesResponse listObjectAttributes(ListObjectAttributesRequest listObjectAttributesRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, InvalidNextTokenException, FacetValidationException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListObjectAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listObjectAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listObjectAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListObjectAttributes");
            ListObjectAttributesResponse listObjectAttributesResponse = (ListObjectAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listObjectAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListObjectAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listObjectAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listObjectAttributes$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListObjectChildrenResponse listObjectChildren(ListObjectChildrenRequest listObjectChildrenRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, InvalidNextTokenException, NotNodeException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListObjectChildrenResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listObjectChildrenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listObjectChildrenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListObjectChildren");
            ListObjectChildrenResponse listObjectChildrenResponse = (ListObjectChildrenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectChildren").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listObjectChildrenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListObjectChildrenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listObjectChildrenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listObjectChildren$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListObjectParentPathsResponse listObjectParentPaths(ListObjectParentPathsRequest listObjectParentPathsRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, InvalidNextTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListObjectParentPathsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listObjectParentPathsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listObjectParentPathsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListObjectParentPaths");
            ListObjectParentPathsResponse listObjectParentPathsResponse = (ListObjectParentPathsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectParentPaths").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listObjectParentPathsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListObjectParentPathsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listObjectParentPathsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listObjectParentPaths$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListObjectParentsResponse listObjectParents(ListObjectParentsRequest listObjectParentsRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, InvalidNextTokenException, CannotListParentOfRootException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListObjectParentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listObjectParentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listObjectParentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListObjectParents");
            ListObjectParentsResponse listObjectParentsResponse = (ListObjectParentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectParents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listObjectParentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListObjectParentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listObjectParentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listObjectParents$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListObjectPoliciesResponse listObjectPolicies(ListObjectPoliciesRequest listObjectPoliciesRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListObjectPoliciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listObjectPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listObjectPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListObjectPolicies");
            ListObjectPoliciesResponse listObjectPoliciesResponse = (ListObjectPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectPolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listObjectPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListObjectPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listObjectPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listObjectPolicies$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOutgoingTypedLinksResponse listOutgoingTypedLinks(ListOutgoingTypedLinksRequest listOutgoingTypedLinksRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, InvalidNextTokenException, FacetValidationException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOutgoingTypedLinksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listOutgoingTypedLinksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listOutgoingTypedLinksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOutgoingTypedLinks");
            ListOutgoingTypedLinksResponse listOutgoingTypedLinksResponse = (ListOutgoingTypedLinksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOutgoingTypedLinks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listOutgoingTypedLinksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOutgoingTypedLinksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOutgoingTypedLinksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listOutgoingTypedLinks$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPolicyAttachmentsResponse listPolicyAttachments(ListPolicyAttachmentsRequest listPolicyAttachmentsRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, InvalidNextTokenException, ResourceNotFoundException, NotPolicyException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPolicyAttachmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPolicyAttachmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listPolicyAttachmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPolicyAttachments");
            ListPolicyAttachmentsResponse listPolicyAttachmentsResponse = (ListPolicyAttachmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPolicyAttachments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPolicyAttachmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPolicyAttachmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPolicyAttachmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listPolicyAttachments$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPublishedSchemaArnsResponse listPublishedSchemaArns(ListPublishedSchemaArnsRequest listPublishedSchemaArnsRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPublishedSchemaArnsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPublishedSchemaArnsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listPublishedSchemaArnsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPublishedSchemaArns");
            ListPublishedSchemaArnsResponse listPublishedSchemaArnsResponse = (ListPublishedSchemaArnsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPublishedSchemaArns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPublishedSchemaArnsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPublishedSchemaArnsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPublishedSchemaArnsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listPublishedSchemaArns$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, InvalidTaggingRequestException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listTagsForResource$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTypedLinkFacetAttributesResponse listTypedLinkFacetAttributes(ListTypedLinkFacetAttributesRequest listTypedLinkFacetAttributesRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, FacetNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTypedLinkFacetAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTypedLinkFacetAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listTypedLinkFacetAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTypedLinkFacetAttributes");
            ListTypedLinkFacetAttributesResponse listTypedLinkFacetAttributesResponse = (ListTypedLinkFacetAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTypedLinkFacetAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTypedLinkFacetAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTypedLinkFacetAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTypedLinkFacetAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listTypedLinkFacetAttributes$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTypedLinkFacetNamesResponse listTypedLinkFacetNames(ListTypedLinkFacetNamesRequest listTypedLinkFacetNamesRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTypedLinkFacetNamesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTypedLinkFacetNamesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, listTypedLinkFacetNamesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTypedLinkFacetNames");
            ListTypedLinkFacetNamesResponse listTypedLinkFacetNamesResponse = (ListTypedLinkFacetNamesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTypedLinkFacetNames").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTypedLinkFacetNamesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTypedLinkFacetNamesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTypedLinkFacetNamesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$listTypedLinkFacetNames$105((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupPolicyResponse lookupPolicy(LookupPolicyRequest lookupPolicyRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, InvalidNextTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, LookupPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)lookupPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, lookupPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"LookupPolicy");
            LookupPolicyResponse lookupPolicyResponse = (LookupPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("LookupPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)lookupPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new LookupPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return lookupPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$lookupPolicy$107((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublishSchemaResponse publishSchema(PublishSchemaRequest publishSchemaRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, SchemaAlreadyPublishedException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PublishSchemaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)publishSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, publishSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PublishSchema");
            PublishSchemaResponse publishSchemaResponse = (PublishSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PublishSchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)publishSchemaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PublishSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return publishSchemaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$publishSchema$109((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutSchemaFromJsonResponse putSchemaFromJson(PutSchemaFromJsonRequest putSchemaFromJsonRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, InvalidSchemaDocException, InvalidRuleException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutSchemaFromJsonResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putSchemaFromJsonRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, putSchemaFromJsonRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutSchemaFromJson");
            PutSchemaFromJsonResponse putSchemaFromJsonResponse = (PutSchemaFromJsonResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutSchemaFromJson").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putSchemaFromJsonRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutSchemaFromJsonRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putSchemaFromJsonResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$putSchemaFromJson$111((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveFacetFromObjectResponse removeFacetFromObject(RemoveFacetFromObjectRequest removeFacetFromObjectRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, FacetValidationException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveFacetFromObjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeFacetFromObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, removeFacetFromObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveFacetFromObject");
            RemoveFacetFromObjectResponse removeFacetFromObjectResponse = (RemoveFacetFromObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveFacetFromObject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeFacetFromObjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveFacetFromObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeFacetFromObjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$removeFacetFromObject$113((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, InvalidTaggingRequestException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$tagResource$115((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, InvalidTaggingRequestException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$untagResource$117((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFacetResponse updateFacet(UpdateFacetRequest updateFacetRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, InvalidFacetUpdateException, FacetValidationException, ResourceNotFoundException, FacetNotFoundException, InvalidRuleException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFacetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFacetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, updateFacetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFacet");
            UpdateFacetResponse updateFacetResponse = (UpdateFacetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFacet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateFacetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFacetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFacetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$updateFacet$119((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLinkAttributesResponse updateLinkAttributes(UpdateLinkAttributesRequest updateLinkAttributesRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, FacetValidationException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLinkAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLinkAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, updateLinkAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLinkAttributes");
            UpdateLinkAttributesResponse updateLinkAttributesResponse = (UpdateLinkAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLinkAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateLinkAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLinkAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLinkAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$updateLinkAttributes$121((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateObjectAttributesResponse updateObjectAttributes(UpdateObjectAttributesRequest updateObjectAttributesRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, DirectoryNotEnabledException, ResourceNotFoundException, LinkNameAlreadyInUseException, FacetValidationException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateObjectAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateObjectAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, updateObjectAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateObjectAttributes");
            UpdateObjectAttributesResponse updateObjectAttributesResponse = (UpdateObjectAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateObjectAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateObjectAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateObjectAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateObjectAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$updateObjectAttributes$123((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSchemaResponse updateSchema(UpdateSchemaRequest updateSchemaRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSchemaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, updateSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSchema");
            UpdateSchemaResponse updateSchemaResponse = (UpdateSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateSchemaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSchemaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$updateSchema$125((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTypedLinkFacetResponse updateTypedLinkFacet(UpdateTypedLinkFacetRequest updateTypedLinkFacetRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, LimitExceededException, AccessDeniedException, FacetValidationException, InvalidFacetUpdateException, ResourceNotFoundException, FacetNotFoundException, InvalidRuleException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTypedLinkFacetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTypedLinkFacetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, updateTypedLinkFacetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTypedLinkFacet");
            UpdateTypedLinkFacetResponse updateTypedLinkFacetResponse = (UpdateTypedLinkFacetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTypedLinkFacet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTypedLinkFacetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTypedLinkFacetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTypedLinkFacetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$updateTypedLinkFacet$127((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradeAppliedSchemaResponse upgradeAppliedSchema(UpgradeAppliedSchemaRequest upgradeAppliedSchemaRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, IncompatibleSchemaException, AccessDeniedException, ResourceNotFoundException, InvalidAttachmentException, SchemaAlreadyExistsException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpgradeAppliedSchemaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)upgradeAppliedSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, upgradeAppliedSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpgradeAppliedSchema");
            UpgradeAppliedSchemaResponse upgradeAppliedSchemaResponse = (UpgradeAppliedSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpgradeAppliedSchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)upgradeAppliedSchemaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpgradeAppliedSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return upgradeAppliedSchemaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$upgradeAppliedSchema$129((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradePublishedSchemaResponse upgradePublishedSchema(UpgradePublishedSchemaRequest upgradePublishedSchemaRequest) throws InternalServiceException, InvalidArnException, RetryableConflictException, ValidationException, IncompatibleSchemaException, AccessDeniedException, ResourceNotFoundException, InvalidAttachmentException, LimitExceededException, AwsServiceException, SdkClientException, CloudDirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpgradePublishedSchemaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "FacetInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetInUseException::builder).build());
                }
                case "InvalidAttachmentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttachmentException::builder).build());
                }
                case "IndexedAttributeMissingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexedAttributeMissingException::builder).build());
                }
                case "IncompatibleSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSchemaException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "SchemaAlreadyPublishedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "StillContainsLinksException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StillContainsLinksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StillContainsLinksException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleException::builder).build());
                }
                case "DirectoryNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotEnabledException::builder).build());
                }
                case "FacetValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetValidationException::builder).build());
                }
                case "InvalidFacetUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFacetUpdateException::builder).build());
                }
                case "SchemaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "FacetAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetAlreadyExistsException::builder).build());
                }
                case "NotIndexException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotIndexException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotIndexException::builder).build());
                }
                case "ObjectAlreadyDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).build());
                }
                case "DirectoryDeletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDeletedException::builder).build());
                }
                case "RetryableConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RetryableConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(RetryableConflictException::builder).build());
                }
                case "BatchWriteException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build());
                }
                case "InvalidTaggingRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaggingRequestException::builder).build());
                }
                case "NotNodeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotNodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotNodeException::builder).build());
                }
                case "DirectoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "DirectoryNotDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotDisabledException::builder).build());
                }
                case "InvalidSchemaDocException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSchemaDocException::builder).build());
                }
                case "ObjectNotDetachedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotDetachedException::builder).build());
                }
                case "LinkNameAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).build());
                }
                case "CannotListParentOfRootException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotListParentOfRootException::builder).build());
                }
                case "NotPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotPolicyException::builder).build());
                }
                case "FacetNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FacetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FacetNotFoundException::builder).build());
                }
                case "UnsupportedIndexTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)upgradePublishedSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryClient.resolveMetricPublishers(clientConfiguration, upgradePublishedSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpgradePublishedSchema");
            UpgradePublishedSchemaResponse upgradePublishedSchemaResponse = (UpgradePublishedSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpgradePublishedSchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)upgradePublishedSchemaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpgradePublishedSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return upgradePublishedSchemaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryClient.lambda$upgradePublishedSchema$131((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "clouddirectory";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CloudDirectoryServiceClientConfigurationBuilder serviceConfigBuilder = new CloudDirectoryServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudDirectoryException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final CloudDirectoryServiceClientConfiguration serviceClientConfiguration() {
        return new CloudDirectoryServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$upgradePublishedSchema$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$upgradeAppliedSchema$129(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTypedLinkFacet$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSchema$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateObjectAttributes$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLinkAttributes$121(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFacet$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$117(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeFacetFromObject$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putSchemaFromJson$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$publishSchema$109(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$lookupPolicy$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTypedLinkFacetNames$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTypedLinkFacetAttributes$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPublishedSchemaArns$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPolicyAttachments$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOutgoingTypedLinks$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listObjectPolicies$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listObjectParents$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listObjectParentPaths$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listObjectChildren$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listObjectAttributes$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listManagedSchemaArns$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIndex$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIncomingTypedLinks$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFacetNames$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFacetAttributes$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDirectories$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDevelopmentSchemaArns$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAttachedIndices$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAppliedSchemaArns$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTypedLinkFacetInformation$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSchemaAsJson$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getObjectInformation$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getObjectAttributes$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLinkAttributes$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFacet$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDirectory$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAppliedSchemaVersion$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableDirectory$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableDirectory$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachTypedLink$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachPolicy$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachObject$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachFromIndex$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTypedLinkFacet$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSchema$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteObject$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFacet$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDirectory$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTypedLinkFacet$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSchema$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createObject$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createIndex$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFacet$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDirectory$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchWrite$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchRead$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachTypedLink$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachToIndex$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachPolicy$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachObject$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$applySchema$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addFacetToObject$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

