/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about the StackSet operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StackSetOperationStatusDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<StackSetOperationStatusDetails.Builder, StackSetOperationStatusDetails> {
    private static final SdkField<Integer> FAILED_STACK_INSTANCES_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("FailedStackInstancesCount")
            .getter(getter(StackSetOperationStatusDetails::failedStackInstancesCount))
            .setter(setter(Builder::failedStackInstancesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedStackInstancesCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FAILED_STACK_INSTANCES_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer failedStackInstancesCount;

    private StackSetOperationStatusDetails(BuilderImpl builder) {
        this.failedStackInstancesCount = builder.failedStackInstancesCount;
    }

    /**
     * <p>
     * The number of stack instances for which the StackSet operation failed.
     * </p>
     * 
     * @return The number of stack instances for which the StackSet operation failed.
     */
    public final Integer failedStackInstancesCount() {
        return failedStackInstancesCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failedStackInstancesCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetOperationStatusDetails)) {
            return false;
        }
        StackSetOperationStatusDetails other = (StackSetOperationStatusDetails) obj;
        return Objects.equals(failedStackInstancesCount(), other.failedStackInstancesCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StackSetOperationStatusDetails").add("FailedStackInstancesCount", failedStackInstancesCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedStackInstancesCount":
            return Optional.ofNullable(clazz.cast(failedStackInstancesCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackSetOperationStatusDetails, T> g) {
        return obj -> g.apply((StackSetOperationStatusDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StackSetOperationStatusDetails> {
        /**
         * <p>
         * The number of stack instances for which the StackSet operation failed.
         * </p>
         * 
         * @param failedStackInstancesCount
         *        The number of stack instances for which the StackSet operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedStackInstancesCount(Integer failedStackInstancesCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer failedStackInstancesCount;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetOperationStatusDetails model) {
            failedStackInstancesCount(model.failedStackInstancesCount);
        }

        public final Integer getFailedStackInstancesCount() {
            return failedStackInstancesCount;
        }

        public final void setFailedStackInstancesCount(Integer failedStackInstancesCount) {
            this.failedStackInstancesCount = failedStackInstancesCount;
        }

        @Override
        public final Builder failedStackInstancesCount(Integer failedStackInstancesCount) {
            this.failedStackInstancesCount = failedStackInstancesCount;
            return this;
        }

        @Override
        public StackSetOperationStatusDetails build() {
            return new StackSetOperationStatusDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
