/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The warnings generated for a specific resource for this generated template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WarningDetail implements SdkPojo, Serializable, ToCopyableBuilder<WarningDetail.Builder, WarningDetail> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(WarningDetail::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<WarningProperty>> PROPERTIES_FIELD = SdkField
            .<List<WarningProperty>> builder(MarshallingType.LIST)
            .memberName("Properties")
            .getter(getter(WarningDetail::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WarningProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(WarningProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final List<WarningProperty> properties;

    private WarningDetail(BuilderImpl builder) {
        this.type = builder.type;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The type of this warning. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/generate-IaC-write-only-properties.html">IaC
     * generator and write-only properties</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MUTUALLY_EXCLUSIVE_PROPERTIES</code> - The resource requires mutually-exclusive write-only properties. The
     * IaC generator selects one set of mutually exclusive properties and converts the included properties into
     * parameters. The parameter names have a suffix <code>OneOf</code> and the parameter descriptions indicate that the
     * corresponding property can be replaced with other exclusive properties.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNSUPPORTED_PROPERTIES</code> - Unsupported properties are present in the resource. One example of
     * unsupported properties would be a required write-only property that is an array, because a parameter cannot be an
     * array. Another example is an optional write-only property.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MUTUALLY_EXCLUSIVE_TYPES</code> - One or more required write-only properties are found in the resource, and
     * the type of that property can be any of several types.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Currently the resource and property reference documentation does not indicate if a property uses a type of
     * <code>oneOf</code> or <code>anyOf</code>. You need to look at the resource provider schema.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WarningType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of this warning. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/generate-IaC-write-only-properties.html"
     *         >IaC generator and write-only properties</a> in the <i>CloudFormation User Guide</i>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MUTUALLY_EXCLUSIVE_PROPERTIES</code> - The resource requires mutually-exclusive write-only
     *         properties. The IaC generator selects one set of mutually exclusive properties and converts the included
     *         properties into parameters. The parameter names have a suffix <code>OneOf</code> and the parameter
     *         descriptions indicate that the corresponding property can be replaced with other exclusive properties.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNSUPPORTED_PROPERTIES</code> - Unsupported properties are present in the resource. One example of
     *         unsupported properties would be a required write-only property that is an array, because a parameter
     *         cannot be an array. Another example is an optional write-only property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MUTUALLY_EXCLUSIVE_TYPES</code> - One or more required write-only properties are found in the
     *         resource, and the type of that property can be any of several types.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Currently the resource and property reference documentation does not indicate if a property uses a type
     *         of <code>oneOf</code> or <code>anyOf</code>. You need to look at the resource provider schema.
     *         </p>
     * @see WarningType
     */
    public final WarningType type() {
        return WarningType.fromValue(type);
    }

    /**
     * <p>
     * The type of this warning. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/generate-IaC-write-only-properties.html">IaC
     * generator and write-only properties</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MUTUALLY_EXCLUSIVE_PROPERTIES</code> - The resource requires mutually-exclusive write-only properties. The
     * IaC generator selects one set of mutually exclusive properties and converts the included properties into
     * parameters. The parameter names have a suffix <code>OneOf</code> and the parameter descriptions indicate that the
     * corresponding property can be replaced with other exclusive properties.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNSUPPORTED_PROPERTIES</code> - Unsupported properties are present in the resource. One example of
     * unsupported properties would be a required write-only property that is an array, because a parameter cannot be an
     * array. Another example is an optional write-only property.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MUTUALLY_EXCLUSIVE_TYPES</code> - One or more required write-only properties are found in the resource, and
     * the type of that property can be any of several types.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Currently the resource and property reference documentation does not indicate if a property uses a type of
     * <code>oneOf</code> or <code>anyOf</code>. You need to look at the resource provider schema.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WarningType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of this warning. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/generate-IaC-write-only-properties.html"
     *         >IaC generator and write-only properties</a> in the <i>CloudFormation User Guide</i>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MUTUALLY_EXCLUSIVE_PROPERTIES</code> - The resource requires mutually-exclusive write-only
     *         properties. The IaC generator selects one set of mutually exclusive properties and converts the included
     *         properties into parameters. The parameter names have a suffix <code>OneOf</code> and the parameter
     *         descriptions indicate that the corresponding property can be replaced with other exclusive properties.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNSUPPORTED_PROPERTIES</code> - Unsupported properties are present in the resource. One example of
     *         unsupported properties would be a required write-only property that is an array, because a parameter
     *         cannot be an array. Another example is an optional write-only property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MUTUALLY_EXCLUSIVE_TYPES</code> - One or more required write-only properties are found in the
     *         resource, and the type of that property can be any of several types.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Currently the resource and property reference documentation does not indicate if a property uses a type
     *         of <code>oneOf</code> or <code>anyOf</code>. You need to look at the resource provider schema.
     *         </p>
     * @see WarningType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties of the resource that are impacted by this warning.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return The properties of the resource that are impacted by this warning.
     */
    public final List<WarningProperty> properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WarningDetail)) {
            return false;
        }
        WarningDetail other = (WarningDetail) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && hasProperties() == other.hasProperties()
                && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WarningDetail").add("Type", typeAsString())
                .add("Properties", hasProperties() ? properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WarningDetail, T> g) {
        return obj -> g.apply((WarningDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WarningDetail> {
        /**
         * <p>
         * The type of this warning. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/generate-IaC-write-only-properties.html">IaC
         * generator and write-only properties</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MUTUALLY_EXCLUSIVE_PROPERTIES</code> - The resource requires mutually-exclusive write-only properties.
         * The IaC generator selects one set of mutually exclusive properties and converts the included properties into
         * parameters. The parameter names have a suffix <code>OneOf</code> and the parameter descriptions indicate that
         * the corresponding property can be replaced with other exclusive properties.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNSUPPORTED_PROPERTIES</code> - Unsupported properties are present in the resource. One example of
         * unsupported properties would be a required write-only property that is an array, because a parameter cannot
         * be an array. Another example is an optional write-only property.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MUTUALLY_EXCLUSIVE_TYPES</code> - One or more required write-only properties are found in the resource,
         * and the type of that property can be any of several types.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Currently the resource and property reference documentation does not indicate if a property uses a type of
         * <code>oneOf</code> or <code>anyOf</code>. You need to look at the resource provider schema.
         * </p>
         * </note>
         * 
         * @param type
         *        The type of this warning. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/generate-IaC-write-only-properties.html"
         *        >IaC generator and write-only properties</a> in the <i>CloudFormation User Guide</i>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MUTUALLY_EXCLUSIVE_PROPERTIES</code> - The resource requires mutually-exclusive write-only
         *        properties. The IaC generator selects one set of mutually exclusive properties and converts the
         *        included properties into parameters. The parameter names have a suffix <code>OneOf</code> and the
         *        parameter descriptions indicate that the corresponding property can be replaced with other exclusive
         *        properties.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNSUPPORTED_PROPERTIES</code> - Unsupported properties are present in the resource. One example
         *        of unsupported properties would be a required write-only property that is an array, because a
         *        parameter cannot be an array. Another example is an optional write-only property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MUTUALLY_EXCLUSIVE_TYPES</code> - One or more required write-only properties are found in the
         *        resource, and the type of that property can be any of several types.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Currently the resource and property reference documentation does not indicate if a property uses a
         *        type of <code>oneOf</code> or <code>anyOf</code>. You need to look at the resource provider schema.
         *        </p>
         * @see WarningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarningType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of this warning. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/generate-IaC-write-only-properties.html">IaC
         * generator and write-only properties</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MUTUALLY_EXCLUSIVE_PROPERTIES</code> - The resource requires mutually-exclusive write-only properties.
         * The IaC generator selects one set of mutually exclusive properties and converts the included properties into
         * parameters. The parameter names have a suffix <code>OneOf</code> and the parameter descriptions indicate that
         * the corresponding property can be replaced with other exclusive properties.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNSUPPORTED_PROPERTIES</code> - Unsupported properties are present in the resource. One example of
         * unsupported properties would be a required write-only property that is an array, because a parameter cannot
         * be an array. Another example is an optional write-only property.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MUTUALLY_EXCLUSIVE_TYPES</code> - One or more required write-only properties are found in the resource,
         * and the type of that property can be any of several types.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Currently the resource and property reference documentation does not indicate if a property uses a type of
         * <code>oneOf</code> or <code>anyOf</code>. You need to look at the resource provider schema.
         * </p>
         * </note>
         * 
         * @param type
         *        The type of this warning. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/generate-IaC-write-only-properties.html"
         *        >IaC generator and write-only properties</a> in the <i>CloudFormation User Guide</i>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MUTUALLY_EXCLUSIVE_PROPERTIES</code> - The resource requires mutually-exclusive write-only
         *        properties. The IaC generator selects one set of mutually exclusive properties and converts the
         *        included properties into parameters. The parameter names have a suffix <code>OneOf</code> and the
         *        parameter descriptions indicate that the corresponding property can be replaced with other exclusive
         *        properties.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNSUPPORTED_PROPERTIES</code> - Unsupported properties are present in the resource. One example
         *        of unsupported properties would be a required write-only property that is an array, because a
         *        parameter cannot be an array. Another example is an optional write-only property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MUTUALLY_EXCLUSIVE_TYPES</code> - One or more required write-only properties are found in the
         *        resource, and the type of that property can be any of several types.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Currently the resource and property reference documentation does not indicate if a property uses a
         *        type of <code>oneOf</code> or <code>anyOf</code>. You need to look at the resource provider schema.
         *        </p>
         * @see WarningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarningType
         */
        Builder type(WarningType type);

        /**
         * <p>
         * The properties of the resource that are impacted by this warning.
         * </p>
         * 
         * @param properties
         *        The properties of the resource that are impacted by this warning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Collection<WarningProperty> properties);

        /**
         * <p>
         * The properties of the resource that are impacted by this warning.
         * </p>
         * 
         * @param properties
         *        The properties of the resource that are impacted by this warning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(WarningProperty... properties);

        /**
         * <p>
         * The properties of the resource that are impacted by this warning.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.WarningProperty.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudformation.model.WarningProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.WarningProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #properties(List<WarningProperty>)}.
         * 
         * @param properties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.WarningProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(java.util.Collection<WarningProperty>)
         */
        Builder properties(Consumer<WarningProperty.Builder>... properties);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private List<WarningProperty> properties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WarningDetail model) {
            type(model.type);
            properties(model.properties);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WarningType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<WarningProperty.Builder> getProperties() {
            List<WarningProperty.Builder> result = WarningPropertiesCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProperties(Collection<WarningProperty.BuilderImpl> properties) {
            this.properties = WarningPropertiesCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Collection<WarningProperty> properties) {
            this.properties = WarningPropertiesCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(WarningProperty... properties) {
            properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<WarningProperty.Builder>... properties) {
            properties(Stream.of(properties).map(c -> WarningProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public WarningDetail build() {
            return new WarningDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
