/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A specific property that is impacted by a warning.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WarningProperty implements SdkPojo, Serializable, ToCopyableBuilder<WarningProperty.Builder, WarningProperty> {
    private static final SdkField<String> PROPERTY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PropertyPath").getter(getter(WarningProperty::propertyPath)).setter(setter(Builder::propertyPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyPath").build()).build();

    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Required").getter(getter(WarningProperty::required)).setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Required").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(WarningProperty::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_PATH_FIELD,
            REQUIRED_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String propertyPath;

    private final Boolean required;

    private final String description;

    private WarningProperty(BuilderImpl builder) {
        this.propertyPath = builder.propertyPath;
        this.required = builder.required;
        this.description = builder.description;
    }

    /**
     * <p>
     * The path of the property. For example, if this is for the <code>S3Bucket</code> member of the <code>Code</code>
     * property, the property path would be <code>Code/S3Bucket</code>.
     * </p>
     * 
     * @return The path of the property. For example, if this is for the <code>S3Bucket</code> member of the
     *         <code>Code</code> property, the property path would be <code>Code/S3Bucket</code>.
     */
    public final String propertyPath() {
        return propertyPath;
    }

    /**
     * <p>
     * If <code>true</code>, the specified property is required.
     * </p>
     * 
     * @return If <code>true</code>, the specified property is required.
     */
    public final Boolean required() {
        return required;
    }

    /**
     * <p>
     * The description of the property from the resource provider schema.
     * </p>
     * 
     * @return The description of the property from the resource provider schema.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(propertyPath());
        hashCode = 31 * hashCode + Objects.hashCode(required());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WarningProperty)) {
            return false;
        }
        WarningProperty other = (WarningProperty) obj;
        return Objects.equals(propertyPath(), other.propertyPath()) && Objects.equals(required(), other.required())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WarningProperty").add("PropertyPath", propertyPath()).add("Required", required())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PropertyPath":
            return Optional.ofNullable(clazz.cast(propertyPath()));
        case "Required":
            return Optional.ofNullable(clazz.cast(required()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WarningProperty, T> g) {
        return obj -> g.apply((WarningProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WarningProperty> {
        /**
         * <p>
         * The path of the property. For example, if this is for the <code>S3Bucket</code> member of the
         * <code>Code</code> property, the property path would be <code>Code/S3Bucket</code>.
         * </p>
         * 
         * @param propertyPath
         *        The path of the property. For example, if this is for the <code>S3Bucket</code> member of the
         *        <code>Code</code> property, the property path would be <code>Code/S3Bucket</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyPath(String propertyPath);

        /**
         * <p>
         * If <code>true</code>, the specified property is required.
         * </p>
         * 
         * @param required
         *        If <code>true</code>, the specified property is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(Boolean required);

        /**
         * <p>
         * The description of the property from the resource provider schema.
         * </p>
         * 
         * @param description
         *        The description of the property from the resource provider schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String propertyPath;

        private Boolean required;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(WarningProperty model) {
            propertyPath(model.propertyPath);
            required(model.required);
            description(model.description);
        }

        public final String getPropertyPath() {
            return propertyPath;
        }

        public final void setPropertyPath(String propertyPath) {
            this.propertyPath = propertyPath;
        }

        @Override
        public final Builder propertyPath(String propertyPath) {
            this.propertyPath = propertyPath;
            return this;
        }

        public final Boolean getRequired() {
            return required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public WarningProperty build() {
            return new WarningProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
