/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of a generated template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateSummary implements SdkPojo, Serializable, ToCopyableBuilder<TemplateSummary.Builder, TemplateSummary> {
    private static final SdkField<String> GENERATED_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedTemplateId").getter(getter(TemplateSummary::generatedTemplateId))
            .setter(setter(Builder::generatedTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedTemplateId").build())
            .build();

    private static final SdkField<String> GENERATED_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedTemplateName").getter(getter(TemplateSummary::generatedTemplateName))
            .setter(setter(Builder::generatedTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedTemplateName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TemplateSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(TemplateSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(TemplateSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(TemplateSummary::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<Integer> NUMBER_OF_RESOURCES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfResources").getter(getter(TemplateSummary::numberOfResources))
            .setter(setter(Builder::numberOfResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfResources").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_TEMPLATE_ID_FIELD,
            GENERATED_TEMPLATE_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD,
            NUMBER_OF_RESOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String generatedTemplateId;

    private final String generatedTemplateName;

    private final String status;

    private final String statusReason;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private final Integer numberOfResources;

    private TemplateSummary(BuilderImpl builder) {
        this.generatedTemplateId = builder.generatedTemplateId;
        this.generatedTemplateName = builder.generatedTemplateName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.numberOfResources = builder.numberOfResources;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the generated template. The format is
     * <code>arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}</code>. For example,
     * <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> </code>
     * .
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the generated template. The format is
     *         <code>arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}</code>. For example,
     *         <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> </code>
     *         .
     */
    public final String generatedTemplateId() {
        return generatedTemplateId;
    }

    /**
     * <p>
     * The name of the generated template.
     * </p>
     * 
     * @return The name of the generated template.
     */
    public final String generatedTemplateName() {
        return generatedTemplateName;
    }

    /**
     * <p>
     * The status of the template generation. Supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreatePending</code> - the creation of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreateInProgress</code> - the creation of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeletePending</code> - the deletion of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteInProgress</code> - the deletion of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdatePending</code> - the update of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdateInProgress</code> - the update of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - the template operation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Complete</code> - the template operation is complete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GeneratedTemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the template generation. Supported values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreatePending</code> - the creation of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreateInProgress</code> - the creation of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeletePending</code> - the deletion of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeleteInProgress</code> - the deletion of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdatePending</code> - the update of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdateInProgress</code> - the update of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - the template operation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Complete</code> - the template operation is complete.
     *         </p>
     *         </li>
     * @see GeneratedTemplateStatus
     */
    public final GeneratedTemplateStatus status() {
        return GeneratedTemplateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the template generation. Supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreatePending</code> - the creation of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreateInProgress</code> - the creation of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeletePending</code> - the deletion of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteInProgress</code> - the deletion of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdatePending</code> - the update of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdateInProgress</code> - the update of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - the template operation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Complete</code> - the template operation is complete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GeneratedTemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the template generation. Supported values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreatePending</code> - the creation of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreateInProgress</code> - the creation of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeletePending</code> - the deletion of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeleteInProgress</code> - the deletion of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdatePending</code> - the update of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdateInProgress</code> - the update of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - the template operation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Complete</code> - the template operation is complete.
     *         </p>
     *         </li>
     * @see GeneratedTemplateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the current template generation status. This will provide more details if a failure happened.
     * </p>
     * 
     * @return The reason for the current template generation status. This will provide more details if a failure
     *         happened.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The time the generated template was created.
     * </p>
     * 
     * @return The time the generated template was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the generated template was last updated.
     * </p>
     * 
     * @return The time the generated template was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The number of resources in the generated template. This is a total of resources in pending, in-progress,
     * completed, and failed states.
     * </p>
     * 
     * @return The number of resources in the generated template. This is a total of resources in pending, in-progress,
     *         completed, and failed states.
     */
    public final Integer numberOfResources() {
        return numberOfResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(generatedTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(generatedTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateSummary)) {
            return false;
        }
        TemplateSummary other = (TemplateSummary) obj;
        return Objects.equals(generatedTemplateId(), other.generatedTemplateId())
                && Objects.equals(generatedTemplateName(), other.generatedTemplateName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(numberOfResources(), other.numberOfResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateSummary").add("GeneratedTemplateId", generatedTemplateId())
                .add("GeneratedTemplateName", generatedTemplateName()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("CreationTime", creationTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("NumberOfResources", numberOfResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeneratedTemplateId":
            return Optional.ofNullable(clazz.cast(generatedTemplateId()));
        case "GeneratedTemplateName":
            return Optional.ofNullable(clazz.cast(generatedTemplateName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "NumberOfResources":
            return Optional.ofNullable(clazz.cast(numberOfResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateSummary, T> g) {
        return obj -> g.apply((TemplateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the generated template. The format is
         * <code>arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}</code>. For example,
         * <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> </code>
         * .
         * </p>
         * 
         * @param generatedTemplateId
         *        The Amazon Resource Name (ARN) of the generated template. The format is
         *        <code>arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}</code>. For
         *        example,
         *        <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> </code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedTemplateId(String generatedTemplateId);

        /**
         * <p>
         * The name of the generated template.
         * </p>
         * 
         * @param generatedTemplateName
         *        The name of the generated template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedTemplateName(String generatedTemplateName);

        /**
         * <p>
         * The status of the template generation. Supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CreatePending</code> - the creation of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreateInProgress</code> - the creation of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeletePending</code> - the deletion of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeleteInProgress</code> - the deletion of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdatePending</code> - the update of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdateInProgress</code> - the update of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - the template operation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Complete</code> - the template operation is complete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the template generation. Supported values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreatePending</code> - the creation of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreateInProgress</code> - the creation of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeletePending</code> - the deletion of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeleteInProgress</code> - the deletion of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdatePending</code> - the update of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdateInProgress</code> - the update of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - the template operation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Complete</code> - the template operation is complete.
         *        </p>
         *        </li>
         * @see GeneratedTemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedTemplateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the template generation. Supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CreatePending</code> - the creation of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreateInProgress</code> - the creation of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeletePending</code> - the deletion of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeleteInProgress</code> - the deletion of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdatePending</code> - the update of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdateInProgress</code> - the update of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - the template operation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Complete</code> - the template operation is complete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the template generation. Supported values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreatePending</code> - the creation of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreateInProgress</code> - the creation of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeletePending</code> - the deletion of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeleteInProgress</code> - the deletion of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdatePending</code> - the update of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdateInProgress</code> - the update of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - the template operation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Complete</code> - the template operation is complete.
         *        </p>
         *        </li>
         * @see GeneratedTemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedTemplateStatus
         */
        Builder status(GeneratedTemplateStatus status);

        /**
         * <p>
         * The reason for the current template generation status. This will provide more details if a failure happened.
         * </p>
         * 
         * @param statusReason
         *        The reason for the current template generation status. This will provide more details if a failure
         *        happened.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The time the generated template was created.
         * </p>
         * 
         * @param creationTime
         *        The time the generated template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the generated template was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time the generated template was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The number of resources in the generated template. This is a total of resources in pending, in-progress,
         * completed, and failed states.
         * </p>
         * 
         * @param numberOfResources
         *        The number of resources in the generated template. This is a total of resources in pending,
         *        in-progress, completed, and failed states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfResources(Integer numberOfResources);
    }

    static final class BuilderImpl implements Builder {
        private String generatedTemplateId;

        private String generatedTemplateName;

        private String status;

        private String statusReason;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private Integer numberOfResources;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateSummary model) {
            generatedTemplateId(model.generatedTemplateId);
            generatedTemplateName(model.generatedTemplateName);
            status(model.status);
            statusReason(model.statusReason);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
            numberOfResources(model.numberOfResources);
        }

        public final String getGeneratedTemplateId() {
            return generatedTemplateId;
        }

        public final void setGeneratedTemplateId(String generatedTemplateId) {
            this.generatedTemplateId = generatedTemplateId;
        }

        @Override
        public final Builder generatedTemplateId(String generatedTemplateId) {
            this.generatedTemplateId = generatedTemplateId;
            return this;
        }

        public final String getGeneratedTemplateName() {
            return generatedTemplateName;
        }

        public final void setGeneratedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
        }

        @Override
        public final Builder generatedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GeneratedTemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Integer getNumberOfResources() {
            return numberOfResources;
        }

        public final void setNumberOfResources(Integer numberOfResources) {
            this.numberOfResources = numberOfResources;
        }

        @Override
        public final Builder numberOfResources(Integer numberOfResources) {
            this.numberOfResources = numberOfResources;
            return this;
        }

        @Override
        public TemplateSummary build() {
            return new TemplateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
