/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceScanResourcesRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, ListResourceScanResourcesRequest> {
    private static final SdkField<String> RESOURCE_SCAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceScanId").getter(ListResourceScanResourcesRequest.getter(ListResourceScanResourcesRequest::resourceScanId)).setter(ListResourceScanResourcesRequest.setter(Builder::resourceScanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceScanId").build()}).build();
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdentifier").getter(ListResourceScanResourcesRequest.getter(ListResourceScanResourcesRequest::resourceIdentifier)).setter(ListResourceScanResourcesRequest.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceTypePrefix").getter(ListResourceScanResourcesRequest.getter(ListResourceScanResourcesRequest::resourceTypePrefix)).setter(ListResourceScanResourcesRequest.setter(Builder::resourceTypePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypePrefix").build()}).build();
    private static final SdkField<String> TAG_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagKey").getter(ListResourceScanResourcesRequest.getter(ListResourceScanResourcesRequest::tagKey)).setter(ListResourceScanResourcesRequest.setter(Builder::tagKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()}).build();
    private static final SdkField<String> TAG_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagValue").getter(ListResourceScanResourcesRequest.getter(ListResourceScanResourcesRequest::tagValue)).setter(ListResourceScanResourcesRequest.setter(Builder::tagValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValue").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceScanResourcesRequest.getter(ListResourceScanResourcesRequest::nextToken)).setter(ListResourceScanResourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListResourceScanResourcesRequest.getter(ListResourceScanResourcesRequest::maxResults)).setter(ListResourceScanResourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SCAN_ID_FIELD, RESOURCE_IDENTIFIER_FIELD, RESOURCE_TYPE_PREFIX_FIELD, TAG_KEY_FIELD, TAG_VALUE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String resourceScanId;
    private final String resourceIdentifier;
    private final String resourceTypePrefix;
    private final String tagKey;
    private final String tagValue;
    private final String nextToken;
    private final Integer maxResults;

    private ListResourceScanResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceScanId = builder.resourceScanId;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.resourceTypePrefix = builder.resourceTypePrefix;
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String resourceScanId() {
        return this.resourceScanId;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final String resourceTypePrefix() {
        return this.resourceTypePrefix;
    }

    public final String tagKey() {
        return this.tagKey;
    }

    public final String tagValue() {
        return this.tagValue;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceScanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceScanResourcesRequest)) {
            return false;
        }
        ListResourceScanResourcesRequest other = (ListResourceScanResourcesRequest)((Object)obj);
        return Objects.equals(this.resourceScanId(), other.resourceScanId()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.resourceTypePrefix(), other.resourceTypePrefix()) && Objects.equals(this.tagKey(), other.tagKey()) && Objects.equals(this.tagValue(), other.tagValue()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceScanResourcesRequest").add("ResourceScanId", (Object)this.resourceScanId()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("ResourceTypePrefix", (Object)this.resourceTypePrefix()).add("TagKey", (Object)this.tagKey()).add("TagValue", (Object)this.tagValue()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceScanId": {
                return Optional.ofNullable(clazz.cast(this.resourceScanId()));
            }
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "ResourceTypePrefix": {
                return Optional.ofNullable(clazz.cast(this.resourceTypePrefix()));
            }
            case "TagKey": {
                return Optional.ofNullable(clazz.cast(this.tagKey()));
            }
            case "TagValue": {
                return Optional.ofNullable(clazz.cast(this.tagValue()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceScanResourcesRequest, T> g) {
        return obj -> g.apply((ListResourceScanResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String resourceScanId;
        private String resourceIdentifier;
        private String resourceTypePrefix;
        private String tagKey;
        private String tagValue;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceScanResourcesRequest model) {
            super(model);
            this.resourceScanId(model.resourceScanId);
            this.resourceIdentifier(model.resourceIdentifier);
            this.resourceTypePrefix(model.resourceTypePrefix);
            this.tagKey(model.tagKey);
            this.tagValue(model.tagValue);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getResourceScanId() {
            return this.resourceScanId;
        }

        public final void setResourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
        }

        @Override
        public final Builder resourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
            return this;
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getResourceTypePrefix() {
            return this.resourceTypePrefix;
        }

        public final void setResourceTypePrefix(String resourceTypePrefix) {
            this.resourceTypePrefix = resourceTypePrefix;
        }

        @Override
        public final Builder resourceTypePrefix(String resourceTypePrefix) {
            this.resourceTypePrefix = resourceTypePrefix;
            return this;
        }

        public final String getTagKey() {
            return this.tagKey;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final String getTagValue() {
            return this.tagValue;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceScanResourcesRequest build() {
            return new ListResourceScanResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceScanResourcesRequest> {
        public Builder resourceScanId(String var1);

        public Builder resourceIdentifier(String var1);

        public Builder resourceTypePrefix(String var1);

        public Builder tagKey(String var1);

        public Builder tagValue(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

