/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WarningProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WarningProperty> {
    private static final SdkField<String> PROPERTY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PropertyPath").getter(WarningProperty.getter(WarningProperty::propertyPath)).setter(WarningProperty.setter(Builder::propertyPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyPath").build()}).build();
    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Required").getter(WarningProperty.getter(WarningProperty::required)).setter(WarningProperty.setter(Builder::required)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Required").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(WarningProperty.getter(WarningProperty::description)).setter(WarningProperty.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_PATH_FIELD, REQUIRED_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String propertyPath;
    private final Boolean required;
    private final String description;

    private WarningProperty(BuilderImpl builder) {
        this.propertyPath = builder.propertyPath;
        this.required = builder.required;
        this.description = builder.description;
    }

    public final String propertyPath() {
        return this.propertyPath;
    }

    public final Boolean required() {
        return this.required;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.required());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WarningProperty)) {
            return false;
        }
        WarningProperty other = (WarningProperty)obj;
        return Objects.equals(this.propertyPath(), other.propertyPath()) && Objects.equals(this.required(), other.required()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"WarningProperty").add("PropertyPath", (Object)this.propertyPath()).add("Required", (Object)this.required()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PropertyPath": {
                return Optional.ofNullable(clazz.cast(this.propertyPath()));
            }
            case "Required": {
                return Optional.ofNullable(clazz.cast(this.required()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WarningProperty, T> g) {
        return obj -> g.apply((WarningProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String propertyPath;
        private Boolean required;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(WarningProperty model) {
            this.propertyPath(model.propertyPath);
            this.required(model.required);
            this.description(model.description);
        }

        public final String getPropertyPath() {
            return this.propertyPath;
        }

        public final void setPropertyPath(String propertyPath) {
            this.propertyPath = propertyPath;
        }

        @Override
        public final Builder propertyPath(String propertyPath) {
            this.propertyPath = propertyPath;
            return this;
        }

        public final Boolean getRequired() {
            return this.required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public WarningProperty build() {
            return new WarningProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WarningProperty> {
        public Builder propertyPath(String var1);

        public Builder required(Boolean var1);

        public Builder description(String var1);
    }
}

