/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CallAs;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus;
import software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatusFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStackInstanceResourceDriftsRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, ListStackInstanceResourceDriftsRequest> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackSetName").getter(ListStackInstanceResourceDriftsRequest.getter(ListStackInstanceResourceDriftsRequest::stackSetName)).setter(ListStackInstanceResourceDriftsRequest.setter(Builder::stackSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStackInstanceResourceDriftsRequest.getter(ListStackInstanceResourceDriftsRequest::nextToken)).setter(ListStackInstanceResourceDriftsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListStackInstanceResourceDriftsRequest.getter(ListStackInstanceResourceDriftsRequest::maxResults)).setter(ListStackInstanceResourceDriftsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<List<String>> STACK_INSTANCE_RESOURCE_DRIFT_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackInstanceResourceDriftStatuses").getter(ListStackInstanceResourceDriftsRequest.getter(ListStackInstanceResourceDriftsRequest::stackInstanceResourceDriftStatusesAsStrings)).setter(ListStackInstanceResourceDriftsRequest.setter(Builder::stackInstanceResourceDriftStatusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstanceResourceDriftStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STACK_INSTANCE_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackInstanceAccount").getter(ListStackInstanceResourceDriftsRequest.getter(ListStackInstanceResourceDriftsRequest::stackInstanceAccount)).setter(ListStackInstanceResourceDriftsRequest.setter(Builder::stackInstanceAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstanceAccount").build()}).build();
    private static final SdkField<String> STACK_INSTANCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackInstanceRegion").getter(ListStackInstanceResourceDriftsRequest.getter(ListStackInstanceResourceDriftsRequest::stackInstanceRegion)).setter(ListStackInstanceResourceDriftsRequest.setter(Builder::stackInstanceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstanceRegion").build()}).build();
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationId").getter(ListStackInstanceResourceDriftsRequest.getter(ListStackInstanceResourceDriftsRequest::operationId)).setter(ListStackInstanceResourceDriftsRequest.setter(Builder::operationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()}).build();
    private static final SdkField<String> CALL_AS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallAs").getter(ListStackInstanceResourceDriftsRequest.getter(ListStackInstanceResourceDriftsRequest::callAsAsString)).setter(ListStackInstanceResourceDriftsRequest.setter(Builder::callAs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STACK_INSTANCE_RESOURCE_DRIFT_STATUSES_FIELD, STACK_INSTANCE_ACCOUNT_FIELD, STACK_INSTANCE_REGION_FIELD, OPERATION_ID_FIELD, CALL_AS_FIELD));
    private final String stackSetName;
    private final String nextToken;
    private final Integer maxResults;
    private final List<String> stackInstanceResourceDriftStatuses;
    private final String stackInstanceAccount;
    private final String stackInstanceRegion;
    private final String operationId;
    private final String callAs;

    private ListStackInstanceResourceDriftsRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.stackInstanceResourceDriftStatuses = builder.stackInstanceResourceDriftStatuses;
        this.stackInstanceAccount = builder.stackInstanceAccount;
        this.stackInstanceRegion = builder.stackInstanceRegion;
        this.operationId = builder.operationId;
        this.callAs = builder.callAs;
    }

    public final String stackSetName() {
        return this.stackSetName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final List<StackResourceDriftStatus> stackInstanceResourceDriftStatuses() {
        return StackResourceDriftStatusFiltersCopier.copyStringToEnum(this.stackInstanceResourceDriftStatuses);
    }

    public final boolean hasStackInstanceResourceDriftStatuses() {
        return this.stackInstanceResourceDriftStatuses != null && !(this.stackInstanceResourceDriftStatuses instanceof SdkAutoConstructList);
    }

    public final List<String> stackInstanceResourceDriftStatusesAsStrings() {
        return this.stackInstanceResourceDriftStatuses;
    }

    public final String stackInstanceAccount() {
        return this.stackInstanceAccount;
    }

    public final String stackInstanceRegion() {
        return this.stackInstanceRegion;
    }

    public final String operationId() {
        return this.operationId;
    }

    public final CallAs callAs() {
        return CallAs.fromValue(this.callAs);
    }

    public final String callAsAsString() {
        return this.callAs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackInstanceResourceDriftStatuses() ? this.stackInstanceResourceDriftStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stackInstanceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackInstanceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.callAsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackInstanceResourceDriftsRequest)) {
            return false;
        }
        ListStackInstanceResourceDriftsRequest other = (ListStackInstanceResourceDriftsRequest)((Object)obj);
        return Objects.equals(this.stackSetName(), other.stackSetName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasStackInstanceResourceDriftStatuses() == other.hasStackInstanceResourceDriftStatuses() && Objects.equals(this.stackInstanceResourceDriftStatusesAsStrings(), other.stackInstanceResourceDriftStatusesAsStrings()) && Objects.equals(this.stackInstanceAccount(), other.stackInstanceAccount()) && Objects.equals(this.stackInstanceRegion(), other.stackInstanceRegion()) && Objects.equals(this.operationId(), other.operationId()) && Objects.equals(this.callAsAsString(), other.callAsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListStackInstanceResourceDriftsRequest").add("StackSetName", (Object)this.stackSetName()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("StackInstanceResourceDriftStatuses", this.hasStackInstanceResourceDriftStatuses() ? this.stackInstanceResourceDriftStatusesAsStrings() : null).add("StackInstanceAccount", (Object)this.stackInstanceAccount()).add("StackInstanceRegion", (Object)this.stackInstanceRegion()).add("OperationId", (Object)this.operationId()).add("CallAs", (Object)this.callAsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetName": {
                return Optional.ofNullable(clazz.cast(this.stackSetName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "StackInstanceResourceDriftStatuses": {
                return Optional.ofNullable(clazz.cast(this.stackInstanceResourceDriftStatusesAsStrings()));
            }
            case "StackInstanceAccount": {
                return Optional.ofNullable(clazz.cast(this.stackInstanceAccount()));
            }
            case "StackInstanceRegion": {
                return Optional.ofNullable(clazz.cast(this.stackInstanceRegion()));
            }
            case "OperationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
            case "CallAs": {
                return Optional.ofNullable(clazz.cast(this.callAsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStackInstanceResourceDriftsRequest, T> g) {
        return obj -> g.apply((ListStackInstanceResourceDriftsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackSetName;
        private String nextToken;
        private Integer maxResults;
        private List<String> stackInstanceResourceDriftStatuses = DefaultSdkAutoConstructList.getInstance();
        private String stackInstanceAccount;
        private String stackInstanceRegion;
        private String operationId;
        private String callAs;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackInstanceResourceDriftsRequest model) {
            super(model);
            this.stackSetName(model.stackSetName);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.stackInstanceResourceDriftStatusesWithStrings(model.stackInstanceResourceDriftStatuses);
            this.stackInstanceAccount(model.stackInstanceAccount);
            this.stackInstanceRegion(model.stackInstanceRegion);
            this.operationId(model.operationId);
            this.callAs(model.callAs);
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getStackInstanceResourceDriftStatuses() {
            if (this.stackInstanceResourceDriftStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stackInstanceResourceDriftStatuses;
        }

        public final void setStackInstanceResourceDriftStatuses(Collection<String> stackInstanceResourceDriftStatuses) {
            this.stackInstanceResourceDriftStatuses = StackResourceDriftStatusFiltersCopier.copy(stackInstanceResourceDriftStatuses);
        }

        @Override
        public final Builder stackInstanceResourceDriftStatusesWithStrings(Collection<String> stackInstanceResourceDriftStatuses) {
            this.stackInstanceResourceDriftStatuses = StackResourceDriftStatusFiltersCopier.copy(stackInstanceResourceDriftStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackInstanceResourceDriftStatusesWithStrings(String ... stackInstanceResourceDriftStatuses) {
            this.stackInstanceResourceDriftStatusesWithStrings(Arrays.asList(stackInstanceResourceDriftStatuses));
            return this;
        }

        @Override
        public final Builder stackInstanceResourceDriftStatuses(Collection<StackResourceDriftStatus> stackInstanceResourceDriftStatuses) {
            this.stackInstanceResourceDriftStatuses = StackResourceDriftStatusFiltersCopier.copyEnumToString(stackInstanceResourceDriftStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackInstanceResourceDriftStatuses(StackResourceDriftStatus ... stackInstanceResourceDriftStatuses) {
            this.stackInstanceResourceDriftStatuses(Arrays.asList(stackInstanceResourceDriftStatuses));
            return this;
        }

        public final String getStackInstanceAccount() {
            return this.stackInstanceAccount;
        }

        public final void setStackInstanceAccount(String stackInstanceAccount) {
            this.stackInstanceAccount = stackInstanceAccount;
        }

        @Override
        public final Builder stackInstanceAccount(String stackInstanceAccount) {
            this.stackInstanceAccount = stackInstanceAccount;
            return this;
        }

        public final String getStackInstanceRegion() {
            return this.stackInstanceRegion;
        }

        public final void setStackInstanceRegion(String stackInstanceRegion) {
            this.stackInstanceRegion = stackInstanceRegion;
        }

        @Override
        public final Builder stackInstanceRegion(String stackInstanceRegion) {
            this.stackInstanceRegion = stackInstanceRegion;
            return this;
        }

        public final String getOperationId() {
            return this.operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final String getCallAs() {
            return this.callAs;
        }

        public final void setCallAs(String callAs) {
            this.callAs = callAs;
        }

        @Override
        public final Builder callAs(String callAs) {
            this.callAs = callAs;
            return this;
        }

        @Override
        public final Builder callAs(CallAs callAs) {
            this.callAs(callAs == null ? null : callAs.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStackInstanceResourceDriftsRequest build() {
            return new ListStackInstanceResourceDriftsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStackInstanceResourceDriftsRequest> {
        public Builder stackSetName(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder stackInstanceResourceDriftStatusesWithStrings(Collection<String> var1);

        public Builder stackInstanceResourceDriftStatusesWithStrings(String ... var1);

        public Builder stackInstanceResourceDriftStatuses(Collection<StackResourceDriftStatus> var1);

        public Builder stackInstanceResourceDriftStatuses(StackResourceDriftStatus ... var1);

        public Builder stackInstanceAccount(String var1);

        public Builder stackInstanceRegion(String var1);

        public Builder operationId(String var1);

        public Builder callAs(String var1);

        public Builder callAs(CallAs var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

