/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorAction;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStackRefactorActionsResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListStackRefactorActionsResponse> {
    private static final SdkField<List<StackRefactorAction>> STACK_REFACTOR_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackRefactorActions").getter(ListStackRefactorActionsResponse.getter(ListStackRefactorActionsResponse::stackRefactorActions)).setter(ListStackRefactorActionsResponse.setter(Builder::stackRefactorActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackRefactorActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StackRefactorAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStackRefactorActionsResponse.getter(ListStackRefactorActionsResponse::nextToken)).setter(ListStackRefactorActionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_REFACTOR_ACTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListStackRefactorActionsResponse.memberNameToFieldInitializer();
    private final List<StackRefactorAction> stackRefactorActions;
    private final String nextToken;

    private ListStackRefactorActionsResponse(BuilderImpl builder) {
        super(builder);
        this.stackRefactorActions = builder.stackRefactorActions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStackRefactorActions() {
        return this.stackRefactorActions != null && !(this.stackRefactorActions instanceof SdkAutoConstructList);
    }

    public final List<StackRefactorAction> stackRefactorActions() {
        return this.stackRefactorActions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackRefactorActions() ? this.stackRefactorActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackRefactorActionsResponse)) {
            return false;
        }
        ListStackRefactorActionsResponse other = (ListStackRefactorActionsResponse)((Object)obj);
        return this.hasStackRefactorActions() == other.hasStackRefactorActions() && Objects.equals(this.stackRefactorActions(), other.stackRefactorActions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStackRefactorActionsResponse").add("StackRefactorActions", this.hasStackRefactorActions() ? this.stackRefactorActions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackRefactorActions": {
                return Optional.ofNullable(clazz.cast(this.stackRefactorActions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackRefactorActions", STACK_REFACTOR_ACTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStackRefactorActionsResponse, T> g) {
        return obj -> g.apply((ListStackRefactorActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<StackRefactorAction> stackRefactorActions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackRefactorActionsResponse model) {
            super(model);
            this.stackRefactorActions(model.stackRefactorActions);
            this.nextToken(model.nextToken);
        }

        public final List<StackRefactorAction.Builder> getStackRefactorActions() {
            List<StackRefactorAction.Builder> result = StackRefactorActionsCopier.copyToBuilder(this.stackRefactorActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStackRefactorActions(Collection<StackRefactorAction.BuilderImpl> stackRefactorActions) {
            this.stackRefactorActions = StackRefactorActionsCopier.copyFromBuilder(stackRefactorActions);
        }

        @Override
        public final Builder stackRefactorActions(Collection<StackRefactorAction> stackRefactorActions) {
            this.stackRefactorActions = StackRefactorActionsCopier.copy(stackRefactorActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackRefactorActions(StackRefactorAction ... stackRefactorActions) {
            this.stackRefactorActions(Arrays.asList(stackRefactorActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackRefactorActions(Consumer<StackRefactorAction.Builder> ... stackRefactorActions) {
            this.stackRefactorActions(Stream.of(stackRefactorActions).map(c -> (StackRefactorAction)((StackRefactorAction.Builder)StackRefactorAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStackRefactorActionsResponse build() {
            return new ListStackRefactorActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStackRefactorActionsResponse> {
        public Builder stackRefactorActions(Collection<StackRefactorAction> var1);

        public Builder stackRefactorActions(StackRefactorAction ... var1);

        public Builder stackRefactorActions(Consumer<StackRefactorAction.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

